/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.client.integration.jei.categories;

import com.cannolicatfish.rankine.init.RankineItems;
import com.cannolicatfish.rankine.recipe.CrushingRecipe;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class CrushingRecipeCategory
implements IRecipeCategory<CrushingRecipe> {
    public static ResourceLocation UID = new ResourceLocation("rankine", "crushing");
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;

    public CrushingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(145, 140);
        this.localizedName = I18n.func_135052_a((String)"rankine.jei.crushing", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("rankine", "textures/gui/crushing_jei.png"), 0, 15, 140, 160);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)RankineItems.STEEL_HAMMER.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends CrushingRecipe> getRecipeClass() {
        return CrushingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(CrushingRecipe recipe, MatrixStack ms, double mouseX, double mouseY) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.overlay.draw(ms, 0, 4);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        for (int i = 0; i < 6; ++i) {
            String s = Math.round(((Float)recipe.getChances().get(i)).floatValue() * 100.0f) + "%";
            int ymod = i > 2 ? 36 : 0;
            int xmod = i > 2 ? 45 * (i - 3) : 45 * i;
            font.func_238421_b_(ms, s, (float)(27 + xmod - font.func_78256_a(s) / 2), (float)(80 + ymod), 0);
            String t = "+" + Math.round(((Float)recipe.getAdditional().get(i)).floatValue() * 100.0f) + "%";
            font.func_238421_b_(ms, t, (float)(26 + xmod - font.func_78256_a(t) / 2), (float)(88 + ymod), 43520);
        }
    }

    public void setIngredients(CrushingRecipe recipe, IIngredients iIngredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Ingredient i : recipe.func_192400_c()) {
            builder.add(Arrays.asList(i.func_193365_a()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, (List)builder.build());
        iIngredients.setOutputs(VanillaTypes.ITEM, recipe.getRecipeOutputsJEI());
    }

    public void setRecipe(IRecipeLayout recipeLayout, CrushingRecipe recipe, IIngredients ingredients) {
        int index = 0;
        for (List o : ingredients.getInputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(index, true, 63, 10);
            recipeLayout.getItemStacks().set(index, o);
            ++index;
        }
        for (int i = 0; i < ingredients.getOutputs(VanillaTypes.ITEM).size(); ++i) {
            List stacks = (List)ingredients.getOutputs(VanillaTypes.ITEM).get(i);
            int ymod = i > 2 ? 36 : 0;
            int xmod = i > 2 ? 45 * (i - 3) : 45 * i;
            recipeLayout.getItemStacks().init(index + i, false, 18 + xmod, 60 + ymod);
            if (stacks.contains(ItemStack.field_190927_a) || !stacks.stream().noneMatch(s -> s.func_77973_b() == RankineItems.ELEMENT.get())) continue;
            recipeLayout.getItemStacks().set(index + i, stacks);
        }
    }
}

