/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.client.integration.jei.categories;

import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.recipe.EvaporationRecipe;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.StringTextComponent;

public class EvaporationRecipeCategory
implements IRecipeCategory<EvaporationRecipe> {
    public static ResourceLocation UID = new ResourceLocation("rankine", "evaporation");
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;

    public EvaporationRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(185, 146);
        this.localizedName = I18n.func_135052_a((String)"rankine.jei.evaporation", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("rankine", "textures/gui/evaporation_jei.png"), 0, 15, 180, 141);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)RankineBlocks.EVAPORATION_TOWER.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends EvaporationRecipe> getRecipeClass() {
        return EvaporationRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(EvaporationRecipe recipe, MatrixStack ms, double mouseX, double mouseY) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.overlay.draw(ms, 0, 4);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        String s = "Made in:";
        String large = recipe.isLarge() ? "Evaporation Tower" : "Evaporation Boiler";
        int ymod = 0;
        if (!recipe.getBiomeString().isEmpty()) {
            StringBuilder str = new StringBuilder();
            str.append("Biomes: ");
            int count = 1;
            for (int i = 0; i < recipe.getBiomeString().size(); ++i) {
                str.append(recipe.getBiomeString().get(i));
                if (++count == 3 || i == recipe.getBiomeString().size() - 1) {
                    font.func_238421_b_(ms, str.toString(), (float)(ymod >= 50 ? 32 : 0), (float)ymod, 0);
                    count = 0;
                    ymod += 10;
                    str = new StringBuilder();
                    continue;
                }
                if (i == recipe.getBiomeString().size() - 1) continue;
                str.append(", ");
            }
        }
        int r = ymod + 10 >= 50 ? 32 : 0;
        font.func_238421_b_(ms, s, (float)r, (float)ymod, 0);
        font.func_238421_b_(ms, large, (float)r, (float)(ymod += 10), recipe.isLarge() ? 0xAA0000 : 43520);
    }

    public void setIngredients(EvaporationRecipe recipe, IIngredients iIngredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Ingredient i : recipe.getJEIIngredient()) {
            builder.add(Arrays.asList(i.func_193365_a()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, (List)builder.build());
        iIngredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputs());
    }

    public void setRecipe(IRecipeLayout recipeLayout, EvaporationRecipe recipe, IIngredients ingredients) {
        int index = 0;
        int posX = 23;
        for (List o : ingredients.getInputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(index, true, 4, 54);
            recipeLayout.getItemStacks().set(index, o);
            ++index;
        }
        int reducer = 0;
        int ymod = -1;
        int outputcount = 0;
        for (List o : ingredients.getOutputs(VanillaTypes.ITEM)) {
            if (outputcount % 10 == 0) {
                reducer = index - 1;
                ++ymod;
            }
            recipeLayout.getItemStacks().init(index, true, (outputcount - reducer) * 18, 80 + ymod * 18);
            recipeLayout.getItemStacks().set(index, o);
            ++outputcount;
            ++index;
        }
        recipeLayout.getItemStacks().addTooltipCallback((i, b, stack, list) -> {
            DecimalFormat df = (DecimalFormat)Util.func_200696_a((Object)new DecimalFormat("##.##"), p_234699_0_ -> p_234699_0_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            if (i != 0) {
                list.add(new StringTextComponent("Chance: " + df.format(recipe.getChance(i - 1).floatValue() * 100.0f) + "%"));
            }
        });
    }
}

