/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.client.integration.jei.categories;

import com.cannolicatfish.rankine.init.RankineItems;
import com.cannolicatfish.rankine.recipe.SluicingRecipe;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.StringTextComponent;

public class SluicingRecipeCategory
implements IRecipeCategory<SluicingRecipe> {
    public static ResourceLocation UID = new ResourceLocation("rankine", "sluicing");
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;

    public SluicingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(145, 125);
        this.localizedName = I18n.func_135052_a((String)"rankine.jei.sluicing", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("rankine", "textures/gui/sluicing_jei.png"), 0, 15, 140, 120);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)RankineItems.STEEL_GOLD_PAN.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends SluicingRecipe> getRecipeClass() {
        return SluicingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(SluicingRecipe recipe, MatrixStack ms, double mouseX, double mouseY) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.overlay.draw(ms, 0, 4);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
    }

    public void setIngredients(SluicingRecipe recipe, IIngredients iIngredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Ingredient i : recipe.func_192400_c()) {
            builder.add(Arrays.asList(i.func_193365_a()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, (List)builder.build());
        iIngredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputs());
    }

    public void setRecipe(IRecipeLayout recipeLayout, SluicingRecipe recipe, IIngredients ingredients) {
        int index = 0;
        int posX = 23;
        for (List o : ingredients.getInputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(index, true, 63, 10);
            recipeLayout.getItemStacks().set(index, o);
            ++index;
        }
        int reducer = 0;
        int ymod = -1;
        int outputcount = 0;
        for (List o : ingredients.getOutputs(VanillaTypes.ITEM)) {
            if (outputcount % 6 == 0) {
                reducer = index - 2;
                ++ymod;
            }
            recipeLayout.getItemStacks().init(index, true, (outputcount - reducer) * 18, 48 + ymod * 18);
            recipeLayout.getItemStacks().set(index, o);
            ++outputcount;
            ++index;
        }
        recipeLayout.getItemStacks().addTooltipCallback((i, b, stack, list) -> {
            DecimalFormat df = (DecimalFormat)Util.func_200696_a((Object)new DecimalFormat("##.##"), p_234699_0_ -> p_234699_0_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            if (i != 0) {
                list.add(new StringTextComponent("Chance: " + df.format(recipe.getChance(i - 1).floatValue() * 100.0f) + "%"));
            }
        });
    }
}

