/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.entities;

import com.cannolicatfish.rankine.init.RankineBlocks;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class BeaverEntity
extends AnimalEntity {
    private static final DataParameter<Optional<BlockState>> CARRIED_BLOCK = EntityDataManager.func_187226_a(BeaverEntity.class, (IDataSerializer)DataSerializers.field_187197_g);

    public BeaverEntity(EntityType<? extends AnimalEntity> p_i50250_1_, World p_i50250_2_) {
        super(p_i50250_1_, p_i50250_2_);
        this.func_70661_as().func_212239_d(true);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CARRIED_BLOCK, Optional.empty());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new StripLogGoal(1.2f, 32, 2));
        this.field_70714_bg.func_75776_a(3, (Goal)new PlaceSticksGoal(1.2f, 32, 2));
        this.field_70714_bg.func_75776_a(4, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new TemptGoal((CreatureEntity)this, 1.2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151055_y}), false));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    public void setHeldBlockState(@Nullable BlockState state) {
        this.field_70180_af.func_187227_b(CARRIED_BLOCK, Optional.ofNullable(state));
    }

    @Nullable
    public BlockState getHeldBlockState() {
        return ((Optional)this.field_70180_af.func_187225_a(CARRIED_BLOCK)).orElse(null);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187576_at;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187578_au;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187574_as;
    }

    class PlaceSticksGoal
    extends MoveToBlockGoal {
        private final BeaverEntity beaver;

        public PlaceSticksGoal(double p_i50737_2_, int p_i50737_4_, int p_i50737_5_) {
            super((CreatureEntity)BeaverEntity.this, p_i50737_2_, p_i50737_4_, p_i50737_5_);
            this.beaver = BeaverEntity.this;
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 100 == 0;
        }

        public double func_203110_f() {
            return 2.0;
        }

        public boolean func_75250_a() {
            if (this.field_179496_a > 0) {
                --this.field_179496_a;
                return false;
            }
            this.field_179496_a = this.func_203109_a(this.field_179495_c);
            return this.func_179489_g() && !BeaverEntity.this.func_70608_bn() && BeaverEntity.this.getHeldBlockState() == ((Block)RankineBlocks.STICK_BLOCK.get()).func_176223_P() && super.func_75250_a() && ForgeEventFactory.getMobGriefingEvent((World)this.beaver.field_70170_p, (Entity)this.beaver);
        }

        public void func_75246_d() {
            Random random = this.beaver.func_70681_au();
            World world = this.beaver.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.beaver.func_226277_ct_() - 1.0 + random.nextDouble() * 2.0));
            int j = MathHelper.func_76128_c((double)(this.beaver.func_226278_cu_() + random.nextDouble() * 2.0));
            int k = MathHelper.func_76128_c((double)(this.beaver.func_226281_cx_() - 1.0 + random.nextDouble() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = world.func_180495_p(blockpos);
            BlockPos blockpos1 = blockpos.func_177977_b();
            BlockState blockstate1 = world.func_180495_p(blockpos1);
            BlockState blockstate2 = this.beaver.getHeldBlockState();
            if (blockstate2 != null && this.func_220836_a((IWorldReader)world, blockpos, blockstate2 = Block.func_199770_b((BlockState)blockstate2, (IWorld)this.beaver.field_70170_p, (BlockPos)blockpos), blockstate, blockstate1, blockpos1) && !ForgeEventFactory.onBlockPlace((Entity)this.beaver, (BlockSnapshot)BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)blockpos1), (Direction)Direction.DOWN)) {
                world.func_180501_a(blockpos, blockstate2, 3);
                this.beaver.setHeldBlockState(null);
            }
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            FluidState fluid = worldIn.func_204610_c(pos);
            BlockState blockState = worldIn.func_180495_p(pos);
            boolean flag = BlockPos.func_239584_a_((BlockPos)pos, (int)1, (int)1, blockPos -> worldIn.func_180495_p(blockPos).func_200132_m()).isPresent();
            return flag && (fluid.func_206886_c() == Fluids.field_204546_a.func_210198_f() || fluid.func_206886_c() == Fluids.field_204546_a.func_210197_e() || fluid.func_206886_c() == Fluids.field_204546_a || blockState.func_177230_c() == Blocks.field_150355_j);
        }

        private boolean func_220836_a(IWorldReader p_220836_1_, BlockPos p_220836_2_, BlockState p_220836_3_, BlockState p_220836_4_, BlockState p_220836_5_, BlockPos p_220836_6_) {
            return p_220836_4_.isAir((IBlockReader)p_220836_1_, p_220836_2_) && !p_220836_5_.isAir((IBlockReader)p_220836_1_, p_220836_6_) && !p_220836_5_.func_215704_f() && p_220836_3_.func_196955_c(p_220836_1_, p_220836_2_);
        }
    }

    class StripLogGoal
    extends MoveToBlockGoal {
        private final BeaverEntity beaver;

        public StripLogGoal(double speedIn, int length, int p_i50737_5_) {
            super((CreatureEntity)BeaverEntity.this, speedIn, length, p_i50737_5_);
            this.beaver = BeaverEntity.this;
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 40 == 0;
        }

        public double func_203110_f() {
            return 2.0;
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            ResourceLocation rs = blockstate.func_177230_c().getRegistryName();
            return blockstate.func_177230_c().getTags().contains(new ResourceLocation("minecraft:logs")) && rs != null && !rs.func_110623_a().contains("stripped");
        }

        public void func_75246_d() {
            BlockPos blockpos = this.func_241846_j();
            if (!blockpos.func_218137_a((IPosition)this.field_179495_c.func_213303_ch(), this.func_203110_f())) {
                ++this.field_179493_e;
                if (this.func_203108_i()) {
                    this.field_179495_c.func_70661_as().func_75492_a((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5, this.field_179492_d);
                }
            } else {
                this.stripLog();
                --this.field_179493_e;
            }
        }

        protected void stripLog() {
            Block strippedLog;
            BlockState blockstate;
            ResourceLocation rs;
            if (ForgeEventFactory.getMobGriefingEvent((World)BeaverEntity.this.field_70170_p, (Entity)BeaverEntity.this) && (rs = (blockstate = BeaverEntity.this.field_70170_p.func_180495_p(this.field_179494_b)).func_177230_c().getRegistryName()) != null && (strippedLog = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(rs.func_110624_b(), "stripped_" + blockstate.func_177230_c().getRegistryName().func_110623_a()))) != null && strippedLog != Blocks.field_150350_a) {
                BeaverEntity.this.field_70170_p.func_180501_a(this.field_179494_b, strippedLog.func_176223_P(), 3);
                BeaverEntity.this.func_70691_i(1.0f);
                this.beaver.setHeldBlockState(((Block)RankineBlocks.STICK_BLOCK.get()).func_176223_P());
                BeaverEntity.this.func_184185_a(SoundEvents.field_219693_lB, 1.0f, 1.0f);
            }
        }

        public boolean func_75250_a() {
            return !BeaverEntity.this.func_70608_bn() && this.beaver.getHeldBlockState() == null && super.func_75250_a();
        }

        public void func_75249_e() {
            super.func_75249_e();
        }
    }
}

