/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.entities;

import com.cannolicatfish.rankine.init.RankineEntityTypes;
import com.cannolicatfish.rankine.init.RankineItems;
import java.util.List;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class MagnesiumArrowEntity
extends AbstractArrowEntity {
    private boolean spawnedDistraction;
    private LivingEntity distraction;

    protected MagnesiumArrowEntity(EntityType<? extends ArrowEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public MagnesiumArrowEntity(World worldIn, LivingEntity shooter) {
        super(RankineEntityTypes.MAGNESIUM_ARROW, shooter, worldIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public MagnesiumArrowEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world, EntityType<MagnesiumArrowEntity> e) {
        super(e, world);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)RankineItems.MAGNESIUM_ARROW.get());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70254_i) {
            if (this.field_184552_b % 100 == 0) {
                this.spawnParticles(1);
                List mobEntities = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(5.0, 5.0, 5.0));
                for (LivingEntity mob : mobEntities) {
                    mob.func_195064_c(new EffectInstance(Effects.field_76440_q, 120));
                }
            }
        } else if (this.field_70173_aa % 100 == 0) {
            this.spawnParticles(1);
        }
    }

    protected void func_184548_a(LivingEntity living) {
        super.func_184548_a(living);
        if (living instanceof CreeperEntity) {
            ((CreeperEntity)living).func_146079_cb();
        } else {
            List mobEntities = this.field_70170_p.func_217357_a(MobEntity.class, this.func_174813_aQ().func_72314_b(5.0, 5.0, 5.0));
            for (MobEntity mob : mobEntities) {
                if (living == mob || mob.func_70668_bt() != CreatureAttribute.field_223223_b_) continue;
                mob.func_70624_b(living);
            }
        }
    }

    private void spawnParticles(int particleCount) {
        int i = DyeColor.WHITE.getColorValue();
        if (i != -1 && particleCount > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < particleCount; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218419_B, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), d0, d1, d2);
            }
        }
    }
}

