/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.entities;

import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.init.RankineEntityTypes;
import com.cannolicatfish.rankine.init.RankineItems;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class RankineBoatEntity
extends BoatEntity {
    private static final DataParameter<Integer> BOAT_TYPE = EntityDataManager.func_187226_a(RankineBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public RankineBoatEntity(EntityType<? extends BoatEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    public RankineBoatEntity(World worldIn, double x, double y, double z) {
        this(RankineEntityTypes.RANKINE_BOAT, worldIn);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BOAT_TYPE, (Object)Type.OAK.ordinal());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("Type", this.getRankineBoatType().getName());
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("Type", 8)) {
            this.setRankineBoatType(Type.getTypeFromString(compound.func_74779_i("Type")));
        }
    }

    public Item func_184455_j() {
        switch (this.getRankineBoatType()) {
            default: {
                return Items.field_151124_az;
            }
            case SPRUCE: {
                return Items.field_185150_aH;
            }
            case BIRCH: {
                return Items.field_185151_aI;
            }
            case JUNGLE: {
                return Items.field_185152_aJ;
            }
            case ACACIA: {
                return Items.field_185153_aK;
            }
            case DARK_OAK: {
                return Items.field_185154_aL;
            }
            case CEDAR: {
                return (Item)RankineItems.CEDAR_BOAT.get();
            }
            case COCONUT_PALM: {
                return (Item)RankineItems.COCONUT_PALM_BOAT.get();
            }
            case PINYON_PINE: {
                return (Item)RankineItems.PINYON_PINE_BOAT.get();
            }
            case JUNIPER: {
                return (Item)RankineItems.JUNIPER_BOAT.get();
            }
            case BALSAM_FIR: {
                return (Item)RankineItems.BALSAM_FIR_BOAT.get();
            }
            case MAGNOLIA: {
                return (Item)RankineItems.MAGNOLIA_BOAT.get();
            }
            case HEMLOCK: {
                return (Item)RankineItems.HEMLOCK_BOAT.get();
            }
            case MAPLE: {
                return (Item)RankineItems.MAPLE_BOAT.get();
            }
            case BLACK_WALNUT: {
                return (Item)RankineItems.BLACK_WALNUT_BOAT.get();
            }
            case SHARINGA: {
                return (Item)RankineItems.SHARINGA_BOAT.get();
            }
            case CORK_OAK: {
                return (Item)RankineItems.CORK_OAK_BOAT.get();
            }
            case CINNAMON: {
                return (Item)RankineItems.CINNAMON_BOAT.get();
            }
            case BAMBOO: 
        }
        return (Item)RankineItems.BAMBOO_BOAT.get();
    }

    public Type getRankineBoatType() {
        return Type.byId((Integer)this.field_70180_af.func_187225_a(BOAT_TYPE));
    }

    public void setRankineBoatType(Type boatType) {
        this.field_70180_af.func_187227_b(BOAT_TYPE, (Object)boatType.ordinal());
    }

    public static enum Type {
        OAK(Blocks.field_196662_n, "oak"),
        SPRUCE(Blocks.field_196664_o, "spruce"),
        BIRCH(Blocks.field_196666_p, "birch"),
        JUNGLE(Blocks.field_196668_q, "jungle"),
        ACACIA(Blocks.field_196670_r, "acacia"),
        DARK_OAK(Blocks.field_196672_s, "dark_oak"),
        CEDAR((Block)RankineBlocks.CEDAR_PLANKS.get(), "cedar"),
        COCONUT_PALM((Block)RankineBlocks.COCONUT_PALM_PLANKS.get(), "coconut_palm"),
        PINYON_PINE((Block)RankineBlocks.PINYON_PINE_PLANKS.get(), "pinyon_pine"),
        JUNIPER((Block)RankineBlocks.JUNIPER_PLANKS.get(), "juniper"),
        BALSAM_FIR((Block)RankineBlocks.BALSAM_FIR_PLANKS.get(), "balsam_fir"),
        MAGNOLIA((Block)RankineBlocks.MAGNOLIA_PLANKS.get(), "magnolia"),
        HEMLOCK((Block)RankineBlocks.EASTERN_HEMLOCK_PLANKS.get(), "hemlock"),
        MAPLE((Block)RankineBlocks.MAPLE_PLANKS.get(), "maple"),
        BLACK_BIRCH((Block)RankineBlocks.BLACK_BIRCH_PLANKS.get(), "black_birch"),
        YELLOW_BIRCH((Block)RankineBlocks.YELLOW_BIRCH_PLANKS.get(), "yellow_birch"),
        BLACK_WALNUT((Block)RankineBlocks.BLACK_WALNUT_PLANKS.get(), "black_walnut"),
        SHARINGA((Block)RankineBlocks.SHARINGA_PLANKS.get(), "sharinga"),
        CORK_OAK((Block)RankineBlocks.CORK_OAK_PLANKS.get(), "cork_oak"),
        CINNAMON((Block)RankineBlocks.CINNAMON_PLANKS.get(), "cinnamon"),
        BAMBOO((Block)RankineBlocks.BAMBOO_PLANKS.get(), "bamboo"),
        BAMBOO_CULMS((Block)RankineBlocks.BAMBOO_CULMS.get(), "bamboo_culms");

        private final String name;
        private final Block block;

        private Type(Block p_i48146_3_, String p_i48146_4_) {
            this.name = p_i48146_4_;
            this.block = p_i48146_3_;
        }

        public String getName() {
            return this.name;
        }

        public Block asPlank() {
            return this.block;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] aboatentity$type = Type.values();
            if (id < 0 || id >= aboatentity$type.length) {
                id = 0;
            }
            return aboatentity$type[id];
        }

        public static Type getTypeFromString(String nameIn) {
            Type[] aboatentity$type = Type.values();
            for (int i = 0; i < aboatentity$type.length; ++i) {
                if (!aboatentity$type[i].getName().equals(nameIn)) continue;
                return aboatentity$type[i];
            }
            return aboatentity$type[0];
        }
    }
}

