/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.entities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class ReactiveItemEntity
extends ItemEntity {
    private float radius;
    private boolean canBreakBlocks;

    public ReactiveItemEntity(EntityType<? extends ItemEntity> p_i50217_1_, World p_i50217_2_) {
        super(p_i50217_1_, p_i50217_2_);
        this.radius = 1.0f;
        this.canBreakBlocks = false;
    }

    public ReactiveItemEntity(World worldIn, double x, double y, double z) {
        this((EntityType<? extends ItemEntity>)EntityType.field_200765_E, worldIn);
        this.func_70107_b(x, y, z);
        this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
        this.radius = 1.0f;
        this.canBreakBlocks = false;
        this.func_213293_j(this.field_70146_Z.nextDouble() * 0.2 - 0.1, 0.2, this.field_70146_Z.nextDouble() * 0.2 - 0.1);
    }

    public ReactiveItemEntity(World worldIn, double x, double y, double z, ItemStack stack) {
        super(EntityType.field_200765_E, worldIn);
        this.func_70107_b(x, y, z);
        this.func_92058_a(stack);
        this.radius = 1.0f;
        this.canBreakBlocks = false;
        this.lifespan = stack.func_77973_b() == null ? 6000 : stack.getEntityLifespan(worldIn);
    }

    public ReactiveItemEntity(World worldIn, double x, double y, double z, float radius, boolean canBreakBlocks, ItemStack stack) {
        super(EntityType.field_200765_E, worldIn);
        this.func_70107_b(x, y, z);
        this.func_92058_a(stack);
        this.radius = radius;
        this.canBreakBlocks = canBreakBlocks;
        this.lifespan = stack.func_77973_b() == null ? 6000 : stack.getEntityLifespan(worldIn);
    }

    public void func_70071_h_() {
        if (this.field_70171_ac) {
            BlockPos pos = this.func_233580_cy_();
            if (this.canBreakBlocks) {
                this.func_130014_f_().func_217385_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p(), this.radius, Explosion.Mode.BREAK);
            } else {
                this.func_130014_f_().func_217385_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p(), this.radius, Explosion.Mode.NONE);
            }
            this.func_70106_y();
        }
        super.func_70071_h_();
    }

    @NotNull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

