/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.entities;

import com.cannolicatfish.rankine.init.RankineEnchantments;
import com.cannolicatfish.rankine.init.RankineItems;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class SpearEntity
extends AbstractArrowEntity {
    private static final DataParameter<Byte> LOYALTY_LEVEL = EntityDataManager.func_187226_a(SpearEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> TELEPORT_LEVEL = EntityDataManager.func_187226_a(SpearEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private ItemStack thrownStack = new ItemStack((IItemProvider)RankineItems.BRONZE_SPEAR.get());
    public ResourceLocation field_200606_g;
    private boolean dealtDamage;
    private float attackDamage;
    public int returningTicks;
    private int knockbackStrength;

    public SpearEntity(EntityType<? extends SpearEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public SpearEntity(World worldIn, LivingEntity thrower, ItemStack thrownStackIn, EntityType<SpearEntity> e, ResourceLocation type, float damage) {
        super(e, thrower, worldIn);
        this.thrownStack = thrownStackIn.func_77946_l();
        this.field_70180_af.func_187227_b(TELEPORT_LEVEL, (Object)((byte)EnchantmentHelper.func_77506_a((Enchantment)RankineEnchantments.ENDPOINT, (ItemStack)thrownStackIn)));
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)thrownStackIn)));
        this.field_200606_g = type;
        this.attackDamage = damage;
    }

    @OnlyIn(value=Dist.CLIENT)
    public SpearEntity(World worldIn, double x, double y, double z, EntityType<SpearEntity> e) {
        super(e, x, y, z, worldIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public SpearEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world, EntityType<SpearEntity> e, ResourceLocation type) {
        super(e, world);
        this.field_200606_g = type;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TELEPORT_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(LOYALTY_LEVEL, (Object)0);
    }

    public void func_70071_h_() {
        int r;
        if (this.field_184552_b > 4) {
            this.dealtDamage = true;
        }
        if ((r = EnchantmentHelper.func_77506_a((Enchantment)RankineEnchantments.IMPACT, (ItemStack)this.thrownStack)) > 0) {
            this.func_70240_a(r * 2);
        }
        Entity entity = this.func_234616_v_();
        if (this.field_184552_b == 4 && entity instanceof PlayerEntity && (Byte)this.field_70180_af.func_187225_a(TELEPORT_LEVEL) > 0) {
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, entity.func_226277_ct_(), entity.func_226278_cu_() + 0.5, entity.func_226281_cx_(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, x, y + 0.5, z, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
            this.field_70170_p.func_184134_a(x, y, z, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
            entity.func_70634_a(x, y, z);
            if (!((PlayerEntity)entity).func_184812_l_()) {
                entity.func_70097_a(DamageSource.field_76379_h, Math.max(5.0f - 2.5f * (float)((Byte)this.field_70180_af.func_187225_a(TELEPORT_LEVEL) - 1), 0.0f));
            }
        }
        if ((this.dealtDamage || this.func_203047_q()) && entity != null) {
            byte i = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
            if (i > 0 && !this.shouldReturnToThrower()) {
                if (!this.field_70170_p.field_72995_K && this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            } else if (i > 0) {
                this.func_203045_n(true);
                Vector3d vec3d = new Vector3d(entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e() - this.func_226278_cu_(), entity.func_226281_cx_() - this.func_226281_cx_());
                this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + vec3d.field_72448_b * 0.015 * (double)i, this.func_226281_cx_());
                if (this.field_70170_p.field_72995_K) {
                    this.field_70137_T = this.func_226278_cu_();
                }
                double d0 = 0.05 * (double)i;
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(vec3d.func_72432_b().func_186678_a(d0)));
                if (this.returningTicks == 0) {
                    this.func_184185_a(SoundEvents.field_203270_il, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.func_70071_h_();
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.func_234616_v_();
        if (entity != null && entity.func_70089_S()) {
            return !(entity instanceof ServerPlayerEntity) || !entity.func_175149_v();
        }
        return false;
    }

    public void func_70240_a(int knockbackStrengthIn) {
        this.knockbackStrength = knockbackStrengthIn;
    }

    protected ItemStack func_184550_j() {
        return this.thrownStack.func_77946_l();
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vector3d startVec, Vector3d endVec) {
        return this.dealtDamage ? null : super.func_213866_a(startVec, endVec);
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        Entity entity1;
        Entity entity = p_213868_1_.func_216348_a();
        float f = this.attackDamage;
        if (f == 0.0f) {
            f = 4.0f;
        }
        if (entity instanceof LivingEntity) {
            Vector3d vector3d;
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.func_152377_a((ItemStack)this.thrownStack, (CreatureAttribute)livingentity.func_70668_bt());
            if (this.knockbackStrength > 0 && (vector3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.knockbackStrength * 0.6)).func_189985_c() > 0.0) {
                livingentity.func_70024_g(vector3d.field_72450_a, 0.1, vector3d.field_72449_c);
            }
        }
        DamageSource damagesource = DamageSource.func_203096_a((Entity)this, (Entity)((entity1 = this.func_234616_v_()) == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.field_203268_ij;
        if (entity.func_70097_a(damagesource, f) && entity instanceof LivingEntity) {
            LivingEntity livingentity1 = (LivingEntity)entity;
            if (entity1 instanceof LivingEntity) {
                EnchantmentHelper.func_151384_a((LivingEntity)livingentity1, (Entity)entity1);
                EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
            }
            this.func_184548_a(livingentity1);
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        this.func_184185_a(soundevent, f1, 1.0f);
    }

    protected SoundEvent func_213867_k() {
        return SoundEvents.field_203269_ik;
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        Entity entity = this.func_234616_v_();
        if (entity == null || entity.func_110124_au() == entityIn.func_110124_au()) {
            super.func_70100_b_(entityIn);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Spear", 10)) {
            this.thrownStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Spear"));
        }
        this.dealtDamage = compound.func_74767_n("DealtDamage");
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)this.thrownStack)));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("Spear", (INBT)this.thrownStack.func_77955_b(new CompoundNBT()));
        compound.func_74757_a("DealtDamage", this.dealtDamage);
    }

    protected void func_225516_i_() {
        byte i = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
        if (this.field_70251_a != AbstractArrowEntity.PickupStatus.ALLOWED || i <= 0) {
            super.func_225516_i_();
        }
    }

    protected float func_203044_p() {
        return 0.8f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }
}

