/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.init;

import com.cannolicatfish.rankine.advancements.ExactCompositionPredicate;
import com.cannolicatfish.rankine.advancements.HarvestLevelPredicate;
import com.cannolicatfish.rankine.advancements.IncludesCompositionPredicate;
import com.cannolicatfish.rankine.advancements.PewterEnchantabilityPredicate;
import com.cannolicatfish.rankine.init.RankineItems;
import com.cannolicatfish.rankine.potion.RankinePotions;
import com.cannolicatfish.rankine.recipe.helper.AlloyRecipeHelper;
import com.cannolicatfish.rankine.util.PeriodicTableUtils;
import com.cannolicatfish.rankine.util.alloys.AlloyUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;

public class RankineRecipes {
    public static void registerPotionRecipes() {
        IItemProvider[] iItemProviderArray = new IItemProvider[1];
        iItemProviderArray[0] = () -> RankineItems.MERCURY_INGOT.get();
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185233_e)}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])iItemProviderArray), (ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)RankinePotions.MERCURY_POISON));
        IItemProvider[] iItemProviderArray2 = new IItemProvider[2];
        iItemProviderArray2[0] = () -> RankineItems.SALT.get();
        iItemProviderArray2[1] = () -> RankineItems.PINK_SALT.get();
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185233_e)}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])iItemProviderArray2), (ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)RankinePotions.CONDUCTIVE_POTION));
    }

    public static void registerPredicates() {
        ItemPredicate.register((ResourceLocation)new ResourceLocation("rankine", "harvest_level_check"), HarvestLevelPredicate::new);
        ItemPredicate.register((ResourceLocation)new ResourceLocation("rankine", "enchant_check"), PewterEnchantabilityPredicate::new);
        ItemPredicate.register((ResourceLocation)new ResourceLocation("rankine", "exact_composition"), ExactCompositionPredicate::new);
        ItemPredicate.register((ResourceLocation)new ResourceLocation("rankine", "includes_composition"), IncludesCompositionPredicate::new);
    }

    public static String generateAlloyString(IInventory inv) {
        ArrayList<PeriodicTableUtils.Element> currentElements = new ArrayList<PeriodicTableUtils.Element>();
        ArrayList<Integer> currentMaterial = new ArrayList<Integer>();
        PeriodicTableUtils utils = new PeriodicTableUtils();
        for (int i = 0; i < 6; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            PeriodicTableUtils.Element element = utils.getElementFromItem(stack.func_77973_b());
            if (!currentElements.contains((Object)element)) {
                currentElements.add(element);
                currentMaterial.add(0);
            }
            int workingIndex = currentElements.indexOf((Object)element);
            Item item = stack.func_77973_b();
            ResourceLocation reg = item.getRegistryName();
            String registry = "";
            if (reg != null) {
                registry = reg.func_110623_a();
            }
            if (stack.func_77973_b().getTags().contains(new ResourceLocation("forge:storage_blocks")) || stack.func_77973_b() instanceof BlockItem || registry.contains("block")) {
                currentMaterial.set(workingIndex, (Integer)currentMaterial.get(workingIndex) + 81 * stack.func_190916_E());
                continue;
            }
            if (stack.func_77973_b().getTags().contains(new ResourceLocation("forge:ingots")) || registry.contains("ingot")) {
                currentMaterial.set(workingIndex, (Integer)currentMaterial.get(workingIndex) + 9 * stack.func_190916_E());
                continue;
            }
            if (stack.func_77973_b().getTags().contains(new ResourceLocation("forge:nuggets")) || registry.contains("nugget")) {
                currentMaterial.set(workingIndex, (Integer)currentMaterial.get(workingIndex) + stack.func_190916_E());
                continue;
            }
            if (stack.func_77973_b() == Items.field_234760_kn_ || registry.contains("scrap")) {
                currentMaterial.set(workingIndex, (Integer)currentMaterial.get(workingIndex) + 2 * stack.func_190916_E());
                continue;
            }
            currentMaterial.set(workingIndex, (Integer)currentMaterial.get(workingIndex) + 9 * stack.func_190916_E());
        }
        int sum = currentMaterial.stream().mapToInt(Integer::intValue).sum();
        ArrayList<Integer> percents = new ArrayList<Integer>();
        ArrayList<String> symbols = new ArrayList<String>();
        for (int j = 0; j < currentElements.size(); ++j) {
            PeriodicTableUtils.Element curEl = (PeriodicTableUtils.Element)((Object)currentElements.get(j));
            int curPer = Math.round((float)((Integer)currentMaterial.get(j)).intValue() * 100.0f / (float)sum);
            symbols.add(curEl.getSymbol());
            percents.add(curPer);
        }
        return AlloyRecipeHelper.getDirectComposition(percents, symbols);
    }

    public static List<PeriodicTableUtils.Element> getElements(String c) {
        PeriodicTableUtils utils = new PeriodicTableUtils();
        String[] comp = c.split("-");
        ArrayList<PeriodicTableUtils.Element> list = new ArrayList<PeriodicTableUtils.Element>();
        for (String e : comp) {
            String str = e.replaceAll("[^A-Za-z]+", "");
            list.add(utils.getElementBySymbol(str));
        }
        return list;
    }

    public static List<Integer> getPercents(String c) {
        String[] comp = c.split("-");
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String e : comp) {
            String str = e.replaceAll("\\D+", "");
            list.add(Integer.parseInt(str));
        }
        return list;
    }

    public static List<Enchantment> getEnchantments(String c, AlloyUtils alloy, Item item) {
        PeriodicTableUtils utils = new PeriodicTableUtils();
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        List<Enchantment> elementEn = utils.getEnchantments(RankineRecipes.getElements(c), RankineRecipes.getPercents(c));
        for (Enchantment e : elementEn) {
            if (e == null || enchantments.contains(e)) continue;
            enchantments.add(e);
        }
        List<Enchantment> en = alloy.getEnchantmentBonus(item);
        for (Enchantment e : en) {
            if (e == null || enchantments.contains(e)) continue;
            enchantments.add(e);
        }
        return enchantments;
    }
}

