/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.items;

import com.cannolicatfish.rankine.init.RankineItems;
import com.cannolicatfish.rankine.init.RankineRecipeTypes;
import com.cannolicatfish.rankine.init.RankineRecipes;
import com.cannolicatfish.rankine.items.alloys.AlloyData;
import com.cannolicatfish.rankine.items.alloys.AlloyItem;
import com.cannolicatfish.rankine.recipe.AlloyingRecipe;
import com.cannolicatfish.rankine.recipe.helper.AlloyRecipeHelper;
import com.cannolicatfish.rankine.util.PeriodicTableUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class AlloyTemplateItem
extends Item {
    public AlloyTemplateItem(Item.Properties properties) {
        super(properties);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (AlloyTemplateItem.getTemplate(stack).func_186856_d() != 0) {
            String p2;
            String p1;
            String comp = AlloyTemplateItem.getTemplate(stack).func_74781_a("NameAdd").func_150285_a_();
            if (comp.contains("#")) {
                p1 = comp.split("#")[0];
                p2 = new TranslationTextComponent(comp.split("#")[1]).getString();
            } else {
                p1 = "";
                p2 = new TranslationTextComponent(comp).getString();
            }
            String p3 = new TranslationTextComponent(this.func_77667_c(stack)).getString().split(" ")[1];
            return new StringTextComponent(p1 + " " + p2 + " " + p3);
        }
        return new TranslationTextComponent(this.func_77667_c(stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (AlloyTemplateItem.getTemplate(stack).func_186856_d() != 0) {
            tooltip.add((ITextComponent)new StringTextComponent("Composition: " + AlloyTemplateItem.getOutputAlloyData(stack)).func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new StringTextComponent("Requires:").func_240699_a_(TextFormatting.DARK_GREEN));
            String comp = AlloyTemplateItem.getTemplate(stack).func_74781_a("StoredTemplate").func_150285_a_();
            int count = 0;
            for (String s : comp.split("-")) {
                String path;
                String str = s.replaceAll("[^A-Za-z]+", "");
                String end = "";
                int num = Integer.parseInt(s.replaceAll("[A-Za-z]+", ""));
                ListNBT nbt = AlloyTemplateItem.getTemplate(stack).func_150295_c("Inputs", 10);
                String t = nbt.func_150307_f(count).split("\"")[1];
                String namespace = t.split(":")[0];
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(namespace, path = t.split(":")[1]));
                if (item == null) continue;
                int reduce = AlloyRecipeHelper.returnMaterialCountFromStack(new ItemStack((IItemProvider)item, 1));
                ++count;
                String display = new TranslationTextComponent(item.func_77658_a()).getString();
                tooltip.add((ITextComponent)new StringTextComponent((num /= reduce) + "x " + display).func_240699_a_(TextFormatting.GRAY));
            }
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add((ITextComponent)new StringTextComponent("Made in:").func_240699_a_(TextFormatting.DARK_GREEN));
            int tier = AlloyTemplateItem.getTier(stack);
            if ((tier & 1) != 0) {
                tooltip.add((ITextComponent)new StringTextComponent("Alloy Furnace").func_240699_a_(TextFormatting.GRAY));
            }
            if ((tier & 2) != 0) {
                tooltip.add((ITextComponent)new StringTextComponent("Induction Furnace").func_240699_a_(TextFormatting.GRAY));
            }
        }
    }

    public static void addTemplate(ItemStack stack, AlloyingRecipe recipe, IInventory inv, DyeItem dye) {
        ListNBT listnbt = new ListNBT();
        ItemStack output = recipe.generateResult(inv, 3);
        stack.func_196082_o().func_74778_a("StoredTemplate", AlloyTemplateItem.assembleTemplateData(inv, 0, 6));
        stack.func_196082_o().func_74778_a("NameAdd", output.func_190916_E() + "x#" + output.func_77977_a());
        for (int i = 0; i < 6; ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            CompoundNBT cnbt = new CompoundNBT();
            cnbt.func_74778_a(inv.func_70301_a(i).func_200301_q().getString().split(" ")[0], inv.func_70301_a(i).func_77973_b().getRegistryName().toString());
            listnbt.add((Object)cnbt);
        }
        stack.func_196082_o().func_218657_a("Inputs", (INBT)listnbt);
        stack.func_196082_o().func_74778_a("Output", output.func_77973_b().getRegistryName().toString());
        INBT nbt = AlloyItem.getComposition(output).func_150305_b(0).func_74781_a("comp");
        stack.func_196082_o().func_74778_a("AlloyData", nbt != null ? nbt.func_150285_a_() : RankineRecipes.generateAlloyString(inv));
        stack.func_196082_o().func_74768_a("Tier", recipe.getTier());
        stack.func_196082_o().func_74768_a("Color", dye.func_195962_g().getColorValue());
    }

    public static String getOutputAlloyData(ItemStack stack) {
        return AlloyTemplateItem.getTemplate(stack).func_74779_i("AlloyData");
    }

    public static int getTier(ItemStack stack) {
        return AlloyTemplateItem.getTemplate(stack).func_74762_e("Tier");
    }

    public static String assembleTemplateData(IInventory inv, int startIndex, int endIndex) {
        PeriodicTableUtils utils = PeriodicTableUtils.getInstance();
        StringBuilder ret = new StringBuilder();
        ArrayList<Integer> x = new ArrayList<Integer>();
        ArrayList<String> s = new ArrayList<String>();
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            String el = utils.getElementFromItem(stack.func_77973_b()).getSymbol();
            int mat = AlloyRecipeHelper.returnMaterialCountFromStack(stack);
            if (!s.contains(el)) {
                s.add(el);
                x.add(mat);
                continue;
            }
            x.set(s.indexOf(el), (Integer)x.get(s.indexOf(el)) + mat);
        }
        for (int j = 0; j < s.size(); ++j) {
            if (!ret.toString().isEmpty()) {
                ret.append("-");
            }
            ret.append((String)s.get(j)).append(x.get(j));
        }
        return ret.toString();
    }

    public static CompoundNBT getTemplate(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt != null ? compoundnbt : new CompoundNBT();
    }

    public static int getColor(ItemStack stack) {
        return AlloyTemplateItem.getTemplate(stack).func_74762_e("Color") == 0 ? 0xFFFFFF : AlloyTemplateItem.getTemplate(stack).func_74762_e("Color");
    }

    public static ItemStack getResult(ItemStack stack) {
        if (AlloyTemplateItem.getTemplate(stack).func_186856_d() != 0) {
            int num;
            CompoundNBT compoundNBT = AlloyTemplateItem.getTemplate(stack);
            String name = compoundNBT.func_74781_a("NameAdd").func_150285_a_();
            try {
                num = Integer.parseInt(name.replaceAll("[^0-9]+", ""));
            }
            catch (NumberFormatException e) {
                return ItemStack.field_190927_a;
            }
            String namespace = compoundNBT.func_74781_a("Output").func_150285_a_().split(":")[0];
            String path = compoundNBT.func_74781_a("Output").func_150285_a_().split(":")[1];
            ItemStack item = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(namespace, path)), num);
            if (item.func_77973_b() instanceof AlloyItem) {
                AlloyItem.addAlloy(item, new AlloyData(compoundNBT.func_74781_a("AlloyData").func_150285_a_()));
                return item;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack[] getInputStacks(ItemStack stack) {
        if (AlloyTemplateItem.getTemplate(stack).func_186856_d() != 0) {
            INBT temp = AlloyTemplateItem.getTemplate(stack).func_74781_a("StoredTemplate");
            boolean flag = temp != null;
            ListNBT nbt = AlloyTemplateItem.getTemplate(stack).func_150295_c("Inputs", 10);
            ItemStack[] x = new ItemStack[nbt.size()];
            for (int i = 0; i < nbt.size(); ++i) {
                String s = nbt.func_150307_f(i).split("\"")[1];
                if (s.equals("minecraft:air")) continue;
                String namespace = s.split(":")[0];
                String path = s.split(":")[1];
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(namespace, path));
                int amount = 1;
                if (flag && temp.func_150285_a_().split("-").length > i) {
                    String t = temp.func_150285_a_().split("-")[i];
                    amount = Integer.parseInt(t.replaceAll("[A-Za-z]+", "")) / AlloyRecipeHelper.returnMaterialCountFromStack(new ItemStack((IItemProvider)item));
                }
                x[i] = new ItemStack((IItemProvider)item, amount);
            }
            return x;
        }
        return null;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (AlloyTemplateItem.getTemplate(stack).func_186856_d() == 0 && !worldIn.field_72995_K) {
            ItemStack[] inputs;
            int random = worldIn.func_201674_k().nextInt(16);
            switch (random) {
                default: {
                    inputs = new ItemStack[]{new ItemStack((IItemProvider)RankineItems.COPPER_INGOT.get(), 8), new ItemStack((IItemProvider)RankineItems.TIN_INGOT.get(), 2), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                    break;
                }
                case 1: {
                    inputs = new ItemStack[]{new ItemStack((IItemProvider)RankineItems.TIN_INGOT.get(), 9), new ItemStack((IItemProvider)RankineItems.ANTIMONY_INGOT.get(), 1), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                    break;
                }
                case 2: {
                    inputs = new ItemStack[]{new ItemStack((IItemProvider)RankineItems.COPPER_INGOT.get(), 6), new ItemStack((IItemProvider)RankineItems.ZINC_INGOT.get(), 4), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                    break;
                }
                case 3: {
                    inputs = new ItemStack[]{new ItemStack((IItemProvider)Items.field_151043_k, 5), new ItemStack((IItemProvider)RankineItems.COPPER_NUGGET.get(), 13), new ItemStack((IItemProvider)RankineItems.SILVER_NUGGET.get(), 2), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                    break;
                }
                case 4: {
                    inputs = new ItemStack[]{new ItemStack((IItemProvider)RankineItems.COPPER_INGOT.get(), 9), new ItemStack((IItemProvider)RankineItems.ALUMINUM_INGOT.get(), 1), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                    break;
                }
                case 5: {
                    inputs = new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 6), new ItemStack((IItemProvider)RankineItems.NICKEL_INGOT.get(), 4), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                    break;
                }
                case 6: {
                    inputs = new ItemStack[]{new ItemStack((IItemProvider)Items.field_151043_k, 9), new ItemStack((IItemProvider)RankineItems.ZINC_INGOT.get(), 1), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                    break;
                }
                case 7: {
                    inputs = new ItemStack[]{new ItemStack((IItemProvider)Items.field_151043_k, 5), new ItemStack((IItemProvider)RankineItems.SILVER_INGOT.get(), 5), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                    break;
                }
                case 8: {
                    inputs = new ItemStack[]{new ItemStack((IItemProvider)Items.field_151043_k, 8), new ItemStack((IItemProvider)RankineItems.ALUMINUM_INGOT.get(), 2), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                    break;
                }
                case 9: {
                    inputs = new ItemStack[]{new ItemStack((IItemProvider)RankineItems.TUNGSTEN_INGOT.get(), 9), new ItemStack((IItemProvider)RankineItems.NICKEL_NUGGET.get(), 6), new ItemStack((IItemProvider)Items.field_191525_da, 3), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                }
                case 10: {
                    inputs = new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j, 5), new ItemStack((IItemProvider)RankineItems.CHROMIUM_NUGGET.get(), 8), new ItemStack((IItemProvider)RankineItems.CARBON_NUGGET.get(), 1), new ItemStack((IItemProvider)RankineItems.NICKEL_NUGGET.get(), 6), ItemStack.field_190927_a, ItemStack.field_190927_a};
                }
                case 11: {
                    inputs = new ItemStack[]{new ItemStack((IItemProvider)RankineItems.BISMUTH_INGOT.get(), 5), new ItemStack((IItemProvider)RankineItems.LEAD_INGOT.get(), 3), new ItemStack((IItemProvider)RankineItems.TIN_INGOT.get(), 2), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                }
                case 12: {
                    inputs = new ItemStack[]{new ItemStack((IItemProvider)RankineItems.CERIUM_INGOT.get(), 5), new ItemStack((IItemProvider)RankineItems.LANTHANUM_NUGGET.get(), 22), new ItemStack((IItemProvider)RankineItems.NEODYMIUM_NUGGET.get(), 18), new ItemStack((IItemProvider)Items.field_191525_da, 5), ItemStack.field_190927_a, ItemStack.field_190927_a};
                }
                case 13: {
                    inputs = new ItemStack[]{new ItemStack((IItemProvider)RankineItems.NICKEL_INGOT.get(), 8), new ItemStack((IItemProvider)RankineItems.TITANIUM_INGOT.get(), 1), new ItemStack((IItemProvider)RankineItems.ALUMINUM_INGOT.get(), 1), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                }
                case 14: {
                    inputs = new ItemStack[]{new ItemStack((IItemProvider)RankineItems.NICKEL_INGOT.get(), 7), new ItemStack((IItemProvider)RankineItems.CHROMIUM_INGOT.get(), 2), new ItemStack((IItemProvider)RankineItems.COBALT_INGOT.get(), 1), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                }
                case 15: {
                    inputs = new ItemStack[]{new ItemStack((IItemProvider)RankineItems.COBALT_INGOT.get(), 7), new ItemStack((IItemProvider)RankineItems.CHROMIUM_INGOT.get(), 2), new ItemStack((IItemProvider)RankineItems.NICKEL_INGOT.get(), 1), new ItemStack((IItemProvider)RankineItems.TANTALUM_INGOT.get(), 1), ItemStack.field_190927_a, ItemStack.field_190927_a};
                }
            }
            Inventory sim = new Inventory(inputs);
            AlloyingRecipe recipeIn = worldIn.func_199532_z().func_215371_a(RankineRecipeTypes.ALLOYING, (IInventory)sim, worldIn).orElse(null);
            if (recipeIn != null) {
                AlloyTemplateItem.addTemplate(stack, recipeIn, (IInventory)new Inventory(inputs), (DyeItem)Items.field_222069_lA);
            }
        }
    }
}

