/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.items;

import com.cannolicatfish.rankine.entities.ReactiveItemEntity;
import com.cannolicatfish.rankine.init.Config;
import com.cannolicatfish.rankine.potion.RankineEffects;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ElementItem
extends Item {
    float waterReactive;
    boolean canBreakBlocks;
    int radioactive;

    public ElementItem(float waterReactive, boolean canBreakBlocks, int radioactive, Item.Properties properties) {
        super(properties);
        this.waterReactive = waterReactive;
        this.canBreakBlocks = canBreakBlocks;
        this.radioactive = radioactive;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (((Boolean)Config.HARD_MODE.WATER_REACTIVE.get()).booleanValue() && this.waterReactive > 0.0f) {
            if (this.waterReactive < 2.0f) {
                tooltip.add((ITextComponent)new StringTextComponent("Warning! Reactive with water!").func_240699_a_(TextFormatting.GRAY));
            } else if (this.waterReactive >= 2.0f) {
                tooltip.add((ITextComponent)new StringTextComponent("Warning! Highly reactive with water!").func_240699_a_(TextFormatting.GRAY));
            }
        }
        if (((Boolean)Config.HARD_MODE.RADIOACTIVE.get()).booleanValue() && this.radioactive > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("Warning: Radioactive! Prolonged exposure is harmful.").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        PlayerEntity player;
        if (((Boolean)Config.HARD_MODE.WATER_REACTIVE.get()).booleanValue() && this.waterReactive > 0.0f && entityIn.func_70090_H() && isSelected && entityIn instanceof PlayerEntity) {
            player = (PlayerEntity)entityIn;
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
                BlockPos pos = entityIn.func_233580_cy_();
                if (this.canBreakBlocks) {
                    entityIn.func_130014_f_().func_217385_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p(), this.waterReactive, Explosion.Mode.BREAK);
                } else {
                    entityIn.func_130014_f_().func_217385_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p(), this.waterReactive, Explosion.Mode.NONE);
                }
            }
        }
        if (((Boolean)Config.HARD_MODE.RADIOACTIVE.get()).booleanValue() && entityIn instanceof PlayerEntity && !(player = (PlayerEntity)entityIn).func_184812_l_()) {
            int dur;
            EffectInstance rad = player.func_70660_b(RankineEffects.RADIATION_POISONING);
            int n = dur = rad == null ? Math.max(0, this.radioactive * stack.func_190916_E()) : Math.max(0, rad.func_76459_b() + this.radioactive * stack.func_190916_E());
            if (dur > 0) {
                player.func_195064_c(new EffectInstance(RankineEffects.RADIATION_POISONING, dur, 0, false, false, false));
            }
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return (Boolean)Config.HARD_MODE.WATER_REACTIVE.get();
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        if (((Boolean)Config.HARD_MODE.WATER_REACTIVE.get()).booleanValue()) {
            ReactiveItemEntity result = new ReactiveItemEntity(location.field_70170_p, location.func_226277_ct_(), location.func_226278_cu_(), location.func_226281_cx_(), this.waterReactive, this.canBreakBlocks, itemstack);
            result.func_174867_a(40);
            result.func_213317_d(location.func_213322_ci());
            return result;
        }
        return null;
    }
}

