/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.items.alloys;

import com.cannolicatfish.rankine.ProjectRankine;
import com.cannolicatfish.rankine.init.Config;
import com.cannolicatfish.rankine.items.alloys.AlloyData;
import com.cannolicatfish.rankine.items.alloys.IAlloyArmor;
import com.cannolicatfish.rankine.recipe.helper.AlloyColorHelper;
import com.cannolicatfish.rankine.recipe.helper.AlloyRecipeHelper;
import com.cannolicatfish.rankine.util.alloys.AlloyUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlloyArmorItem
extends DyeableArmorItem
implements IAlloyArmor,
IDyeableArmorItem {
    private final AlloyUtils alloy;

    public AlloyArmorItem(IArmorMaterial materialIn, EquipmentSlotType slot, AlloyUtils alloy, Item.Properties builderIn) {
        super(materialIn, slot, builderIn);
        this.alloy = alloy;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        if (this.getComposition(repair).size() != 0 && this.getComposition(toRepair).size() != 0 && (repair.func_77973_b().getTags().contains(new ResourceLocation("forge:ingots")) || repair.func_77973_b() == this)) {
            INBT s = this.getComposition(repair).func_150305_b(0).func_74781_a("comp");
            INBT r = this.getComposition(toRepair).func_150305_b(0).func_74781_a("comp");
            return s != null && s.equals(r);
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (float)this.getDamage(stack) * 1.0f / (float)this.getAlloyArmorDurability(this.returnCompositionString(stack, this.alloy), this.alloy, this.field_77881_a);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getAlloyArmorDurability(this.returnCompositionString(stack, this.alloy), this.alloy, this.field_77881_a);
    }

    @Override
    public AlloyUtils returnAlloyUtils() {
        return this.alloy;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        DecimalFormat df = (DecimalFormat)Util.func_200696_a((Object)new DecimalFormat("##.#"), p_234699_0_ -> p_234699_0_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
        if (this.returnCompositionString(stack, this.alloy) != null) {
            if (!Screen.func_231173_s_()) {
                tooltip.add((ITextComponent)new StringTextComponent("Hold shift for details...").func_240699_a_(TextFormatting.GRAY));
            }
            if (Screen.func_231173_s_()) {
                tooltip.add((ITextComponent)new StringTextComponent("Composition: " + this.returnCompositionString(stack, this.alloy)).func_240699_a_(this.alloy.getAlloyGroupColor()));
                tooltip.add((ITextComponent)new StringTextComponent("Durability: " + (this.getAlloyArmorDurability(this.returnCompositionString(stack, this.alloy), this.alloy, this.field_77881_a) - this.getDamage(stack)) + "/" + this.getAlloyArmorDurability(this.returnCompositionString(stack, this.alloy), this.alloy, this.field_77881_a)).func_240699_a_(TextFormatting.DARK_GREEN));
                tooltip.add((ITextComponent)new StringTextComponent("Enchantability: " + this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy)).func_240699_a_(TextFormatting.GRAY));
                if (((Boolean)Config.ALLOYS.ALLOY_CORROSION.get()).booleanValue()) {
                    tooltip.add((ITextComponent)new StringTextComponent("Corrosion Resistance: " + df.format(this.getCorrResist(stack, this.alloy) * 100.0f) + "%").func_240699_a_(TextFormatting.GRAY));
                }
                if (((Boolean)Config.ALLOYS.ALLOY_HEAT.get()).booleanValue()) {
                    tooltip.add((ITextComponent)new StringTextComponent("Heat Resistance: " + df.format(this.getHeatResist(stack, this.alloy) * 100.0f) + "%").func_240699_a_(TextFormatting.GRAY));
                }
            }
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == ItemGroup.field_78027_g || group == ProjectRankine.setup.rankineMetals) {
            items.add((Object)this.getAlloyItemStack(new AlloyData(this.alloy.getDefComposition()), this.getItem()));
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && nbt != null && !nbt.func_74779_i("nameAdd").isEmpty() && !nbt.func_74779_i("nameAdd").equals("false")) {
            String name = new TranslationTextComponent(this.func_77667_c(stack)).getString();
            String[] sp = name.split(" ");
            if (sp.length > 0) {
                name = sp[sp.length - 1];
            }
            return new StringTextComponent(stack.func_77978_p().func_74779_i("nameAdd") + " " + name);
        }
        return super.func_200295_i(stack);
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        CompoundNBT nbt;
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && (nbt = stack.func_77978_p()) != null && nbt.func_74779_i("nameAdd").isEmpty()) {
            nbt.func_74778_a("nameAdd", AlloyRecipeHelper.getAlloyFromComposition(this.getComposition(stack).func_150305_b(0).func_74781_a("comp").func_150285_a_(), worldIn));
        }
        if (!this.func_200883_f_(stack)) {
            this.func_200885_a(stack, new AlloyColorHelper().getColor(stack, 0));
        }
        super.func_77622_d(stack, worldIn, playerIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        CompoundNBT nbt;
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && (nbt = stack.func_77978_p()) != null && nbt.func_74779_i("nameAdd").isEmpty()) {
            nbt.func_74778_a("nameAdd", AlloyRecipeHelper.getAlloyFromComposition(this.getComposition(stack).func_150305_b(0).func_74781_a("comp").func_150285_a_(), worldIn));
        }
        if (!this.func_200883_f_(stack)) {
            this.func_200885_a(stack, new AlloyColorHelper().getColor(stack, 0));
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean func_200883_f_(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt != null && compoundnbt.func_150297_b("color", 99);
    }

    public int func_200886_f(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt != null && compoundnbt.func_150297_b("color", 99) ? compoundnbt.func_74762_e("color") : 10511680;
    }

    public void func_200884_g(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_74764_b("color")) {
            compoundnbt.func_82580_o("color");
        }
    }

    public void func_200885_a(ItemStack stack, int color) {
        stack.func_196082_o().func_74768_a("color", color);
    }
}

