/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.items.alloys;

import com.cannolicatfish.rankine.ProjectRankine;
import com.cannolicatfish.rankine.entities.AlloyArrowEntity;
import com.cannolicatfish.rankine.items.alloys.AlloyData;
import com.cannolicatfish.rankine.items.alloys.IAlloyArrow;
import com.cannolicatfish.rankine.recipe.helper.AlloyRecipeHelper;
import com.cannolicatfish.rankine.util.alloys.AlloyUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlloyArrowItem
extends ArrowItem
implements IAlloyArrow {
    private final AlloyUtils alloy;

    public AlloyArrowItem(AlloyUtils alloy, Item.Properties builder) {
        super(builder);
        this.alloy = alloy;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && nbt != null && !nbt.func_74779_i("nameAdd").isEmpty() && !nbt.func_74779_i("nameAdd").equals("false")) {
            String name = new TranslationTextComponent(this.func_77667_c(stack)).getString();
            String[] sp = name.split(" ");
            if (sp.length > 0) {
                name = sp[sp.length - 1];
            }
            return new StringTextComponent(stack.func_77978_p().func_74779_i("nameAdd") + " " + name);
        }
        return super.func_200295_i(stack);
    }

    public AbstractArrowEntity func_200887_a(World worldIn, ItemStack stack, LivingEntity shooter) {
        return new AlloyArrowEntity(worldIn, stack, shooter, this.getAlloyArrowDamage(this.returnCompositionString(stack, this.alloy), this.alloy));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new StringTextComponent("Composition: " + this.returnCompositionString(stack, this.alloy)).func_240699_a_(this.alloy.getAlloyGroupColor()));
            tooltip.add((ITextComponent)new StringTextComponent("Damage: " + this.getAlloyArrowDamage(this.returnCompositionString(stack, this.alloy), this.alloy)).func_240699_a_(TextFormatting.GRAY));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent("Hold shift for details...").func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Override
    public AlloyUtils returnAlloyUtils() {
        return this.alloy;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == ItemGroup.field_78027_g || group == ProjectRankine.setup.rankineTools) {
            items.add((Object)this.getAlloyItemStack(new AlloyData(this.alloy.getDefComposition()), this.getItem()));
        }
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        CompoundNBT nbt;
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && (nbt = stack.func_77978_p()) != null && nbt.func_74779_i("nameAdd").isEmpty()) {
            nbt.func_74778_a("nameAdd", AlloyRecipeHelper.getAlloyFromComposition(this.getComposition(stack).func_150305_b(0).func_74781_a("comp").func_150285_a_(), worldIn));
        }
        super.func_77622_d(stack, worldIn, playerIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        CompoundNBT nbt;
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && (nbt = stack.func_77978_p()) != null && nbt.func_74779_i("nameAdd").isEmpty()) {
            nbt.func_74778_a("nameAdd", AlloyRecipeHelper.getAlloyFromComposition(this.getComposition(stack).func_150305_b(0).func_74781_a("comp").func_150285_a_(), worldIn));
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }
}

