/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.items.alloys;

import com.cannolicatfish.rankine.ProjectRankine;
import com.cannolicatfish.rankine.init.Config;
import com.cannolicatfish.rankine.init.RankineRecipeTypes;
import com.cannolicatfish.rankine.items.alloys.AlloyData;
import com.cannolicatfish.rankine.items.alloys.IAlloyTool;
import com.cannolicatfish.rankine.items.tools.HammerItem;
import com.cannolicatfish.rankine.recipe.CrushingRecipe;
import com.cannolicatfish.rankine.recipe.helper.AlloyRecipeHelper;
import com.cannolicatfish.rankine.util.alloys.AlloyUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlloyHammerItem
extends HammerItem
implements IAlloyTool {
    private final AlloyUtils alloy;

    public AlloyHammerItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, AlloyUtils alloy, Item.Properties properties) {
        super(attackDamageIn, attackSpeedIn, tier, properties);
        this.alloy = alloy;
    }

    @Override
    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (target.func_130014_f_().func_175727_C(target.func_233580_cy_()) && AlloyHammerItem.getLightningModifier(stack) == 1) {
            LightningBoltEntity ent = new LightningBoltEntity(EntityType.field_200728_aG, attacker.field_70170_p);
            ent.func_70107_b(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
            ((ServerWorld)target.func_130014_f_()).func_217376_c((Entity)ent);
        }
        if (AlloyHammerItem.getDazeModifier(stack) != 0) {
            if (attacker instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)attacker;
                if (player.func_184825_o(0.0f) >= 1.0f) {
                    target.func_195064_c(new EffectInstance(Effects.field_76421_d, AlloyHammerItem.getDazeModifier(stack) * 20, 2));
                } else {
                    target.func_195064_c(new EffectInstance(Effects.field_76421_d, AlloyHammerItem.getDazeModifier(stack) * 20, 1));
                }
            } else {
                target.func_195064_c(new EffectInstance(Effects.field_76421_d, AlloyHammerItem.getDazeModifier(stack) * 20, 1));
            }
        }
        stack.func_222118_a(this.calcDurabilityLoss(stack, this.alloy, attacker.func_130014_f_(), attacker, true), attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        boolean creativeFlag = false;
        if (entityLiving instanceof PlayerEntity) {
            creativeFlag = ((PlayerEntity)entityLiving).func_184812_l_();
        }
        if (!worldIn.field_72995_K && worldIn.func_82736_K().func_223586_b(GameRules.field_223603_f) && !worldIn.restoringBlockSnapshots && !worldIn.func_175623_d(pos)) {
            for (CrushingRecipe recipe : worldIn.func_199532_z().func_241447_a_(RankineRecipeTypes.CRUSHING)) {
                for (ItemStack s : recipe.getIngredientAsStackList()) {
                    if (s.func_77973_b() != worldIn.func_180495_p(pos).func_177230_c().func_199767_j() || this.getAlloyMiningLevel(this.returnCompositionString(stack, this.alloy), this.alloy) < state.func_177230_c().getHarvestLevel(state)) continue;
                    if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
                        stack.func_222118_a(this.calcDurabilityLoss(stack, this.alloy, worldIn, entityLiving, true), entityLiving, p_220038_0_ -> p_220038_0_.func_213361_c(EquipmentSlotType.MAINHAND));
                    }
                    double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
                    double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
                    double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
                    if (!creativeFlag) {
                        List<ItemStack> results = recipe.getResults(this.getAlloyMiningLevel(this.returnCompositionString(stack, this.alloy), this.alloy), worldIn);
                        if (AlloyHammerItem.getAtomizeModifier(stack) >= 1) {
                            for (int i = 0; i < results.size(); ++i) {
                                if (!results.get(i).func_190926_b()) continue;
                                ItemStack resu = recipe.getSpecificResult(this.func_200891_e().func_200925_d(), i, worldIn);
                                results.set(i, resu);
                            }
                        }
                        for (ItemStack t : results) {
                            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, t.func_77946_l());
                            itementity.func_174869_p();
                            worldIn.func_217376_c((Entity)itementity);
                        }
                    }
                    worldIn.func_175655_b(pos, false);
                    return true;
                }
            }
            SoundType soundtype = worldIn.func_180495_p(pos).getSoundType((IWorldReader)worldIn, pos, null);
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundtype.func_185846_f(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f, false);
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (float)this.getDamage(stack) * 1.0f / (float)this.getAlloyDurability(this.returnCompositionString(stack, this.alloy), this.alloy);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getAlloyDurability(this.returnCompositionString(stack, this.alloy), this.alloy);
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        DecimalFormat df = (DecimalFormat)Util.func_200696_a((Object)new DecimalFormat("##.#"), p_234699_0_ -> p_234699_0_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
        if (this.returnCompositionString(stack, this.alloy) != null) {
            if (!Screen.func_231173_s_()) {
                tooltip.add((ITextComponent)new StringTextComponent("Hold shift for details...").func_240699_a_(TextFormatting.GRAY));
            }
            if (Screen.func_231173_s_()) {
                float eff = this.getAlloyEfficiency(this.returnCompositionString(stack, this.alloy), this.alloy);
                float wear = this.getWearAsPercent(eff, this.getAlloyWear(this.getWearModifierMining(eff), this.getDamage(stack), this.getMaxDamage(stack)));
                tooltip.add((ITextComponent)new StringTextComponent("Composition: " + this.returnCompositionString(stack, this.alloy)).func_240699_a_(this.alloy.getAlloyGroupColor()));
                tooltip.add((ITextComponent)new StringTextComponent("Tool Efficiency: " + Math.round(wear) + "%").func_240699_a_(this.getWearColor(wear)));
                tooltip.add((ITextComponent)new StringTextComponent("Durability: " + (this.getAlloyDurability(this.returnCompositionString(stack, this.alloy), this.alloy) - this.getDamage(stack)) + "/" + this.getAlloyDurability(this.returnCompositionString(stack, this.alloy), this.alloy)).func_240699_a_(TextFormatting.DARK_GREEN));
                tooltip.add((ITextComponent)new StringTextComponent("Harvest Level: " + this.getAlloyMiningLevel(this.returnCompositionString(stack, this.alloy), this.alloy)).func_240699_a_(TextFormatting.GRAY));
                tooltip.add((ITextComponent)new StringTextComponent("Mining Speed: " + df.format(eff)).func_240699_a_(TextFormatting.GRAY));
                tooltip.add((ITextComponent)new StringTextComponent("Enchantability: " + this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy)).func_240699_a_(TextFormatting.GRAY));
                if (((Boolean)Config.ALLOYS.ALLOY_CORROSION.get()).booleanValue()) {
                    tooltip.add((ITextComponent)new StringTextComponent("Corrosion Resistance: " + df.format(this.getCorrResist(stack, this.alloy) * 100.0f) + "%").func_240699_a_(TextFormatting.GRAY));
                }
                if (((Boolean)Config.ALLOYS.ALLOY_HEAT.get()).booleanValue()) {
                    tooltip.add((ITextComponent)new StringTextComponent("Heat Resistance: " + df.format(this.getHeatResist(stack, this.alloy) * 100.0f) + "%").func_240699_a_(TextFormatting.GRAY));
                }
                if (((Boolean)Config.ALLOYS.ALLOY_TOUGHNESS.get()).booleanValue()) {
                    tooltip.add((ITextComponent)new StringTextComponent("Toughness: " + df.format(this.getToughness(stack, this.alloy) * 100.0f) + "%").func_240699_a_(TextFormatting.GRAY));
                }
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && nbt != null && !nbt.func_74779_i("nameAdd").isEmpty() && !nbt.func_74779_i("nameAdd").equals("false")) {
            String name = new TranslationTextComponent(this.func_77667_c(stack)).getString();
            String[] sp = name.split(" ");
            if (sp.length > 0) {
                name = sp[sp.length - 1];
            }
            return new StringTextComponent(stack.func_77978_p().func_74779_i("nameAdd") + " " + name);
        }
        return super.func_200295_i(stack);
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        CompoundNBT nbt;
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && (nbt = stack.func_77978_p()) != null && nbt.func_74779_i("nameAdd").isEmpty()) {
            nbt.func_74778_a("nameAdd", AlloyRecipeHelper.getAlloyFromComposition(this.getComposition(stack).func_150305_b(0).func_74781_a("comp").func_150285_a_(), worldIn));
        }
        for (Enchantment e : this.getEnchantments(this.returnCompositionString(stack, this.alloy), stack.func_77973_b(), this.alloy)) {
            int enchLvl = this.alloy.getEnchantmentLevel(e, this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy));
            if (enchLvl <= 0) continue;
            stack.func_77966_a(e, enchLvl);
        }
        super.func_77622_d(stack, worldIn, playerIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        CompoundNBT nbt;
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && (nbt = stack.func_77978_p()) != null && nbt.func_74779_i("nameAdd").isEmpty()) {
            nbt.func_74778_a("nameAdd", AlloyRecipeHelper.getAlloyFromComposition(this.getComposition(stack).func_150305_b(0).func_74781_a("comp").func_150285_a_(), worldIn));
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == ItemGroup.field_78027_g || group == ProjectRankine.setup.rankineTools) {
            ItemStack stack = this.getAlloyItemStack(new AlloyData(this.alloy.getDefComposition()), this.getItem());
            for (Enchantment e : this.getEnchantments(this.returnCompositionString(stack, this.alloy), stack.func_77973_b(), this.alloy)) {
                int enchLvl = this.alloy.getEnchantmentLevel(e, this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy));
                if (enchLvl <= 0) continue;
                stack.func_77966_a(e, enchLvl);
            }
            items.add((Object)stack);
        }
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    public AlloyUtils returnAlloyUtils() {
        return this.alloy;
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195999_j() != null && context.func_195999_j().func_213453_ef() && context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c() instanceof AnvilBlock) {
            BlockPos pos;
            World worldIn = context.func_195991_k();
            BlockState anvil = worldIn.func_180495_p(pos = context.func_195995_a());
            if (anvil.func_177230_c() == Blocks.field_196717_eY && this.getAlloyDurability(this.returnCompositionString(context.func_195996_i(), this.alloy), this.alloy) - context.func_195996_i().func_77952_i() >= 100) {
                worldIn.func_180501_a(pos, (BlockState)Blocks.field_150467_bQ.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, anvil.func_177229_b((Property)HorizontalBlock.field_185512_D)), 2);
                worldIn.func_184133_a(context.func_195999_j(), pos, SoundEvents.field_226143_fP_, SoundCategory.BLOCKS, 1.0f, worldIn.func_201674_k().nextFloat() * 0.4f + 0.8f);
                context.func_195996_i().func_222118_a(100, (LivingEntity)context.func_195999_j(), entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
                return ActionResultType.SUCCESS;
            }
            if (anvil.func_177230_c() == Blocks.field_196718_eZ && this.getAlloyDurability(this.returnCompositionString(context.func_195996_i(), this.alloy), this.alloy) - context.func_195996_i().func_77952_i() >= 100) {
                worldIn.func_180501_a(pos, (BlockState)Blocks.field_196717_eY.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, anvil.func_177229_b((Property)HorizontalBlock.field_185512_D)), 2);
                worldIn.func_184133_a(context.func_195999_j(), pos, SoundEvents.field_226143_fP_, SoundCategory.BLOCKS, 1.0f, worldIn.func_201674_k().nextFloat() * 0.4f + 0.8f);
                context.func_195996_i().func_222118_a(100, (LivingEntity)context.func_195999_j(), entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_195939_a(context);
    }
}

