/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.items.alloys;

import com.cannolicatfish.rankine.ProjectRankine;
import com.cannolicatfish.rankine.init.Config;
import com.cannolicatfish.rankine.items.alloys.AlloyData;
import com.cannolicatfish.rankine.items.alloys.IAlloyTool;
import com.cannolicatfish.rankine.recipe.helper.AlloyRecipeHelper;
import com.cannolicatfish.rankine.util.alloys.AlloyUtils;
import com.google.common.collect.ImmutableSet;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class AlloyPickaxeItem
extends PickaxeItem
implements IAlloyTool {
    private final AlloyUtils alloy;
    private static final Set<Block> EFFECTIVE_ON = ImmutableSet.of((Object)Blocks.field_150408_cc, (Object)Blocks.field_150365_q, (Object)Blocks.field_150347_e, (Object)Blocks.field_150319_E, (Object)Blocks.field_150484_ah, (Object)Blocks.field_150482_ag, (Object[])new Block[]{Blocks.field_196552_aC, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_235334_I_, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_205164_gk, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_196583_aj, Blocks.field_196585_ak, Blocks.field_196798_hA, Blocks.field_196799_hB, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_196650_c, Blocks.field_196652_d, Blocks.field_196654_e, Blocks.field_196655_f, Blocks.field_196656_g, Blocks.field_196657_h, Blocks.field_150333_U, Blocks.field_222401_hJ, Blocks.field_196640_bx, Blocks.field_196643_by, Blocks.field_196646_bz, Blocks.field_196571_bA, Blocks.field_196573_bB, Blocks.field_196575_bC, Blocks.field_196576_bD, Blocks.field_196578_bE, Blocks.field_185771_cX, Blocks.field_196581_bI, Blocks.field_196582_bJ, Blocks.field_196580_bH, Blocks.field_196579_bG, Blocks.field_150430_aB, Blocks.field_150456_au, Blocks.field_222446_lj, Blocks.field_222447_lk, Blocks.field_222448_ll, Blocks.field_222449_lm, Blocks.field_222450_ln, Blocks.field_222451_lo, Blocks.field_222452_lp, Blocks.field_222453_lq, Blocks.field_222454_lr, Blocks.field_222455_ls, Blocks.field_222456_lt, Blocks.field_222457_lu, Blocks.field_222458_lv, Blocks.field_204409_il, Blocks.field_190975_dA, Blocks.field_190988_dw, Blocks.field_190989_dx, Blocks.field_190986_du, Blocks.field_190984_ds, Blocks.field_190990_dy, Blocks.field_190980_do, Blocks.field_196875_ie, Blocks.field_190982_dq, Blocks.field_190979_dn, Blocks.field_190978_dm, Blocks.field_190983_dr, Blocks.field_190987_dv, Blocks.field_190991_dz, Blocks.field_190977_dl, Blocks.field_190981_dp, Blocks.field_150331_J, Blocks.field_150320_F, Blocks.field_150332_K});

    public AlloyPickaxeItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, AlloyUtils alloy, Item.Properties properties) {
        super(tier, attackDamageIn, attackSpeedIn, properties.addToolType(ToolType.PICKAXE, tier.func_200925_d()));
        this.alloy = alloy;
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState blockIn) {
        int i = this.getAlloyMiningLevel(this.returnCompositionString(stack, this.alloy), this.alloy);
        if (blockIn.getHarvestTool() == ToolType.PICKAXE) {
            return i >= blockIn.getHarvestLevel();
        }
        Material material = blockIn.func_185904_a();
        return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        return material != Material.field_151573_f && material != Material.field_151574_g && material != Material.field_151576_e ? this.getToolItemDestroySpeed(stack, state) : this.getAlloyEfficiency(this.returnCompositionString(stack, this.alloy), this.alloy);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(this.calcDurabilityLoss(stack, this.alloy, attacker.func_130014_f_(), attacker, false), attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(this.calcDurabilityLoss(stack, this.alloy, worldIn, entityLiving, true), entityLiving, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public float getToolItemDestroySpeed(ItemStack stack, BlockState state) {
        if (this.getToolTypes(stack).stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0))) {
            return this.getAlloyEfficiency(this.returnCompositionString(stack, this.alloy), this.alloy);
        }
        return EFFECTIVE_ON.contains(state.func_177230_c()) ? this.getAlloyEfficiency(this.returnCompositionString(stack, this.alloy), this.alloy) : 1.0f;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (float)this.getDamage(stack) * 1.0f / (float)this.getAlloyDurability(this.returnCompositionString(stack, this.alloy), this.alloy);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getAlloyDurability(this.returnCompositionString(stack, this.alloy), this.alloy);
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        DecimalFormat df = (DecimalFormat)Util.func_200696_a((Object)new DecimalFormat("##.#"), p_234699_0_ -> p_234699_0_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
        if (this.returnCompositionString(stack, this.alloy) != null) {
            if (!Screen.func_231173_s_()) {
                tooltip.add((ITextComponent)new StringTextComponent("Hold shift for details...").func_240699_a_(TextFormatting.GRAY));
            }
            if (Screen.func_231173_s_()) {
                float eff = this.getAlloyEfficiency(this.returnCompositionString(stack, this.alloy), this.alloy);
                float wear = this.getWearAsPercent(eff, this.getAlloyWear(this.getWearModifierMining(eff), this.getDamage(stack), this.getMaxDamage(stack)));
                tooltip.add((ITextComponent)new StringTextComponent("Composition: " + this.returnCompositionString(stack, this.alloy)).func_240699_a_(this.alloy.getAlloyGroupColor()));
                tooltip.add((ITextComponent)new StringTextComponent("Tool Efficiency: " + Math.round(wear) + "%").func_240699_a_(this.getWearColor(wear)));
                tooltip.add((ITextComponent)new StringTextComponent("Durability: " + (this.getAlloyDurability(this.returnCompositionString(stack, this.alloy), this.alloy) - this.getDamage(stack)) + "/" + this.getAlloyDurability(this.returnCompositionString(stack, this.alloy), this.alloy)).func_240699_a_(TextFormatting.DARK_GREEN));
                tooltip.add((ITextComponent)new StringTextComponent("Harvest Level: " + this.getAlloyMiningLevel(this.returnCompositionString(stack, this.alloy), this.alloy)).func_240699_a_(TextFormatting.GRAY));
                tooltip.add((ITextComponent)new StringTextComponent("Mining Speed: " + df.format(eff)).func_240699_a_(TextFormatting.GRAY));
                tooltip.add((ITextComponent)new StringTextComponent("Enchantability: " + this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy)).func_240699_a_(TextFormatting.GRAY));
                if (((Boolean)Config.ALLOYS.ALLOY_CORROSION.get()).booleanValue()) {
                    tooltip.add((ITextComponent)new StringTextComponent("Corrosion Resistance: " + df.format(this.getCorrResist(stack, this.alloy) * 100.0f) + "%").func_240699_a_(TextFormatting.GRAY));
                }
                if (((Boolean)Config.ALLOYS.ALLOY_HEAT.get()).booleanValue()) {
                    tooltip.add((ITextComponent)new StringTextComponent("Heat Resistance: " + df.format(this.getHeatResist(stack, this.alloy) * 100.0f) + "%").func_240699_a_(TextFormatting.GRAY));
                }
                if (((Boolean)Config.ALLOYS.ALLOY_TOUGHNESS.get()).booleanValue()) {
                    tooltip.add((ITextComponent)new StringTextComponent("Toughness: " + df.format(this.getToughness(stack, this.alloy) * 100.0f) + "%").func_240699_a_(TextFormatting.GRAY));
                }
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && nbt != null && !nbt.func_74779_i("nameAdd").isEmpty() && !nbt.func_74779_i("nameAdd").equals("false")) {
            String name = new TranslationTextComponent(this.func_77667_c(stack)).getString();
            String[] sp = name.split(" ");
            if (sp.length > 0) {
                name = sp[sp.length - 1];
            }
            return new StringTextComponent(stack.func_77978_p().func_74779_i("nameAdd") + " " + name);
        }
        return super.func_200295_i(stack);
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        CompoundNBT nbt;
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && (nbt = stack.func_77978_p()) != null && nbt.func_74779_i("nameAdd").isEmpty()) {
            nbt.func_74778_a("nameAdd", AlloyRecipeHelper.getAlloyFromComposition(this.getComposition(stack).func_150305_b(0).func_74781_a("comp").func_150285_a_(), worldIn));
        }
        for (Enchantment e : this.getEnchantments(this.returnCompositionString(stack, this.alloy), stack.func_77973_b(), this.alloy)) {
            int enchLvl = this.alloy.getEnchantmentLevel(e, this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy));
            if (enchLvl <= 0) continue;
            stack.func_77966_a(e, enchLvl);
        }
        super.func_77622_d(stack, worldIn, playerIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        CompoundNBT nbt;
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && (nbt = stack.func_77978_p()) != null && nbt.func_74779_i("nameAdd").isEmpty()) {
            nbt.func_74778_a("nameAdd", AlloyRecipeHelper.getAlloyFromComposition(this.getComposition(stack).func_150305_b(0).func_74781_a("comp").func_150285_a_(), worldIn));
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == ItemGroup.field_78027_g || group == ProjectRankine.setup.rankineTools) {
            ItemStack stack = this.getAlloyItemStack(new AlloyData(this.alloy.getDefComposition()), this.getItem());
            for (Enchantment e : this.getEnchantments(this.returnCompositionString(stack, this.alloy), stack.func_77973_b(), this.alloy)) {
                int enchLvl = this.alloy.getEnchantmentLevel(e, this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy));
                if (enchLvl <= 0) continue;
                stack.func_77966_a(e, enchLvl);
            }
            items.add((Object)stack);
        }
    }

    @Override
    public AlloyUtils returnAlloyUtils() {
        return this.alloy;
    }
}

