/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.items.alloys;

import com.cannolicatfish.rankine.ProjectRankine;
import com.cannolicatfish.rankine.init.Config;
import com.cannolicatfish.rankine.items.alloys.AlloyData;
import com.cannolicatfish.rankine.items.alloys.IAlloyTool;
import com.cannolicatfish.rankine.recipe.helper.AlloyRecipeHelper;
import com.cannolicatfish.rankine.util.alloys.AlloyUtils;
import com.google.common.collect.Sets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ShovelItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class AlloyShovelItem
extends ShovelItem
implements IAlloyTool {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_196660_k, Blocks.field_196661_l, Blocks.field_150458_ak, Blocks.field_196658_i, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_196611_F, Blocks.field_196604_cC, Blocks.field_150433_aE, Blocks.field_150425_aM, Blocks.field_185774_da, Blocks.field_196860_iS, Blocks.field_196862_iT, Blocks.field_196864_iU, Blocks.field_196866_iV, Blocks.field_196868_iW, Blocks.field_196870_iX, Blocks.field_196872_iY, Blocks.field_196874_iZ, Blocks.field_196877_ja, Blocks.field_196878_jb, Blocks.field_196879_jc, Blocks.field_196880_jd, Blocks.field_196881_je, Blocks.field_196882_jf, Blocks.field_196883_jg, Blocks.field_196884_jh, Blocks.field_235336_cN_});
    private final AlloyUtils alloy;

    public AlloyShovelItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, AlloyUtils alloy, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder.addToolType(ToolType.SHOVEL, tier.func_200925_d()));
        this.alloy = alloy;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = world.func_180495_p(blockpos);
        if (context.func_196000_l() == Direction.DOWN) {
            return ActionResultType.PASS;
        }
        PlayerEntity playerentity = context.func_195999_j();
        BlockState blockstate1 = (BlockState)field_195955_e.get(blockstate.func_177230_c());
        BlockState blockstate2 = null;
        if (blockstate1 != null && world.func_175623_d(blockpos.func_177984_a())) {
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            blockstate2 = blockstate1;
        } else if (blockstate.func_177230_c() instanceof CampfireBlock && ((Boolean)blockstate.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
            if (!world.func_201670_d()) {
                world.func_217378_a((PlayerEntity)null, 1009, blockpos, 0);
            }
            CampfireBlock.func_235475_c_((IWorld)world, (BlockPos)blockpos, (BlockState)blockstate);
            blockstate2 = (BlockState)blockstate.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.FALSE);
        }
        if (blockstate2 != null) {
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, blockstate2, 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(this.calcDurabilityLoss(context.func_195996_i(), this.alloy, context.func_195991_k(), (LivingEntity)context.func_195999_j(), true), (LivingEntity)playerentity, p_220040_1_ -> p_220040_1_.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (this.getToolTypes(stack).stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0))) {
            return this.getAlloyEfficiency(this.returnCompositionString(stack, this.alloy), this.alloy);
        }
        return EFFECTIVE_ON.contains(state.func_177230_c()) ? this.getAlloyEfficiency(this.returnCompositionString(stack, this.alloy), this.alloy) : 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(this.calcDurabilityLoss(stack, this.alloy, attacker.func_130014_f_(), attacker, false), attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(this.calcDurabilityLoss(stack, this.alloy, worldIn, entityLiving, true), entityLiving, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (float)this.getDamage(stack) * 1.0f / (float)this.getAlloyDurability(this.returnCompositionString(stack, this.alloy), this.alloy);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getAlloyDurability(this.returnCompositionString(stack, this.alloy), this.alloy);
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        DecimalFormat df = (DecimalFormat)Util.func_200696_a((Object)new DecimalFormat("##.#"), p_234699_0_ -> p_234699_0_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
        if (this.returnCompositionString(stack, this.alloy) != null) {
            if (!Screen.func_231173_s_()) {
                tooltip.add((ITextComponent)new StringTextComponent("Hold shift for details...").func_240699_a_(TextFormatting.GRAY));
            }
            if (Screen.func_231173_s_()) {
                float eff = this.getAlloyEfficiency(this.returnCompositionString(stack, this.alloy), this.alloy);
                float wear = this.getWearAsPercent(eff, this.getAlloyWear(this.getWearModifierMining(eff), this.getDamage(stack), this.getMaxDamage(stack)));
                tooltip.add((ITextComponent)new StringTextComponent("Composition: " + this.returnCompositionString(stack, this.alloy)).func_240699_a_(this.alloy.getAlloyGroupColor()));
                tooltip.add((ITextComponent)new StringTextComponent("Tool Efficiency: " + Math.round(wear) + "%").func_240699_a_(this.getWearColor(wear)));
                tooltip.add((ITextComponent)new StringTextComponent("Durability: " + (this.getAlloyDurability(this.returnCompositionString(stack, this.alloy), this.alloy) - this.getDamage(stack)) + "/" + this.getAlloyDurability(this.returnCompositionString(stack, this.alloy), this.alloy)).func_240699_a_(TextFormatting.DARK_GREEN));
                tooltip.add((ITextComponent)new StringTextComponent("Harvest Level: " + this.getAlloyMiningLevel(this.returnCompositionString(stack, this.alloy), this.alloy)).func_240699_a_(TextFormatting.GRAY));
                tooltip.add((ITextComponent)new StringTextComponent("Mining Speed: " + df.format(eff)).func_240699_a_(TextFormatting.GRAY));
                tooltip.add((ITextComponent)new StringTextComponent("Enchantability: " + this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy)).func_240699_a_(TextFormatting.GRAY));
                if (((Boolean)Config.ALLOYS.ALLOY_CORROSION.get()).booleanValue()) {
                    tooltip.add((ITextComponent)new StringTextComponent("Corrosion Resistance: " + df.format(this.getCorrResist(stack, this.alloy) * 100.0f) + "%").func_240699_a_(TextFormatting.GRAY));
                }
                if (((Boolean)Config.ALLOYS.ALLOY_HEAT.get()).booleanValue()) {
                    tooltip.add((ITextComponent)new StringTextComponent("Heat Resistance: " + df.format(this.getHeatResist(stack, this.alloy) * 100.0f) + "%").func_240699_a_(TextFormatting.GRAY));
                }
                if (((Boolean)Config.ALLOYS.ALLOY_TOUGHNESS.get()).booleanValue()) {
                    tooltip.add((ITextComponent)new StringTextComponent("Toughness: " + df.format(this.getToughness(stack, this.alloy) * 100.0f) + "%").func_240699_a_(TextFormatting.GRAY));
                }
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && nbt != null && !nbt.func_74779_i("nameAdd").isEmpty() && !nbt.func_74779_i("nameAdd").equals("false")) {
            String name = new TranslationTextComponent(this.func_77667_c(stack)).getString();
            String[] sp = name.split(" ");
            if (sp.length > 0) {
                name = sp[sp.length - 1];
            }
            return new StringTextComponent(stack.func_77978_p().func_74779_i("nameAdd") + " " + name);
        }
        return super.func_200295_i(stack);
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        CompoundNBT nbt;
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && (nbt = stack.func_77978_p()) != null && nbt.func_74779_i("nameAdd").isEmpty()) {
            nbt.func_74778_a("nameAdd", AlloyRecipeHelper.getAlloyFromComposition(this.getComposition(stack).func_150305_b(0).func_74781_a("comp").func_150285_a_(), worldIn));
        }
        for (Enchantment e : this.getEnchantments(this.returnCompositionString(stack, this.alloy), stack.func_77973_b(), this.alloy)) {
            int enchLvl = this.alloy.getEnchantmentLevel(e, this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy));
            if (enchLvl <= 0) continue;
            stack.func_77966_a(e, enchLvl);
        }
        super.func_77622_d(stack, worldIn, playerIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        CompoundNBT nbt;
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && (nbt = stack.func_77978_p()) != null && nbt.func_74779_i("nameAdd").isEmpty()) {
            nbt.func_74778_a("nameAdd", AlloyRecipeHelper.getAlloyFromComposition(this.getComposition(stack).func_150305_b(0).func_74781_a("comp").func_150285_a_(), worldIn));
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == ItemGroup.field_78027_g || group == ProjectRankine.setup.rankineTools) {
            ItemStack stack = this.getAlloyItemStack(new AlloyData(this.alloy.getDefComposition()), this.getItem());
            for (Enchantment e : this.getEnchantments(this.returnCompositionString(stack, this.alloy), stack.func_77973_b(), this.alloy)) {
                int enchLvl = this.alloy.getEnchantmentLevel(e, this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy));
                if (enchLvl <= 0) continue;
                stack.func_77966_a(e, enchLvl);
            }
            items.add((Object)stack);
        }
    }

    @Override
    public AlloyUtils returnAlloyUtils() {
        return this.alloy;
    }
}

