/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.items.alloys;

import com.cannolicatfish.rankine.ProjectRankine;
import com.cannolicatfish.rankine.init.Config;
import com.cannolicatfish.rankine.items.alloys.AlloyData;
import com.cannolicatfish.rankine.items.alloys.IAlloyTool;
import com.cannolicatfish.rankine.recipe.helper.AlloyRecipeHelper;
import com.cannolicatfish.rankine.util.alloys.AlloyUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlloySwordItem
extends SwordItem
implements IAlloyTool {
    private final AlloyUtils alloy;

    public AlloySwordItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, AlloyUtils alloy, Item.Properties builderIn) {
        super(tier, (int)attackDamageIn, attackSpeedIn, builderIn);
        this.alloy = alloy;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(this.calcDurabilityLoss(stack, this.alloy, attacker.func_130014_f_(), attacker, true), attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(this.calcDurabilityLoss(stack, this.alloy, worldIn, entityLiving, false), entityLiving, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (float)this.getDamage(stack) * 1.0f / (float)this.getAlloyDurability(this.returnCompositionString(stack, this.alloy), this.alloy);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getAlloyDurability(this.returnCompositionString(stack, this.alloy), this.alloy);
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        DecimalFormat df = (DecimalFormat)Util.func_200696_a((Object)new DecimalFormat("##.#"), p_234699_0_ -> p_234699_0_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
        if (this.returnCompositionString(stack, this.alloy) != null) {
            if (!Screen.func_231173_s_()) {
                tooltip.add((ITextComponent)new StringTextComponent("Hold shift for details...").func_240699_a_(TextFormatting.GRAY));
            }
            if (Screen.func_231173_s_()) {
                float eff = this.getAlloyEfficiency(this.returnCompositionString(stack, this.alloy), this.alloy);
                float wear = this.getWearAsPercent(eff, this.getAlloyWear(this.getWearModifierMining(eff), this.getDamage(stack), this.getMaxDamage(stack)));
                tooltip.add((ITextComponent)new StringTextComponent("Composition: " + this.returnCompositionString(stack, this.alloy)).func_240699_a_(this.alloy.getAlloyGroupColor()));
                tooltip.add((ITextComponent)new StringTextComponent("Tool Efficiency: " + Math.round(wear) + "%").func_240699_a_(this.getWearColor(wear)));
                tooltip.add((ITextComponent)new StringTextComponent("Durability: " + (this.getAlloyDurability(this.returnCompositionString(stack, this.alloy), this.alloy) - this.getDamage(stack)) + "/" + this.getAlloyDurability(this.returnCompositionString(stack, this.alloy), this.alloy)).func_240699_a_(TextFormatting.DARK_GREEN));
                tooltip.add((ITextComponent)new StringTextComponent("Harvest Level: " + this.getAlloyMiningLevel(this.returnCompositionString(stack, this.alloy), this.alloy)).func_240699_a_(TextFormatting.GRAY));
                tooltip.add((ITextComponent)new StringTextComponent("Mining Speed: " + df.format(eff)).func_240699_a_(TextFormatting.GRAY));
                tooltip.add((ITextComponent)new StringTextComponent("Enchantability: " + this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy)).func_240699_a_(TextFormatting.GRAY));
                if (((Boolean)Config.ALLOYS.ALLOY_CORROSION.get()).booleanValue()) {
                    tooltip.add((ITextComponent)new StringTextComponent("Corrosion Resistance: " + df.format(this.getCorrResist(stack, this.alloy) * 100.0f) + "%").func_240699_a_(TextFormatting.GRAY));
                }
                if (((Boolean)Config.ALLOYS.ALLOY_HEAT.get()).booleanValue()) {
                    tooltip.add((ITextComponent)new StringTextComponent("Heat Resistance: " + df.format(this.getHeatResist(stack, this.alloy) * 100.0f) + "%").func_240699_a_(TextFormatting.GRAY));
                }
                if (((Boolean)Config.ALLOYS.ALLOY_TOUGHNESS.get()).booleanValue()) {
                    tooltip.add((ITextComponent)new StringTextComponent("Toughness: " + df.format(this.getToughness(stack, this.alloy) * 100.0f) + "%").func_240699_a_(TextFormatting.GRAY));
                }
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && nbt != null && !nbt.func_74779_i("nameAdd").isEmpty() && !nbt.func_74779_i("nameAdd").equals("false")) {
            String name = new TranslationTextComponent(this.func_77667_c(stack)).getString();
            String[] sp = name.split(" ");
            if (sp.length > 0) {
                name = sp[sp.length - 1];
            }
            return new StringTextComponent(stack.func_77978_p().func_74779_i("nameAdd") + " " + name);
        }
        return super.func_200295_i(stack);
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        CompoundNBT nbt;
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && (nbt = stack.func_77978_p()) != null && nbt.func_74779_i("nameAdd").isEmpty()) {
            nbt.func_74778_a("nameAdd", AlloyRecipeHelper.getAlloyFromComposition(this.getComposition(stack).func_150305_b(0).func_74781_a("comp").func_150285_a_(), worldIn));
        }
        for (Enchantment e : this.getEnchantments(this.returnCompositionString(stack, this.alloy), stack.func_77973_b(), this.alloy)) {
            int enchLvl = this.alloy.getEnchantmentLevel(e, this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy));
            if (enchLvl <= 0) continue;
            stack.func_77966_a(e, enchLvl);
        }
        super.func_77622_d(stack, worldIn, playerIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        CompoundNBT nbt;
        if (this.getComposition(stack).size() > 0 && this.alloy.getDefComposition().equals("80Hg-20Au") && (nbt = stack.func_77978_p()) != null && nbt.func_74779_i("nameAdd").isEmpty()) {
            nbt.func_74778_a("nameAdd", AlloyRecipeHelper.getAlloyFromComposition(this.getComposition(stack).func_150305_b(0).func_74781_a("comp").func_150285_a_(), worldIn));
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == ItemGroup.field_78027_g || group == ProjectRankine.setup.rankineTools) {
            ItemStack stack = this.getAlloyItemStack(new AlloyData(this.alloy.getDefComposition()), this.getItem());
            for (Enchantment e : this.getEnchantments(this.returnCompositionString(stack, this.alloy), stack.func_77973_b(), this.alloy)) {
                int enchLvl = this.alloy.getEnchantmentLevel(e, this.getAlloyEnchantability(this.returnCompositionString(stack, this.alloy), this.alloy));
                if (enchLvl <= 0) continue;
                stack.func_77966_a(e, enchLvl);
            }
            items.add((Object)stack);
        }
    }

    @Override
    public AlloyUtils returnAlloyUtils() {
        return this.alloy;
    }
}

