/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.items.alloys;

import com.cannolicatfish.rankine.init.Config;
import com.cannolicatfish.rankine.items.alloys.AlloyData;
import com.cannolicatfish.rankine.util.PeriodicTableUtils;
import com.cannolicatfish.rankine.util.alloys.AlloyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public interface IAlloyTool {
    public static final PeriodicTableUtils utils = PeriodicTableUtils.getInstance();

    default public int getAlloyDurability(String comp, AlloyUtils alloy) {
        return utils.calcDurability(this.getElements(comp), this.getPercents(comp)) + alloy.getDurabilityBonus();
    }

    default public float getAlloyEfficiency(String comp, AlloyUtils alloy) {
        return utils.calcMiningSpeed(this.getElements(comp), this.getPercents(comp)) + alloy.getMiningSpeedBonus();
    }

    default public int getAlloyEnchantability(String comp, AlloyUtils alloy) {
        return utils.calcEnchantability(this.getElements(comp), this.getPercents(comp)) + alloy.getEnchantabilityBonus();
    }

    default public int getAlloyMiningLevel(String comp, AlloyUtils alloy) {
        return utils.calcMiningLevel(this.getElements(comp), this.getPercents(comp)) + alloy.getMiningLevelBonus();
    }

    default public float getAlloyWear(float wmodifier, int currentDurability, int maxDurability) {
        return wmodifier - wmodifier * (((float)maxDurability - (float)currentDurability) / (float)maxDurability);
    }

    default public float getWearModifierMining(float eff) {
        return eff * ((Double)Config.ALLOYS.ALLOY_WEAR_MINING_AMT.get()).floatValue();
    }

    default public float getWearModifierDmg(float dmg) {
        return dmg * ((Double)Config.ALLOYS.ALLOY_WEAR_DAMAGE_AMT.get()).floatValue();
    }

    default public float getWearAsPercent(float modstat, float wear) {
        return (modstat - wear) / modstat * 100.0f;
    }

    default public float getAlloyAttackDamage(String comp, AlloyUtils alloy) {
        return utils.calcDamage(this.getElements(comp), this.getPercents(comp)) + alloy.getAttackDamageBonus();
    }

    default public float getAlloyAttackSpeed(String comp, AlloyUtils alloy) {
        return Math.max(utils.calcAttackSpeed(this.getElements(comp), this.getPercents(comp)) + alloy.getAttackSpeedBonus(), 0.0f);
    }

    default public float getCorrResist(ItemStack stack, AlloyUtils alloy) {
        if (!((Boolean)Config.ALLOYS.ALLOY_CORROSION.get()).booleanValue()) {
            return 100.0f;
        }
        if (this.getComposition(stack).size() != 0) {
            String comp = this.getComposition(stack).func_150305_b(0).func_74781_a("comp").func_150285_a_();
            return Math.max(Math.min(utils.calcCorrResist(this.getElements(comp), this.getPercents(comp)) + alloy.getCorrResistBonus(), 1.0f), 0.0f);
        }
        return alloy.getCorrResistBonus();
    }

    default public float getHeatResist(ItemStack stack, AlloyUtils alloy) {
        if (!((Boolean)Config.ALLOYS.ALLOY_HEAT.get()).booleanValue()) {
            return 100.0f;
        }
        if (this.getComposition(stack).size() != 0) {
            String comp = this.getComposition(stack).func_150305_b(0).func_74781_a("comp").func_150285_a_();
            return Math.max(Math.min(utils.calcHeatResist(this.getElements(comp), this.getPercents(comp)) + alloy.getHeatResistBonus(), 1.0f), 0.0f);
        }
        return alloy.getHeatResistBonus();
    }

    default public float getToughness(ItemStack stack, AlloyUtils alloy) {
        if (!((Boolean)Config.ALLOYS.ALLOY_TOUGHNESS.get()).booleanValue()) {
            return 0.0f;
        }
        if (this.getComposition(stack).size() != 0) {
            String comp = this.getComposition(stack).func_150305_b(0).func_74781_a("comp").func_150285_a_();
            return utils.calcToughness(this.getElements(comp), this.getPercents(comp)) + alloy.getToughnessBonus();
        }
        return alloy.getToughnessBonus();
    }

    default public int calcDurabilityLoss(ItemStack stack, AlloyUtils alloy, World worldIn, LivingEntity entityLiving, boolean isEfficient) {
        Random rand = new Random();
        int i = 1;
        float toughness = this.getToughness(stack, alloy);
        if (toughness > 0.0f && rand.nextFloat() < toughness) {
            --i;
        }
        if (toughness < 0.0f && rand.nextFloat() < Math.abs(toughness)) {
            ++i;
        }
        if (rand.nextFloat() > this.getHeatResist(stack, alloy) && (entityLiving.func_180799_ab() || entityLiving.func_223314_ad() > 0 || worldIn.func_234923_W_() == World.field_234919_h_)) {
            i += ((Integer)Config.ALLOYS.ALLOY_HEAT_AMT.get()).intValue();
        }
        if (rand.nextFloat() > this.getCorrResist(stack, alloy) && entityLiving.func_70026_G()) {
            i += ((Integer)Config.ALLOYS.ALLOY_CORROSION_AMT.get()).intValue();
        }
        if (!isEfficient) {
            i *= 2;
        }
        return i;
    }

    default public TextFormatting getWearColor(float wear) {
        if (wear >= 80.0f) {
            return TextFormatting.AQUA;
        }
        if (wear >= 60.0f) {
            return TextFormatting.GREEN;
        }
        if (wear >= 40.0f) {
            return TextFormatting.YELLOW;
        }
        if (wear >= 20.0f) {
            return TextFormatting.RED;
        }
        return TextFormatting.GRAY;
    }

    default public String returnCompositionString(ItemStack stack, AlloyUtils alloy) {
        INBT nbt = this.getComposition(stack).func_150305_b(0).func_74781_a("comp");
        return nbt != null ? nbt.func_150285_a_() : alloy.getDefComposition();
    }

    default public String returnCompositionString(ItemStack stack) {
        INBT nbt = this.getComposition(stack).func_150305_b(0).func_74781_a("comp");
        return nbt != null ? nbt.func_150285_a_() : "100Fe";
    }

    default public ListNBT getComposition(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt != null ? compoundnbt.func_150295_c("StoredComposition", 10) : new ListNBT();
    }

    default public void addAlloy(ItemStack p_92115_0_, AlloyData stack) {
        ListNBT listnbt = this.getComposition(p_92115_0_);
        CompoundNBT compoundnbt1 = new CompoundNBT();
        compoundnbt1.func_74778_a("comp", stack.alloyComposition);
        listnbt.add((Object)compoundnbt1);
        p_92115_0_.func_196082_o().func_218657_a("StoredComposition", (INBT)listnbt);
    }

    default public ItemStack getAlloyItemStack(AlloyData alloyData, Item item) {
        ItemStack itemstack = new ItemStack((IItemProvider)item);
        this.addAlloy(itemstack, alloyData);
        return itemstack;
    }

    default public List<PeriodicTableUtils.Element> getElements(String c) {
        PeriodicTableUtils utils = PeriodicTableUtils.getInstance();
        String[] comp = c.split("-");
        ArrayList<PeriodicTableUtils.Element> list = new ArrayList<PeriodicTableUtils.Element>();
        for (String e : comp) {
            String str = e.replaceAll("[^A-Za-z]+", "");
            list.add(utils.getElementBySymbol(str));
        }
        return list;
    }

    default public List<Integer> getPercents(String c) {
        String[] comp = c.split("-");
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String e : comp) {
            String str = e.replaceAll("\\D+", "");
            list.add(Integer.parseInt(str));
        }
        return list;
    }

    default public List<Enchantment> getEnchantments(String c, Item item, AlloyUtils alloy) {
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        List<Enchantment> elementEn = utils.getEnchantments(this.getElements(c), this.getPercents(c));
        for (Enchantment e : elementEn) {
            if (e == null || enchantments.contains(e)) continue;
            enchantments.add(e);
        }
        List<Enchantment> en = alloy.getEnchantmentBonus(item);
        for (Enchantment e : en) {
            if (e == null || enchantments.contains(e)) continue;
            enchantments.add(e);
        }
        return enchantments;
    }

    public AlloyUtils returnAlloyUtils();
}

