/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.items.tools;

import com.cannolicatfish.rankine.init.RankineEnchantments;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CrowbarItem
extends ToolItem {
    private static final Set<Block> effectiveBlocks = ImmutableSet.of((Object)Blocks.field_196670_r);

    public CrowbarItem(float attackDamageIn, float attackSpeedIn, IItemTier tier, Item.Properties p_i48512_5_) {
        super(attackDamageIn, attackSpeedIn, tier, effectiveBlocks, p_i48512_5_);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(1, entityLiving, p_220038_0_ -> p_220038_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        if (this.func_150897_b(state) && !worldIn.field_72995_K && !stack.func_190926_b() && worldIn.func_82736_K().func_223586_b(GameRules.field_223603_f) && !worldIn.restoringBlockSnapshots) {
            double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, new ItemStack((IItemProvider)state.func_177230_c().func_199767_j(), 1));
            itementity.func_174869_p();
            worldIn.func_217376_c((Entity)itementity);
            worldIn.func_217377_a(pos, false);
            SoundType soundtype = worldIn.func_180495_p(pos).getSoundType((IWorldReader)worldIn, pos, null);
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundtype.func_185845_c(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f, false);
        }
        return true;
    }

    public boolean func_150897_b(BlockState blockIn) {
        int i = this.func_200891_e().func_200925_d();
        if (blockIn.func_177230_c().getTags().contains(new ResourceLocation("rankine:crowbar"))) {
            return i >= blockIn.getHarvestLevel();
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof PlayerEntity && isSelected) {
            PlayerEntity player = (PlayerEntity)entityIn;
            if (player.field_184622_au == Hand.OFF_HAND) {
                player.func_184821_cY();
                player.field_184622_au = Hand.MAIN_HAND;
            }
        }
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            BlockPos pos;
            PlayerEntity player = (PlayerEntity)entity;
            World worldIn = player.func_130014_f_();
            BlockRayTraceResult raytraceresult = CrowbarItem.func_219968_a((World)worldIn, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
            if (raytraceresult instanceof BlockRayTraceResult) {
                BlockRayTraceResult rayTraceResult = raytraceresult;
                pos = rayTraceResult.func_216350_a();
            } else {
                pos = new BlockPos(raytraceresult.func_216347_e().field_72450_a, raytraceresult.func_216347_e().field_72448_b, raytraceresult.func_216347_e().field_72449_c);
            }
            if ((double)player.func_184825_o(0.0f) >= 1.0 - 0.15 * (double)CrowbarItem.getSwingModifier(stack)) {
                player.func_184821_cY();
                this.func_179218_a(stack, worldIn, worldIn.func_180495_p(pos), pos, (LivingEntity)player);
            }
        }
        return false;
    }

    public static int getSwingModifier(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)RankineEnchantments.SWING, (ItemStack)stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.field_185305_q || enchantment == Enchantments.field_185306_r || enchantment == Enchantments.field_185308_t) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }
}

