/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.items.tools;

import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.init.RankineEnchantments;
import com.cannolicatfish.rankine.init.RankineRecipeTypes;
import com.cannolicatfish.rankine.recipe.CrushingRecipe;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ToolItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class HammerItem
extends ToolItem {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150348_b, Blocks.field_150347_e, Blocks.field_196579_bG, Blocks.field_150322_A, Blocks.field_180395_cM, (Block)RankineBlocks.GRAY_GRANITE.get(), (Block)RankineBlocks.HORNBLENDE_ANDESITE.get(), (Block)RankineBlocks.GRANODIORITE.get(), (Block)RankineBlocks.TUFA_LIMESTONE.get(), (Block)RankineBlocks.THOLEIITIC_BASALT.get(), (Block)RankineBlocks.RHYOLITE.get(), (Block)RankineBlocks.GNEISS.get(), (Block)RankineBlocks.WHITE_MARBLE.get(), (Block)RankineBlocks.CARBONACEOUS_SHALE.get(), (Block)RankineBlocks.IRONSTONE.get(), (Block)RankineBlocks.ANORTHOSITE.get(), (Block)RankineBlocks.MAGNETITE_ORE.get(), (Block)RankineBlocks.MALACHITE_ORE.get(), (Block)RankineBlocks.BAUXITE_ORE.get(), (Block)RankineBlocks.CASSITERITE_ORE.get(), (Block)RankineBlocks.SPHALERITE_ORE.get(), (Block)RankineBlocks.CINNABAR_ORE.get(), (Block)RankineBlocks.PENTLANDITE_ORE.get(), (Block)RankineBlocks.LIGNITE_ORE.get(), (Block)RankineBlocks.SUBBITUMINOUS_ORE.get(), (Block)RankineBlocks.BITUMINOUS_ORE.get(), (Block)RankineBlocks.METEORITE.get()});

    public HammerItem(float attackDamageIn, float attackSpeedIn, IItemTier tier, Item.Properties builder) {
        super(attackDamageIn, attackSpeedIn, tier, EFFECTIVE_ON, builder);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        boolean creativeFlag = false;
        if (entityLiving instanceof PlayerEntity) {
            creativeFlag = ((PlayerEntity)entityLiving).func_184812_l_();
        }
        if (!worldIn.field_72995_K && worldIn.func_82736_K().func_223586_b(GameRules.field_223603_f) && !worldIn.restoringBlockSnapshots && !worldIn.func_175623_d(pos)) {
            for (CrushingRecipe recipe : worldIn.func_199532_z().func_241447_a_(RankineRecipeTypes.CRUSHING)) {
                for (ItemStack s : (ItemStack[])recipe.getIngredientAsStackList().clone()) {
                    if (s.func_77973_b() != worldIn.func_180495_p(pos).func_177230_c().func_199767_j() || this.func_200891_e().func_200925_d() < state.func_177230_c().getHarvestLevel(state)) continue;
                    if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
                        stack.func_222118_a(1, entityLiving, p_220038_0_ -> p_220038_0_.func_213361_c(EquipmentSlotType.MAINHAND));
                    }
                    double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
                    double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
                    double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
                    if (creativeFlag) continue;
                    List<ItemStack> results = recipe.getResults(this.func_200891_e().func_200925_d(), worldIn);
                    if (HammerItem.getAtomizeModifier(stack) >= 1) {
                        for (int i = 0; i < results.size(); ++i) {
                            if (!results.get(i).func_190926_b()) continue;
                            ItemStack resu = recipe.getSpecificResult(this.func_200891_e().func_200925_d(), i, worldIn);
                            results.set(i, resu);
                        }
                    }
                    for (ItemStack t : results) {
                        ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, t.func_77946_l());
                        itementity.func_174869_p();
                        worldIn.func_217376_c((Entity)itementity);
                    }
                    worldIn.func_175655_b(pos, false);
                    return true;
                }
            }
            SoundType soundtype = worldIn.func_180495_p(pos).getSoundType((IWorldReader)worldIn, pos, null);
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundtype.func_185846_f(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f, false);
        }
        return false;
    }

    public boolean func_150897_b(BlockState blockIn) {
        int i = this.func_200891_e().func_200925_d();
        return i >= blockIn.getHarvestLevel();
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (target.func_130014_f_().func_175727_C(target.func_233580_cy_()) && HammerItem.getLightningModifier(stack) == 1) {
            LightningBoltEntity ent = new LightningBoltEntity(EntityType.field_200728_aG, attacker.field_70170_p);
            ent.func_70107_b(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
            target.func_130014_f_().func_217376_c((Entity)ent);
        }
        if (HammerItem.getDazeModifier(stack) != 0) {
            if (attacker instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)attacker;
                if (player.func_184825_o(0.0f) >= 1.0f) {
                    target.func_195064_c(new EffectInstance(Effects.field_76421_d, HammerItem.getDazeModifier(stack) * 10, HammerItem.getDazeModifier(stack) * 2));
                } else {
                    target.func_195064_c(new EffectInstance(Effects.field_76421_d, HammerItem.getDazeModifier(stack) * 10, 1));
                }
            } else {
                target.func_195064_c(new EffectInstance(Effects.field_76421_d, HammerItem.getDazeModifier(stack) * 10, 1));
            }
        }
        stack.func_222118_a(1, attacker, p_220045_0_ -> p_220045_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public void getExcavationResult(BlockPos pos, World worldIn, PlayerEntity player, ItemStack stack) {
        BlockRayTraceResult raytraceresult = HammerItem.func_219968_a((World)worldIn, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (HammerItem.getExcavateModifier(stack) == 1) {
            switch (raytraceresult.func_216354_b()) {
                case EAST: 
                case WEST: {
                    positions.addAll(Arrays.asList(pos, pos.func_177978_c(), pos.func_177968_d(), pos.func_177984_a(), pos.func_177977_b()));
                    break;
                }
                case DOWN: 
                case UP: {
                    positions.addAll(Arrays.asList(pos, pos.func_177978_c(), pos.func_177968_d(), pos.func_177976_e(), pos.func_177974_f()));
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    positions.addAll(Arrays.asList(pos, pos.func_177974_f(), pos.func_177976_e(), pos.func_177984_a(), pos.func_177977_b()));
                    break;
                }
                default: {
                    positions.add(pos);
                    break;
                }
            }
        } else {
            switch (raytraceresult.func_216354_b()) {
                case EAST: 
                case WEST: {
                    positions.addAll(Arrays.asList(pos, pos.func_177978_c(), pos.func_177968_d(), pos.func_177984_a(), pos.func_177977_b(), pos.func_177978_c().func_177984_a(), pos.func_177968_d().func_177984_a(), pos.func_177978_c().func_177977_b(), pos.func_177968_d().func_177977_b()));
                    break;
                }
                case DOWN: 
                case UP: {
                    positions.addAll(Arrays.asList(pos, pos.func_177978_c(), pos.func_177968_d(), pos.func_177976_e(), pos.func_177974_f(), pos.func_177978_c().func_177974_f(), pos.func_177968_d().func_177974_f(), pos.func_177978_c().func_177976_e(), pos.func_177968_d().func_177976_e()));
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    positions.addAll(Arrays.asList(pos, pos.func_177974_f(), pos.func_177976_e(), pos.func_177984_a(), pos.func_177977_b(), pos.func_177984_a().func_177974_f(), pos.func_177977_b().func_177974_f(), pos.func_177984_a().func_177976_e(), pos.func_177977_b().func_177976_e()));
                    break;
                }
                default: {
                    positions.add(pos);
                }
            }
        }
        for (BlockPos p : positions) {
            this.func_179218_a(stack, worldIn, worldIn.func_180495_p(p), p, (LivingEntity)player);
        }
    }

    public static int getLightningModifier(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)RankineEnchantments.LIGHTNING_ASPECT, (ItemStack)stack);
    }

    public static int getDazeModifier(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)RankineEnchantments.DAZE, (ItemStack)stack);
    }

    public static int getExcavateModifier(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)RankineEnchantments.EXCAVATE, (ItemStack)stack);
    }

    public static int getAtomizeModifier(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)RankineEnchantments.ATOMIZE, (ItemStack)stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.field_185305_q || enchantment == Enchantments.field_185306_r || enchantment == Enchantments.field_185308_t) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195999_j() != null && context.func_195999_j().func_213453_ef() && context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c() instanceof AnvilBlock) {
            BlockPos pos;
            World worldIn = context.func_195991_k();
            BlockState anvil = worldIn.func_180495_p(pos = context.func_195995_a());
            if (anvil.func_177230_c() == Blocks.field_196717_eY && context.func_195996_i().func_77958_k() - context.func_195996_i().func_77952_i() >= 100) {
                worldIn.func_180501_a(pos, (BlockState)Blocks.field_150467_bQ.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, anvil.func_177229_b((Property)HorizontalBlock.field_185512_D)), 2);
                worldIn.func_184133_a(context.func_195999_j(), pos, SoundEvents.field_226143_fP_, SoundCategory.BLOCKS, 1.0f, worldIn.func_201674_k().nextFloat() * 0.4f + 0.8f);
                context.func_195996_i().func_222118_a(100, (LivingEntity)context.func_195999_j(), entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
                return ActionResultType.SUCCESS;
            }
            if (anvil.func_177230_c() == Blocks.field_196718_eZ && context.func_195996_i().func_77958_k() - context.func_195996_i().func_77952_i() >= 100) {
                worldIn.func_180501_a(pos, (BlockState)Blocks.field_196717_eY.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, anvil.func_177229_b((Property)HorizontalBlock.field_185512_D)), 2);
                worldIn.func_184133_a(context.func_195999_j(), pos, SoundEvents.field_226143_fP_, SoundCategory.BLOCKS, 1.0f, worldIn.func_201674_k().nextFloat() * 0.4f + 0.8f);
                context.func_195996_i().func_222118_a(100, (LivingEntity)context.func_195999_j(), entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_195939_a(context);
    }
}

