/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.items.tools;

import com.cannolicatfish.rankine.entities.SpearEntity;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SpearItem
extends Item {
    private final float attackDamage;
    private final float attackSpeedIn;
    public ResourceLocation type;
    public EntityType<SpearEntity> entity;
    private IItemTier tier;
    private ImmutableMultimap<Attribute, AttributeModifier> attributeModifiers;

    public SpearItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, EntityType<SpearEntity> entity, ResourceLocation type, Item.Properties properties) {
        super(properties.func_200915_b(tier.func_200926_a()));
        this.attackSpeedIn = attackSpeedIn;
        this.attackDamage = attackDamageIn + tier.func_200929_c();
        this.type = type;
        this.entity = entity;
        this.tier = tier;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)attackSpeedIn, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND ? this.attributeModifiers : super.func_111205_h(equipmentSlot);
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.SPEAR;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77948_v();
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            int j;
            PlayerEntity playerentity = (PlayerEntity)entityLiving;
            int i = this.func_77626_a(stack) - timeLeft;
            if (i >= 10 && ((j = EnchantmentHelper.func_203190_g((ItemStack)stack)) <= 0 || playerentity.func_70026_G())) {
                if (!worldIn.field_72995_K) {
                    stack.func_222118_a(1, (LivingEntity)playerentity, p_220047_1_ -> p_220047_1_.func_213334_d(entityLiving.func_184600_cs()));
                    if (j == 0) {
                        SpearEntity spearentity = new SpearEntity(worldIn, (LivingEntity)playerentity, stack, this.entity, this.type, this.attackDamage);
                        spearentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z, 0.0f, 2.5f + (float)j * 0.5f, 1.0f);
                        if (playerentity.field_71075_bZ.field_75098_d) {
                            spearentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                        }
                        worldIn.func_217376_c((Entity)spearentity);
                        worldIn.func_217384_a((PlayerEntity)null, (Entity)spearentity, SoundEvents.field_203274_ip, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        if (!playerentity.field_71075_bZ.field_75098_d) {
                            playerentity.field_71071_by.func_184437_d(stack);
                        }
                    }
                }
                playerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                if (j > 0) {
                    float f7 = playerentity.field_70177_z;
                    float f = playerentity.field_70125_A;
                    float f1 = -MathHelper.func_76126_a((float)(f7 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
                    float f2 = -MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
                    float f3 = MathHelper.func_76134_b((float)(f7 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
                    float f4 = MathHelper.func_76129_c((float)(f1 * f1 + f2 * f2 + f3 * f3));
                    float f5 = 3.0f * ((1.0f + (float)j) / 4.0f);
                    playerentity.func_70024_g((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
                    playerentity.func_204803_n(20);
                    if (playerentity.func_233570_aj_()) {
                        float f6 = 1.1999999f;
                        playerentity.func_213315_a(MoverType.SELF, new Vector3d(0.0, 1.1999999284744263, 0.0));
                    }
                    SoundEvent soundevent = j >= 3 ? SoundEvents.field_203273_io : (j == 2 ? SoundEvents.field_203272_in : SoundEvents.field_203271_im);
                    worldIn.func_217384_a((PlayerEntity)null, (Entity)playerentity, soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
            return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
        }
        if (EnchantmentHelper.func_203190_g((ItemStack)itemstack) > 0 && !playerIn.func_70026_G()) {
            return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public int func_77619_b() {
        return this.tier.func_200927_e();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.tier.func_200924_f().test(repair) || super.func_82789_a(toRepair, repair);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, p_220048_0_ -> p_220048_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if ((double)state.func_185887_b((IBlockReader)worldIn, pos) != 0.0) {
            stack.func_222118_a(2, entityLiving, p_220046_0_ -> p_220046_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.field_203194_D || enchantment == Enchantments.field_203193_C) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }
}

