/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.recipe;

import com.cannolicatfish.rankine.items.alloys.AlloyData;
import com.cannolicatfish.rankine.items.alloys.AlloyItem;
import com.cannolicatfish.rankine.recipe.helper.AlloyIngredientHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AlloyCraftingRecipe
implements ICraftingRecipe,
IShapedRecipe<CraftingInventory> {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    private final int recipeWidth;
    private final int recipeHeight;
    private final NonNullList<Ingredient> recipeItems;
    private final ItemStack recipeOutput;
    private final ResourceLocation id;
    private final String group;
    private final boolean inherit;
    public static final Serializer SERIALIZER = new Serializer();

    public static void setCraftingSize(int width, int height) {
        if (MAX_WIDTH < width) {
            MAX_WIDTH = width;
        }
        if (MAX_HEIGHT < height) {
            MAX_HEIGHT = height;
        }
    }

    public AlloyCraftingRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn, boolean inherit) {
        this.id = idIn;
        this.group = groupIn;
        this.recipeWidth = recipeWidthIn;
        this.recipeHeight = recipeHeightIn;
        this.recipeItems = recipeItemsIn;
        this.recipeOutput = recipeOutputIn;
        this.inherit = inherit;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public String func_193358_e() {
        return this.group;
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.recipeItems;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.recipeWidth && height >= this.recipeHeight;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        for (int i = 0; i <= inv.func_174922_i() - this.recipeWidth; ++i) {
            for (int j = 0; j <= inv.func_174923_h() - this.recipeHeight; ++j) {
                if (this.checkMatch(inv, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(CraftingInventory craftingInventory, int width, int height, boolean p_77573_4_) {
        for (int i = 0; i < craftingInventory.func_174922_i(); ++i) {
            for (int j = 0; j < craftingInventory.func_174923_h(); ++j) {
                ItemStack stackInSlot;
                int k = i - width;
                int l = j - height;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (k >= 0 && l >= 0 && k < this.recipeWidth && l < this.recipeHeight) {
                    ingredient = p_77573_4_ ? (Ingredient)this.recipeItems.get(this.recipeWidth - k - 1 + l * this.recipeWidth) : (Ingredient)this.recipeItems.get(k + l * this.recipeWidth);
                }
                if (!ingredient.test(stackInSlot = craftingInventory.func_70301_a(i + j * craftingInventory.func_174922_i()))) {
                    return false;
                }
                if (ingredient.func_193365_a().length <= 0 || AlloyItem.getComposition(ingredient.func_193365_a()[0]).size() == 0) continue;
                INBT ingComp = AlloyItem.getComposition(stackInSlot).func_150305_b(0).func_74781_a("comp");
                INBT slotComp = AlloyItem.getComposition(ingredient.func_193365_a()[0]).func_150305_b(0).func_74781_a("comp");
                if (ingComp == null || slotComp == null || ingComp.toString().equals(slotComp.toString()) || ingComp.toString().equals("")) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack res = this.func_77571_b().func_77946_l();
        if (this.inherit) {
            String workingComposition = "";
            for (int i = 0; i < inv.func_174922_i(); ++i) {
                for (int j = 0; j < inv.func_174923_h(); ++j) {
                    ItemStack stackInSlot = inv.func_70301_a(i + j * inv.func_174922_i());
                    INBT stackINBT = AlloyItem.getComposition(stackInSlot).func_150305_b(0).func_74781_a("comp");
                    if (stackINBT == null) continue;
                    String comp = stackINBT.func_150285_a_();
                    if (workingComposition.equals("")) {
                        workingComposition = comp;
                    }
                    if (comp.equals(workingComposition)) continue;
                    return ItemStack.field_190927_a;
                }
            }
            res = new ItemStack((IItemProvider)res.func_77973_b(), res.func_190916_E());
            if (!workingComposition.equals("")) {
                AlloyItem.addAlloy(res, new AlloyData(workingComposition));
            } else {
                System.out.println("Alloy recipe error! Please report this to the developers!");
                return res;
            }
        }
        return res;
    }

    public int getWidth() {
        return this.recipeWidth;
    }

    public int getRecipeWidth() {
        return this.getWidth();
    }

    public int getHeight() {
        return this.recipeHeight;
    }

    public int getRecipeHeight() {
        return this.getHeight();
    }

    private static NonNullList<Ingredient> deserializeIngredients(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)(patternWidth * patternHeight), (Object)Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] shrink(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < toShrink.length; ++i1) {
            String s = toShrink[i1];
            i = Math.min(i, AlloyCraftingRecipe.firstNonSpace(s));
            int j1 = AlloyCraftingRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[toShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = toShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] patternFromJson(JsonArray jsonArr) {
        String[] astring = new String[jsonArr.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = JSONUtils.func_151206_a((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    private static Map<String, Ingredient> deserializeKey(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            String alloyData = null;
            if (((JsonElement)entry.getValue()).isJsonObject() && ((JsonElement)entry.getValue()).getAsJsonObject().has("alloyData")) {
                alloyData = JSONUtils.func_151200_h((JsonObject)((JsonElement)entry.getValue()).getAsJsonObject(), (String)"alloyData");
            }
            map.put(entry.getKey(), AlloyIngredientHelper.deserialize((JsonElement)entry.getValue(), alloyData));
        }
        map.put(" ", Ingredient.field_193370_a);
        return map;
    }

    public static ItemStack deserializeItem(JsonObject object) {
        String s = JSONUtils.func_151200_h((JsonObject)object, (String)"item");
        Item item = (Item)Registry.field_212630_s.func_241873_b(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
        return AlloyIngredientHelper.getItemStack(object, true);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AlloyCraftingRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("rankine", "alloy_crafting");

        public AlloyCraftingRecipe read(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Map map = AlloyCraftingRecipe.deserializeKey(JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] astring = AlloyCraftingRecipe.shrink(AlloyCraftingRecipe.patternFromJson(JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList nonnulllist = AlloyCraftingRecipe.deserializeIngredients(astring, map, i, j);
            ItemStack itemstack = AlloyCraftingRecipe.deserializeItem(JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            boolean e = json.has("inherit") && JSONUtils.func_151212_i((JsonObject)json, (String)"inherit");
            return new AlloyCraftingRecipe(recipeId, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack, e);
        }

        public AlloyCraftingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int i = buffer.func_150792_a();
            int j = buffer.func_150792_a();
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            NonNullList nonnulllist = NonNullList.func_191197_a((int)(i * j), (Object)Ingredient.field_193370_a);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack itemstack = buffer.func_150791_c();
            boolean e = buffer.readBoolean();
            return new AlloyCraftingRecipe(recipeId, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack, e);
        }

        public void write(PacketBuffer buffer, AlloyCraftingRecipe recipe) {
            buffer.func_150787_b(recipe.recipeWidth);
            buffer.func_150787_b(recipe.recipeHeight);
            buffer.func_180714_a(recipe.group);
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.recipeOutput);
            buffer.writeBoolean(recipe.inherit);
        }
    }
}

