/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.recipe;

import com.cannolicatfish.rankine.blocks.alloyfurnace.AlloyFurnaceTile;
import com.cannolicatfish.rankine.blocks.inductionfurnace.InductionFurnaceTile;
import com.cannolicatfish.rankine.init.RankineItems;
import com.cannolicatfish.rankine.init.RankineRecipeTypes;
import com.cannolicatfish.rankine.items.alloys.AlloyData;
import com.cannolicatfish.rankine.items.alloys.AlloyItem;
import com.cannolicatfish.rankine.recipe.helper.AlloyIngredientHelper;
import com.cannolicatfish.rankine.recipe.helper.AlloyRecipeHelper;
import com.cannolicatfish.rankine.util.PeriodicTableUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AlloyingRecipe
implements IRecipe<IInventory> {
    private final int total;
    private final int required;
    private final int tier;
    private final NonNullList<Ingredient> recipeItems;
    private final NonNullList<PeriodicTableUtils.Element> elements;
    private final ItemStack recipeOutput;
    private final ResourceLocation id;
    private final NonNullList<Float> mins;
    private final NonNullList<Float> maxes;
    public static final Serializer SERIALIZER = new Serializer();

    public AlloyingRecipe(ResourceLocation idIn, int totalIn, int requiredIn, int tierIn, NonNullList<Ingredient> recipeItemsIn, NonNullList<PeriodicTableUtils.Element> elementsIn, ItemStack outputIn, NonNullList<Float> minsIn, NonNullList<Float> maxesIn) {
        this.id = idIn;
        this.total = totalIn;
        this.required = requiredIn;
        this.tier = tierIn;
        this.recipeItems = recipeItemsIn;
        this.elements = elementsIn;
        this.recipeOutput = outputIn;
        this.mins = minsIn;
        this.maxes = maxesIn;
    }

    public String func_193358_e() {
        return "";
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.recipeItems;
    }

    public int getTier() {
        return this.tier;
    }

    public List<Ingredient> getIngredientsList(boolean required) {
        ArrayList<Ingredient> ret = new ArrayList<Ingredient>();
        for (int i = 0; i < this.recipeItems.size(); ++i) {
            if (!(((Float)this.mins.get(i)).floatValue() > 0.0f && required) && (((Float)this.mins.get(i)).floatValue() != 0.0f || required)) continue;
            ret.add((Ingredient)this.recipeItems.get(i));
        }
        return ret;
    }

    public List<Integer> getIndexList(boolean required) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < this.recipeItems.size(); ++i) {
            if (!(((Float)this.mins.get(i)).floatValue() > 0.0f && required) && (((Float)this.mins.get(i)).floatValue() != 0.0f || required)) continue;
            ret.add(i);
        }
        return ret;
    }

    public List<PeriodicTableUtils.Element> getElementList(boolean required) {
        ArrayList<PeriodicTableUtils.Element> ret = new ArrayList<PeriodicTableUtils.Element>();
        for (int i = 0; i < this.recipeItems.size(); ++i) {
            if (!(((Float)this.mins.get(i)).floatValue() > 0.0f && required) && (((Float)this.mins.get(i)).floatValue() != 0.0f || required)) continue;
            ret.add((PeriodicTableUtils.Element)((Object)this.elements.get(i)));
        }
        return ret;
    }

    public ItemStack generateResult(IInventory inv, int type) {
        if ((this.getTier() & type) != Math.min(this.getTier(), type) && this.getTier() != 0 && type != 0) {
            return ItemStack.field_190927_a;
        }
        ArrayList<PeriodicTableUtils.Element> currentElements = new ArrayList<PeriodicTableUtils.Element>();
        ArrayList<Integer> currentMaterial = new ArrayList<Integer>();
        for (int i = 0; i < 6; ++i) {
            int workingIndex = 0;
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            boolean flag = false;
            for (Ingredient s : this.func_192400_c()) {
                if (!s.test(stack)) continue;
                PeriodicTableUtils.Element element = (PeriodicTableUtils.Element)((Object)this.getElements().get(this.func_192400_c().indexOf((Object)s)));
                if (!currentElements.contains((Object)element)) {
                    currentElements.add(element);
                    currentMaterial.add(0);
                }
                workingIndex = currentElements.indexOf((Object)element);
                flag = true;
            }
            if (flag) {
                Item item = stack.func_77973_b();
                ResourceLocation reg = item.getRegistryName();
                String registry = "";
                if (reg != null) {
                    registry = reg.func_110623_a();
                }
                if (stack.func_77973_b().getTags().contains(new ResourceLocation("forge:storage_blocks")) || stack.func_77973_b() instanceof BlockItem || registry.contains("block")) {
                    currentMaterial.set(workingIndex, (Integer)currentMaterial.get(workingIndex) + 81 * stack.func_190916_E());
                    continue;
                }
                if (stack.func_77973_b().getTags().contains(new ResourceLocation("forge:ingots")) || registry.contains("ingot")) {
                    currentMaterial.set(workingIndex, (Integer)currentMaterial.get(workingIndex) + 9 * stack.func_190916_E());
                    continue;
                }
                if (stack.func_77973_b().getTags().contains(new ResourceLocation("forge:nuggets")) || registry.contains("nugget")) {
                    currentMaterial.set(workingIndex, (Integer)currentMaterial.get(workingIndex) + stack.func_190916_E());
                    continue;
                }
                if (stack.func_77973_b() == Items.field_234760_kn_ || registry.contains("scrap")) {
                    currentMaterial.set(workingIndex, (Integer)currentMaterial.get(workingIndex) + 2 * stack.func_190916_E());
                    continue;
                }
                currentMaterial.set(workingIndex, (Integer)currentMaterial.get(workingIndex) + 9 * stack.func_190916_E());
                continue;
            }
            return ItemStack.field_190927_a;
        }
        int sum = currentMaterial.stream().mapToInt(Integer::intValue).sum();
        if ((Math.round((float)sum / 10.0f) > 64 || Math.round((float)sum / 10.0f) < 1) && currentElements.size() >= this.required) {
            return ItemStack.field_190927_a;
        }
        for (PeriodicTableUtils.Element e : this.getElementList(true)) {
            if (currentElements.contains((Object)e)) continue;
            return ItemStack.field_190927_a;
        }
        ArrayList<Integer> percents = new ArrayList<Integer>();
        ArrayList<String> symbols = new ArrayList<String>();
        for (int j = 0; j < currentElements.size(); ++j) {
            PeriodicTableUtils.Element curEl = (PeriodicTableUtils.Element)((Object)currentElements.get(j));
            int curPer = Math.round((float)((Integer)currentMaterial.get(j)).intValue() * 100.0f / (float)sum);
            int windex = this.getElements().indexOf((Object)curEl);
            if (Math.round(((Float)this.getMins().get(windex)).floatValue() * 100.0f) > curPer || Math.round(((Float)this.getMaxes().get(windex)).floatValue() * 100.0f) < curPer) {
                return ItemStack.field_190927_a;
            }
            symbols.add(curEl.getSymbol());
            percents.add(curPer);
        }
        if (percents.stream().mapToInt(Integer::intValue).sum() != 100 || percents.contains(0)) {
            return ItemStack.field_190927_a;
        }
        ItemStack out = new ItemStack((IItemProvider)this.recipeOutput.func_77946_l().func_77973_b(), Math.round((float)sum / 10.0f));
        AlloyItem.addAlloy(out, new AlloyData(AlloyRecipeHelper.getDirectComposition(percents, symbols)));
        return out;
    }

    public ItemStack generateRandomResult(World worldIn) {
        PeriodicTableUtils.Element curEl;
        int curPer;
        ArrayList<Integer> percents = new ArrayList<Integer>();
        ArrayList<String> symbols = new ArrayList<String>();
        List<PeriodicTableUtils.Element> req = this.getElementList(true);
        List<PeriodicTableUtils.Element> nonreq = this.getElementList(false);
        int r = worldIn.func_201674_k().nextInt(6 - this.required) + this.required;
        int total = 0;
        for (int j = 0; j < r && !symbols.contains((curEl = j < req.size() ? req.get(j) : nonreq.get(worldIn.func_201674_k().nextInt(nonreq.size()))).getSymbol()) && total < 100; total += curPer, ++j) {
            int windex = this.getElements().indexOf((Object)curEl);
            int min = Math.round(((Float)this.getMins().get(windex)).floatValue() * 100.0f);
            int max = Math.round(((Float)this.getMaxes().get(windex)).floatValue() * 100.0f);
            curPer = Math.min(worldIn.func_201674_k().nextInt(max - min) + min, 100 - total);
            symbols.add(curEl.getSymbol());
            percents.add(curPer);
        }
        ItemStack out = new ItemStack((IItemProvider)this.recipeOutput.func_77946_l().func_77973_b(), 1);
        AlloyItem.addAlloy(out, new AlloyData(AlloyRecipeHelper.getDirectComposition(percents, symbols)));
        return out;
    }

    public NonNullList<Float> getMins() {
        return this.mins;
    }

    public NonNullList<Float> getMaxes() {
        return this.maxes;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        if (inv instanceof AlloyFurnaceTile) {
            return !this.generateResult(inv, 1).func_190926_b();
        }
        if (inv instanceof InductionFurnaceTile) {
            return !this.generateResult(inv, 2).func_190926_b();
        }
        if (this.getTier() != 0) {
            return !this.generateResult(inv, 3).func_190926_b();
        }
        return false;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput.func_77946_l();
    }

    public int getTotal() {
        return this.total;
    }

    public NonNullList<PeriodicTableUtils.Element> getElements() {
        return this.elements;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static ItemStack deserializeItem(JsonObject object) {
        String s = JSONUtils.func_151200_h((JsonObject)object, (String)"item");
        Item item = (Item)Registry.field_212630_s.func_241873_b(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
        return AlloyIngredientHelper.getItemStack(object, true, false);
    }

    public IRecipeType<?> func_222127_g() {
        return RankineRecipeTypes.ALLOYING;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AlloyingRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("rankine", "alloying");

        public AlloyingRecipe read(ResourceLocation recipeId, JsonObject json) {
            int reqcount = 0;
            int t = json.get("total").getAsInt();
            int y = json.has("tier") ? json.get("tier").getAsInt() : 3;
            NonNullList nonnulllist = NonNullList.func_191197_a((int)t, (Object)Ingredient.field_193370_a);
            String s1 = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            ItemStack stack = new ItemStack((IItemProvider)Registry.field_212630_s.func_241873_b(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
            NonNullList elements = NonNullList.func_191197_a((int)t, (Object)((Object)PeriodicTableUtils.Element.MERCURY));
            NonNullList mins = NonNullList.func_191197_a((int)t, (Object)Float.valueOf(0.0f));
            NonNullList maxes = NonNullList.func_191197_a((int)t, (Object)Float.valueOf(0.0f));
            for (int i = 0; i < t; ++i) {
                boolean e;
                String input = "input" + (i + 1);
                if (!json.has(input)) continue;
                JsonObject object = JSONUtils.func_152754_s((JsonObject)json, (String)input);
                String elementTag = "";
                if (object.has("element")) {
                    elements.set(i, (Object)PeriodicTableUtils.Element.valueOfCaseIgnored(object.get("element").getAsString()));
                    elementTag = object.get("element").getAsString().toLowerCase();
                } else {
                    elements.set(i, (Object)PeriodicTableUtils.Element.MERCURY);
                    elementTag = "mercury";
                }
                boolean bl = e = !object.has("auto") || object.has("auto") && JSONUtils.func_151212_i((JsonObject)object, (String)"auto");
                if (e) {
                    String rs = "rankine:elements/" + elementTag;
                    JsonObject d = new JsonObject();
                    d.addProperty("tag", rs);
                    Ingredient out = AlloyIngredientHelper.deserialize((JsonElement)d, null);
                    if (out != Ingredient.field_193370_a) {
                        nonnulllist.set(i, (Object)AlloyIngredientHelper.deserialize((JsonElement)d, null));
                    } else {
                        nonnulllist.set(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)RankineItems.ELEMENT.get())}));
                    }
                } else {
                    nonnulllist.set(i, (Object)AlloyIngredientHelper.deserialize((JsonElement)object, null));
                }
                if (object.has("min")) {
                    mins.set(i, (Object)Float.valueOf(Math.min(Math.max(object.get("min").getAsFloat(), 0.0f), 1.0f)));
                    if (object.get("min").getAsFloat() > 0.0f) {
                        ++reqcount;
                    }
                } else {
                    mins.set(i, (Object)Float.valueOf(0.0f));
                }
                if (object.has("max")) {
                    maxes.set(i, (Object)Float.valueOf(Math.min(Math.max(object.get("max").getAsFloat(), 0.0f), 1.0f)));
                    continue;
                }
                maxes.set(i, (Object)Float.valueOf(0.0f));
            }
            int r = json.has("required") && reqcount < json.get("required").getAsInt() ? json.get("required").getAsInt() : reqcount;
            if (r > 5 || r <= 1) {
                throw new JsonParseException("Unsupported number of alloy ingredient requirements (" + r + ") in " + json);
            }
            return new AlloyingRecipe(recipeId, t, r, y, (NonNullList<Ingredient>)nonnulllist, (NonNullList<PeriodicTableUtils.Element>)elements, stack, (NonNullList<Float>)mins, (NonNullList<Float>)maxes);
        }

        public AlloyingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int t = buffer.readInt();
            int r = buffer.readInt();
            int y = buffer.readInt();
            NonNullList nonnulllist = NonNullList.func_191197_a((int)t, (Object)Ingredient.field_193370_a);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            NonNullList elements = NonNullList.func_191197_a((int)t, (Object)((Object)PeriodicTableUtils.Element.MERCURY));
            for (int k = 0; k < elements.size(); ++k) {
                elements.set(k, (Object)PeriodicTableUtils.Element.valueOfCaseIgnored(buffer.func_218666_n()));
            }
            ItemStack stack = buffer.func_150791_c();
            NonNullList mins = NonNullList.func_191197_a((int)t, (Object)Float.valueOf(0.0f));
            for (int k = 0; k < mins.size(); ++k) {
                mins.set(k, (Object)Float.valueOf(buffer.readFloat()));
            }
            NonNullList maxes = NonNullList.func_191197_a((int)t, (Object)Float.valueOf(0.0f));
            for (int k = 0; k < maxes.size(); ++k) {
                maxes.set(k, (Object)Float.valueOf(buffer.readFloat()));
            }
            return new AlloyingRecipe(recipeId, t, r, y, (NonNullList<Ingredient>)nonnulllist, (NonNullList<PeriodicTableUtils.Element>)elements, stack, (NonNullList<Float>)mins, (NonNullList<Float>)maxes);
        }

        public void write(PacketBuffer buffer, AlloyingRecipe recipe) {
            buffer.writeInt(recipe.total);
            buffer.writeInt(recipe.required);
            buffer.writeInt(recipe.tier);
            int count = 0;
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.func_199564_a(buffer);
                ++count;
            }
            while (count < recipe.total) {
                Ingredient.field_193370_a.func_199564_a(buffer);
                ++count;
            }
            count = 0;
            for (PeriodicTableUtils.Element element : recipe.elements) {
                buffer.func_180714_a(element.name());
                ++count;
            }
            while (count < recipe.total) {
                buffer.func_180714_a(PeriodicTableUtils.Element.MERCURY.name());
                ++count;
            }
            buffer.func_150788_a(recipe.recipeOutput);
            count = 0;
            Iterator iterator = recipe.mins.iterator();
            while (iterator.hasNext()) {
                float chance = ((Float)iterator.next()).floatValue();
                buffer.writeFloat(chance);
                ++count;
            }
            while (count < recipe.total) {
                buffer.writeFloat(0.0f);
                ++count;
            }
            count = 0;
            iterator = recipe.maxes.iterator();
            while (iterator.hasNext()) {
                float add = ((Float)iterator.next()).floatValue();
                buffer.writeFloat(add);
                ++count;
            }
            while (count < recipe.total) {
                buffer.writeFloat(0.0f);
                ++count;
            }
        }
    }
}

