/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.recipe;

import com.cannolicatfish.rankine.init.RankineItems;
import com.cannolicatfish.rankine.init.RankineRecipeTypes;
import com.cannolicatfish.rankine.items.alloys.AlloyData;
import com.cannolicatfish.rankine.items.alloys.AlloyItem;
import com.cannolicatfish.rankine.recipe.AlloyCraftingRecipe;
import com.cannolicatfish.rankine.recipe.helper.AlloyIngredientHelper;
import com.cannolicatfish.rankine.recipe.helper.AlloyRecipeHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CrucibleRecipe
implements IRecipe<IInventory> {
    private final NonNullList<Ingredient> recipeItems;
    private final int cookTime;
    private final int total;
    private final String alloyComp;
    private final NonNullList<Integer> ingredientGroups;
    private final NonNullList<Boolean> required;
    private final NonNullList<Integer> countMod;
    private final NonNullList<Integer> cookMod;
    private final NonNullList<List<String>> shiftMod;
    private final ItemStack recipeOutput;
    private final ItemStack secondaryOutput;
    private final int color;
    private final ResourceLocation id;
    public static final Serializer SERIALIZER = new Serializer();

    public CrucibleRecipe(ResourceLocation idIn, int cookTimeIn, int totalIn, int colorIn, NonNullList<Ingredient> recipeItemsIn, NonNullList<Integer> ingredientGroupsIn, NonNullList<Boolean> requiredIn, NonNullList<Integer> countModIn, NonNullList<Integer> cookModIn, NonNullList<List<String>> shiftsIn, ItemStack outputIn, String alloyCompIn, ItemStack secondaryOutputIn) {
        this.id = idIn;
        this.ingredientGroups = ingredientGroupsIn;
        this.cookTime = cookTimeIn;
        this.total = totalIn;
        this.color = colorIn;
        this.required = requiredIn;
        this.countMod = countModIn;
        this.cookMod = cookModIn;
        this.shiftMod = shiftsIn;
        this.recipeItems = recipeItemsIn;
        this.alloyComp = alloyCompIn;
        this.recipeOutput = outputIn;
        this.secondaryOutput = secondaryOutputIn;
    }

    public String func_193358_e() {
        return "";
    }

    public int getColor() {
        return this.color;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.recipeItems;
    }

    public List<Ingredient> getCondensedIngredients() {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (int i = 0; i < 4; ++i) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int s : this.getIndexList(i)) {
                stacks.addAll(Arrays.asList(((Ingredient)this.func_192400_c().get(s)).func_193365_a()));
            }
            if (stacks.isEmpty()) {
                stacks.add(new ItemStack((IItemProvider)RankineItems.ELEMENT.get()));
            }
            ingredients.add(Ingredient.func_193369_a((ItemStack[])stacks.toArray(new ItemStack[0])));
        }
        for (int s : this.getIndexList(-1)) {
            ingredients.add((Ingredient)this.func_192400_c().get(s));
        }
        return ingredients;
    }

    public List<Integer> getIndexList(int val) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < this.func_192400_c().size(); ++i) {
            if ((Integer)this.getIngredientGroups().get(i) != val && (val >= 0 && val <= 3 || (Integer)this.getIngredientGroups().get(i) >= 0 && (Integer)this.getIngredientGroups().get(i) <= 3)) continue;
            ret.add(i);
        }
        return ret;
    }

    public ItemStack generateResult(IInventory inv) {
        ItemStack output = this.getPrimaryOutput().func_77946_l();
        ArrayList<Object> groupsUsed = new ArrayList<Object>();
        ArrayList<List<String>> alloyCommands = new ArrayList<List<String>>();
        for (int s = 0; s < 4; ++s) {
            ItemStack stack = inv.func_70301_a(s);
            int workingIndex = -1;
            for (int i = 0; i < this.func_192400_c().size(); ++i) {
                if (!((Ingredient)this.func_192400_c().get(i)).test(stack)) continue;
                workingIndex = i;
                break;
            }
            if (workingIndex == -1) {
                return ItemStack.field_190927_a;
            }
            output.func_190917_f(((Integer)this.getCountMod().get(workingIndex)).intValue());
            groupsUsed.add(this.getIngredientGroups().get(workingIndex));
            if ((Integer)this.getIngredientGroups().get(workingIndex) != -1 && Collections.frequency(groupsUsed, this.getIngredientGroups().get(workingIndex)) > 1) {
                return ItemStack.field_190927_a;
            }
            alloyCommands.add((List<String>)this.getShiftMod().get(workingIndex));
        }
        if (this.alloyComp.isEmpty()) {
            return output;
        }
        AlloyItem.addAlloy(output, new AlloyData(this.returnAlloyDataMod(alloyCommands)));
        return output;
    }

    public String returnAlloyDataMod(List<List<String>> alloyCommands) {
        ArrayList<String> elements = new ArrayList<String>();
        ArrayList<Integer> nums = new ArrayList<Integer>();
        for (String s : this.getAlloyComp().split("-")) {
            elements.add(s.replaceAll("[\\d.-]", ""));
            nums.add(Integer.parseInt(s.replaceAll("[^\\d.-]", "")));
        }
        block1: for (List list : alloyCommands) {
            int cons = 0;
            for (String str : list) {
                String strCheck;
                int workingIndex;
                int negative = str.contains("-") ? -1 : 1;
                String numCheck = str.replaceAll("[^\\d.]", "");
                int num = 0;
                if (!numCheck.isEmpty()) {
                    num = Integer.parseInt(numCheck);
                }
                if ((workingIndex = elements.indexOf(strCheck = str.replaceAll("[\\d.-]", ""))) != -1) {
                    if (num == 0) {
                        if (cons == 0) {
                            cons = (Integer)nums.get(workingIndex);
                            nums.set(workingIndex, (Integer)nums.get(workingIndex) + cons * negative);
                            continue;
                        }
                        nums.set(workingIndex, (Integer)nums.get(workingIndex) + cons * negative);
                        continue;
                    }
                    nums.set(workingIndex, (Integer)nums.get(workingIndex) + num * negative);
                    continue;
                }
                if (num <= 0) continue block1;
                nums.add(num);
                elements.add(strCheck);
            }
        }
        return AlloyRecipeHelper.getDirectComposition(nums, elements);
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return !this.generateResult(inv).func_190926_b();
    }

    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_77571_b() {
        if (this.alloyComp.isEmpty()) {
            return this.recipeOutput.func_77946_l();
        }
        ItemStack stack = this.recipeOutput.func_77946_l();
        AlloyItem.addAlloy(stack, new AlloyData(this.alloyComp));
        return stack;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public int getRecipeCookTime(IInventory inv) {
        int cook = this.getCookTime();
        for (int s = 0; s < 4; ++s) {
            ItemStack stack = inv.func_70301_a(s);
            int workingIndex = -1;
            for (int i = 0; i < this.func_192400_c().size(); ++i) {
                if (!((Ingredient)this.func_192400_c().get(i)).test(stack)) continue;
                workingIndex = i;
                break;
            }
            cook += ((Integer)this.getCookMod().get(workingIndex)).intValue();
        }
        return cook;
    }

    public int getTotal() {
        return this.total;
    }

    public ItemStack getPrimaryOutput() {
        return this.recipeOutput.func_77946_l();
    }

    public ItemStack getSecondaryOutput() {
        return this.secondaryOutput.func_77946_l();
    }

    public NonNullList<Boolean> getRequired() {
        return this.required;
    }

    public NonNullList<Ingredient> getRecipeItems() {
        return this.recipeItems;
    }

    public NonNullList<Integer> getCountMod() {
        return this.countMod;
    }

    public NonNullList<Integer> getCookMod() {
        return this.cookMod;
    }

    public NonNullList<Integer> getIngredientGroups() {
        return this.ingredientGroups;
    }

    public NonNullList<List<String>> getShiftMod() {
        return this.shiftMod;
    }

    public String getAlloyComp() {
        return this.alloyComp;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static ItemStack deserializeItem(JsonObject object) {
        String s = JSONUtils.func_151200_h((JsonObject)object, (String)"item");
        Item item = (Item)Registry.field_212630_s.func_241873_b(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
        return AlloyIngredientHelper.getItemStack(object, true, false);
    }

    public IRecipeType<?> func_222127_g() {
        return RankineRecipeTypes.CRUCIBLE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CrucibleRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("rankine", "crucible");

        public CrucibleRecipe read(ResourceLocation recipeId, JsonObject json) {
            int i;
            int c = json.get("cookTime").getAsInt();
            int t = json.get("total").getAsInt();
            int col = json.has("color") ? json.get("color").getAsInt() : 0xFFFFFF;
            NonNullList requiredbool = NonNullList.func_191197_a((int)4, (Object)false);
            NonNullList ingredients = NonNullList.func_191197_a((int)t, (Object)Ingredient.field_193370_a);
            NonNullList groups = NonNullList.func_191197_a((int)t, (Object)-1);
            NonNullList countMods = NonNullList.func_191197_a((int)t, (Object)0);
            NonNullList cookMods = NonNullList.func_191197_a((int)t, (Object)0);
            NonNullList shiftMods = NonNullList.func_191197_a((int)t, Collections.emptyList());
            ItemStack itemstack = AlloyCraftingRecipe.deserializeItem(JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            String alloy = json.has("alloyData") ? json.get("alloyData").getAsString() : "";
            ItemStack secondary = AlloyCraftingRecipe.deserializeItem(JSONUtils.func_152754_s((JsonObject)json, (String)"secondary"));
            JsonArray req = JSONUtils.func_151214_t((JsonObject)json, (String)"required");
            for (i = 0; i < req.size(); ++i) {
                requiredbool.set(i, (Object)req.get(i).getAsBoolean());
            }
            for (i = 0; i < t; ++i) {
                String input = "input" + (i + 1);
                if (!json.has(input)) continue;
                JsonObject object = JSONUtils.func_152754_s((JsonObject)json, (String)input);
                ingredients.set(i, (Object)AlloyIngredientHelper.deserialize((JsonElement)object, null));
                if (object.has("group")) {
                    groups.set(i, (Object)object.get("group").getAsInt());
                }
                if (object.has("countMod")) {
                    countMods.set(i, (Object)object.get("countMod").getAsInt());
                }
                if (object.has("cookMod")) {
                    cookMods.set(i, (Object)object.get("cookMod").getAsInt());
                }
                if (!object.has("shiftMod")) continue;
                JsonArray smod = JSONUtils.func_151214_t((JsonObject)object, (String)"shiftMod");
                ArrayList<String> strL = new ArrayList<String>();
                for (int j = 0; j < smod.size(); ++j) {
                    strL.add(j, smod.get(j).getAsString());
                }
                shiftMods.set(i, strL);
            }
            return new CrucibleRecipe(recipeId, c, t, col, (NonNullList<Ingredient>)ingredients, (NonNullList<Integer>)groups, (NonNullList<Boolean>)requiredbool, (NonNullList<Integer>)countMods, (NonNullList<Integer>)cookMods, (NonNullList<List<String>>)shiftMods, itemstack, alloy, secondary);
        }

        public CrucibleRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int i;
            int c = buffer.readInt();
            int t = buffer.readInt();
            int col = buffer.readInt();
            NonNullList req = NonNullList.func_191197_a((int)4, (Object)false);
            NonNullList ingredients = NonNullList.func_191197_a((int)t, (Object)Ingredient.field_193370_a);
            NonNullList groups = NonNullList.func_191197_a((int)t, (Object)-1);
            NonNullList countMods = NonNullList.func_191197_a((int)t, (Object)0);
            NonNullList cookMods = NonNullList.func_191197_a((int)t, (Object)0);
            NonNullList shiftMods = NonNullList.func_191197_a((int)t, Collections.emptyList());
            for (i = 0; i < 4; ++i) {
                req.set(i, (Object)buffer.readBoolean());
            }
            for (i = 0; i < t; ++i) {
                ingredients.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
                groups.set(i, (Object)buffer.readInt());
                countMods.set(i, (Object)buffer.readInt());
                cookMods.set(i, (Object)buffer.readInt());
                int s = buffer.readInt();
                String[] str = new String[s];
                if (s <= 0) continue;
                for (int j = 0; j < s; ++j) {
                    str[j] = buffer.func_218666_n();
                }
                shiftMods.set(i, Arrays.asList(str));
            }
            ItemStack stack = buffer.func_150791_c();
            String all = buffer.func_218666_n();
            ItemStack secondary = buffer.func_150791_c();
            return new CrucibleRecipe(recipeId, c, t, col, (NonNullList<Ingredient>)ingredients, (NonNullList<Integer>)groups, (NonNullList<Boolean>)req, (NonNullList<Integer>)countMods, (NonNullList<Integer>)cookMods, (NonNullList<List<String>>)shiftMods, stack, all, secondary);
        }

        public void write(PacketBuffer buffer, CrucibleRecipe recipe) {
            int i;
            buffer.writeInt(recipe.getCookTime());
            buffer.writeInt(recipe.getTotal());
            buffer.writeInt(recipe.getColor());
            for (i = 0; i < 4; ++i) {
                if (i < recipe.getRequired().size()) {
                    buffer.writeBoolean(((Boolean)recipe.getRequired().get(i)).booleanValue());
                    continue;
                }
                buffer.writeBoolean(false);
            }
            for (i = 0; i < recipe.getTotal(); ++i) {
                ((Ingredient)recipe.func_192400_c().get(i)).func_199564_a(buffer);
                buffer.writeInt(((Integer)recipe.getIngredientGroups().get(i)).intValue());
                buffer.writeInt(((Integer)recipe.getCountMod().get(i)).intValue());
                buffer.writeInt(((Integer)recipe.getCookMod().get(i)).intValue());
                buffer.writeInt(((List)recipe.getShiftMod().get(i)).size());
                if (((List)recipe.getShiftMod().get(i)).size() <= 0) continue;
                for (int j = 0; j < ((List)recipe.getShiftMod().get(i)).size(); ++j) {
                    buffer.func_180714_a((String)((List)recipe.getShiftMod().get(i)).get(j));
                }
            }
            buffer.func_150788_a(recipe.getPrimaryOutput());
            buffer.func_180714_a(recipe.getAlloyComp());
            buffer.func_150788_a(recipe.getSecondaryOutput());
        }
    }
}

