/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.recipe;

import com.cannolicatfish.rankine.init.RankineItems;
import com.cannolicatfish.rankine.init.RankineRecipeTypes;
import com.cannolicatfish.rankine.recipe.helper.AlloyIngredientHelper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CrushingRecipe
implements IRecipe<IInventory> {
    private final NonNullList<Ingredient> recipeItems;
    private final NonNullList<ItemStack> recipeOutputs;
    private final ResourceLocation id;
    private final NonNullList<Float> chances;
    private final NonNullList<Float> additional;
    public static final Serializer SERIALIZER = new Serializer();

    public CrushingRecipe(ResourceLocation idIn, NonNullList<Ingredient> recipeItemsIn, NonNullList<ItemStack> recipeOutputsIn, NonNullList<Float> chancesIn, NonNullList<Float> additionalIn) {
        this.id = idIn;
        this.recipeItems = recipeItemsIn;
        this.recipeOutputs = recipeOutputsIn;
        this.chances = chancesIn;
        this.additional = additionalIn;
    }

    public String func_193358_e() {
        return "";
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.recipeItems;
    }

    public NonNullList<Float> getChances() {
        return this.chances;
    }

    public NonNullList<Float> getAdditional() {
        return this.additional;
    }

    public NonNullList<ItemStack> getRecipeOutputs() {
        return this.recipeOutputs;
    }

    public NonNullList<ItemStack> getRecipeOutputsJEI() {
        if (this.recipeOutputs.contains((Object)ItemStack.field_190927_a)) {
            NonNullList<ItemStack> newJeiCopy = this.recipeOutputs;
            newJeiCopy.replaceAll(stack -> {
                if (stack == ItemStack.field_190927_a) {
                    return new ItemStack((IItemProvider)RankineItems.ELEMENT.get());
                }
                return stack;
            });
            return newJeiCopy;
        }
        return this.recipeOutputs;
    }

    public ItemStack[] getIngredientAsStackList() {
        return (ItemStack[])((Ingredient)this.recipeItems.get(0)).func_193365_a().clone();
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return ((Ingredient)this.recipeItems.get(0)).test(inv.func_70301_a(0));
    }

    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public List<ItemStack> getResults(int harvestLevel, World worldIn) {
        Random random = worldIn.func_201674_k();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        int check = Math.min(harvestLevel + 1, 6);
        for (int i = 0; i < check; ++i) {
            float c;
            float f = c = harvestLevel == i ? ((Float)this.chances.get(i)).floatValue() + ((Float)this.additional.get(i)).floatValue() : ((Float)this.chances.get(i)).floatValue();
            if (random.nextFloat() < c) {
                outputs.add((ItemStack)this.recipeOutputs.get(i));
                continue;
            }
            outputs.add(ItemStack.field_190927_a);
        }
        return outputs;
    }

    public List<ItemStack> getPossibleResults(int harvestLevel, World worldIn) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        int check = Math.min(harvestLevel + 1, 6);
        for (int i = 0; i < check; ++i) {
            outputs.add((ItemStack)this.recipeOutputs.get(i));
        }
        return outputs;
    }

    public ItemStack getSpecificResult(int harvestLevel, int index, World worldIn) {
        float c;
        Random random = worldIn.func_201674_k();
        ItemStack outputs = ItemStack.field_190927_a;
        float f = c = harvestLevel == index ? ((Float)this.chances.get(index)).floatValue() + ((Float)this.additional.get(index)).floatValue() : ((Float)this.chances.get(index)).floatValue();
        if (random.nextFloat() < c) {
            outputs = (ItemStack)this.recipeOutputs.get(index);
        }
        return outputs;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static ItemStack deserializeItem(JsonObject object) {
        String s = JSONUtils.func_151200_h((JsonObject)object, (String)"item");
        Item item = (Item)Registry.field_212630_s.func_241873_b(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
        return AlloyIngredientHelper.getItemStack(object, true);
    }

    public IRecipeType<?> func_222127_g() {
        return RankineRecipeTypes.CRUSHING;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CrushingRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("rankine", "crushing");

        public CrushingRecipe read(ResourceLocation recipeId, JsonObject json) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)1, (Object)Ingredient.field_193370_a);
            nonnulllist.set(0, (Object)AlloyIngredientHelper.deserialize(json.get("input"), null));
            NonNullList stacks = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
            NonNullList chances = NonNullList.func_191197_a((int)6, (Object)Float.valueOf(0.0f));
            NonNullList additional = NonNullList.func_191197_a((int)6, (Object)Float.valueOf(0.0f));
            for (int i = 0; i < 6; ++i) {
                String output = "output" + (i + 1);
                if (!json.has(output)) continue;
                JsonObject object = JSONUtils.func_152754_s((JsonObject)json, (String)output);
                stacks.set(i, (Object)CrushingRecipe.deserializeItem(object));
                if (object.has("chance")) {
                    chances.set(i, (Object)Float.valueOf(object.get("chance").getAsFloat()));
                } else {
                    chances.set(i, (Object)Float.valueOf(0.0f));
                }
                if (object.has("additional")) {
                    additional.set(i, (Object)Float.valueOf(object.get("additional").getAsFloat()));
                    continue;
                }
                additional.set(i, (Object)Float.valueOf(0.0f));
            }
            return new CrushingRecipe(recipeId, (NonNullList<Ingredient>)nonnulllist, (NonNullList<ItemStack>)stacks, (NonNullList<Float>)chances, (NonNullList<Float>)additional);
        }

        public CrushingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)1, (Object)Ingredient.field_193370_a);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            NonNullList stacks = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
            for (int k = 0; k < stacks.size(); ++k) {
                stacks.set(k, (Object)buffer.func_150791_c());
            }
            NonNullList chances = NonNullList.func_191197_a((int)6, (Object)Float.valueOf(0.0f));
            for (int k = 0; k < chances.size(); ++k) {
                chances.set(k, (Object)Float.valueOf(buffer.readFloat()));
            }
            NonNullList additional = NonNullList.func_191197_a((int)6, (Object)Float.valueOf(0.0f));
            for (int k = 0; k < additional.size(); ++k) {
                additional.set(k, (Object)Float.valueOf(buffer.readFloat()));
            }
            return new CrushingRecipe(recipeId, (NonNullList<Ingredient>)nonnulllist, (NonNullList<ItemStack>)stacks, (NonNullList<Float>)chances, (NonNullList<Float>)additional);
        }

        public void write(PacketBuffer buffer, CrushingRecipe recipe) {
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.func_199564_a(buffer);
            }
            int count = 0;
            for (ItemStack stack : recipe.recipeOutputs) {
                buffer.func_150788_a(stack);
                ++count;
            }
            while (count < 6) {
                buffer.func_150788_a(ItemStack.field_190927_a);
                ++count;
            }
            count = 0;
            Iterator iterator = recipe.chances.iterator();
            while (iterator.hasNext()) {
                float chance = ((Float)iterator.next()).floatValue();
                buffer.writeFloat(chance);
                ++count;
            }
            while (count < 6) {
                buffer.writeFloat(0.0f);
                ++count;
            }
            count = 0;
            iterator = recipe.additional.iterator();
            while (iterator.hasNext()) {
                float add = ((Float)iterator.next()).floatValue();
                buffer.writeFloat(add);
                ++count;
            }
            while (count < 6) {
                buffer.writeFloat(0.0f);
                ++count;
            }
        }
    }
}

