/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.recipe;

import com.cannolicatfish.rankine.init.RankineRecipeTypes;
import com.cannolicatfish.rankine.recipe.helper.AlloyIngredientHelper;
import com.cannolicatfish.rankine.recipe.helper.BlockRecipeHelper;
import com.cannolicatfish.rankine.util.WeightedCollection;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class EvaporationRecipe
implements IRecipe<IInventory> {
    private final int total;
    private final int time;
    private final FluidStack fluid;
    private final Ingredient bucket;
    private final List<String> biomes;
    private final NonNullList<ItemStack> recipeOutputs;
    private final ResourceLocation id;
    private final NonNullList<Float> weights;
    private final NonNullList<Integer> mins;
    private final NonNullList<Integer> maxes;
    private final boolean large;
    public static final Serializer SERIALIZER = new Serializer();

    public EvaporationRecipe(ResourceLocation idIn, boolean largeIn, int totalIn, int timeIn, FluidStack fluidIn, Ingredient bucketIn, List<String> biomesIn, NonNullList<ItemStack> recipeOutputsIn, NonNullList<Float> weightsIn, NonNullList<Integer> minsIn, NonNullList<Integer> maxesIn) {
        this.large = largeIn;
        this.total = totalIn;
        this.time = timeIn;
        this.id = idIn;
        this.fluid = fluidIn;
        this.bucket = bucketIn;
        this.biomes = biomesIn;
        this.recipeOutputs = recipeOutputsIn;
        this.weights = weightsIn;
        this.mins = minsIn;
        this.maxes = maxesIn;
    }

    public int getTime() {
        return this.time;
    }

    public String func_193358_e() {
        return "";
    }

    public boolean isLarge() {
        return this.large;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_191197_a((int)1, (Object)this.bucket);
    }

    public FluidStack getFluid() {
        return this.fluid.copy();
    }

    public List<String> getBiomes() {
        return this.biomes;
    }

    public NonNullList<ItemStack> getRecipeOutputs() {
        return this.recipeOutputs;
    }

    public NonNullList<Ingredient> getJEIIngredient() {
        return NonNullList.func_191197_a((int)1, (Object)this.bucket);
    }

    public List<Biome> getBiomeList() {
        ArrayList<Biome> biomeList = new ArrayList<Biome>();
        for (String s : this.getBiomes()) {
            if (s.contains("C#")) {
                for (Biome b : ForgeRegistries.BIOMES) {
                    if (!b.func_201856_r().func_176610_l().equalsIgnoreCase(s.split("C#")[1])) continue;
                    biomeList.add(b);
                }
                continue;
            }
            if (!s.contains("B#")) continue;
            for (Biome b : ForgeRegistries.BIOMES) {
                if (b.getRegistryName() == null || !b.getRegistryName().equals((Object)new ResourceLocation(s.split("C#")[1]))) continue;
                biomeList.add(b);
            }
        }
        return biomeList;
    }

    public List<String> getBiomeString() {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : this.getBiomes()) {
            if (s.contains("C#")) {
                for (Biome b : ForgeRegistries.BIOMES) {
                    if (!b.func_201856_r().func_176610_l().equalsIgnoreCase(s.split("C#")[1]) || list.contains(b.func_201856_r().func_176610_l().toUpperCase(Locale.ROOT).replace("_", " "))) continue;
                    list.add(b.func_201856_r().func_176610_l().toUpperCase(Locale.ROOT).replace("_", " "));
                }
                continue;
            }
            if (!s.contains("B#")) continue;
            for (Biome b : ForgeRegistries.BIOMES) {
                if (b.getRegistryName() == null || !b.getRegistryName().equals((Object)new ResourceLocation(s.split("C#")[1])) || list.contains(b.getRegistryName().func_110623_a().toUpperCase(Locale.ROOT).replace("_", " "))) continue;
                list.add(b.getRegistryName().func_110623_a().toUpperCase(Locale.ROOT).replace("_", " "));
            }
        }
        return list;
    }

    public Float getChance(int index) {
        float in = ((Float)this.getWeights().get(index)).floatValue();
        return Float.valueOf(in / this.getWeights().stream().reduce(Float.valueOf(0.0f), Float::sum).floatValue());
    }

    public NonNullList<Float> getWeights() {
        return this.weights;
    }

    public NonNullList<ItemStack> getOutputs() {
        return this.recipeOutputs;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return false;
    }

    public boolean fluidMatch(Fluid input) {
        return input.equals(this.fluid.getFluid());
    }

    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<Integer> getMaxes() {
        return this.maxes;
    }

    public ItemStack getEvaporationResult(World worldIn, ResourceLocation biome) {
        if (this.getBiomeList().isEmpty()) {
            WeightedCollection<ItemStack> col = new WeightedCollection<ItemStack>();
            for (int i = 0; i < this.recipeOutputs.size(); ++i) {
                col.add(((Float)this.weights.get(i)).floatValue(), new ItemStack((IItemProvider)((ItemStack)this.recipeOutputs.get(i)).func_77973_b(), ((Integer)this.maxes.get(i)).equals(this.mins.get(i)) ? (Integer)this.maxes.get(i) : worldIn.func_201674_k().nextInt((Integer)this.maxes.get(i) - (Integer)this.mins.get(i)) + (Integer)this.mins.get(i)));
            }
            return ((ItemStack)col.getRandomElement()).func_77946_l();
        }
        for (Biome b : this.getBiomeList()) {
            if (b.getRegistryName() == null || !b.getRegistryName().equals((Object)biome)) continue;
            WeightedCollection<ItemStack> col = new WeightedCollection<ItemStack>();
            for (int i = 0; i < this.recipeOutputs.size(); ++i) {
                col.add(((Float)this.weights.get(i)).floatValue(), new ItemStack((IItemProvider)((ItemStack)this.recipeOutputs.get(i)).func_77973_b(), ((Integer)this.maxes.get(i)).equals(this.mins.get(i)) ? (Integer)this.maxes.get(i) : worldIn.func_201674_k().nextInt((Integer)this.maxes.get(i) - (Integer)this.mins.get(i)) + (Integer)this.mins.get(i)));
            }
            return ((ItemStack)col.getRandomElement()).func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static ItemStack deserializeItem(JsonObject object) {
        String s = JSONUtils.func_151200_h((JsonObject)object, (String)"item");
        Item item = (Item)Registry.field_212630_s.func_241873_b(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
        return AlloyIngredientHelper.getItemStack(object, true);
    }

    public static FluidStack deserializeFluid(JsonObject object) {
        String s = JSONUtils.func_151200_h((JsonObject)object, (String)"block");
        Block block = (Block)Registry.field_212618_g.func_241873_b(new ResourceLocation(s)).orElseThrow(() -> new JsonParseException("Unknown block '" + s + "'"));
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        return BlockRecipeHelper.getBlockFluidStack(object);
    }

    public IRecipeType<?> func_222127_g() {
        return RankineRecipeTypes.EVAPORATION;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<EvaporationRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("rankine", "evaporation");

        public EvaporationRecipe read(ResourceLocation recipeId, JsonObject json) {
            int t = json.get("total").getAsInt();
            int w = json.has("cookTime") ? json.get("cookTime").getAsInt() : 6400;
            boolean l = !json.has("large") || json.get("large").getAsBoolean();
            FluidStack fluid = EvaporationRecipe.deserializeFluid(JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
            Ingredient bucket = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"bucket"));
            JsonArray b = json.has("biomes") ? JSONUtils.func_151214_t((JsonObject)json, (String)"biomes") : new JsonArray();
            ArrayList<String> biomes = new ArrayList<String>();
            for (int i = 0; i < b.size(); ++i) {
                biomes.add(b.get(i).getAsString());
            }
            NonNullList stacks = NonNullList.func_191197_a((int)t, (Object)ItemStack.field_190927_a);
            NonNullList weights = NonNullList.func_191197_a((int)t, (Object)Float.valueOf(0.0f));
            NonNullList mins = NonNullList.func_191197_a((int)t, (Object)1);
            NonNullList maxes = NonNullList.func_191197_a((int)t, (Object)1);
            for (int i = 0; i < t; ++i) {
                String output = "output" + (i + 1);
                if (!json.has(output)) continue;
                JsonObject object = JSONUtils.func_152754_s((JsonObject)json, (String)output);
                stacks.set(i, (Object)EvaporationRecipe.deserializeItem(object));
                if (object.has("weight")) {
                    weights.set(i, (Object)Float.valueOf(object.get("weight").getAsFloat()));
                } else {
                    weights.set(i, (Object)Float.valueOf(0.0f));
                }
                if (object.has("min")) {
                    mins.set(i, (Object)object.get("min").getAsInt());
                } else {
                    mins.set(i, (Object)1);
                }
                if (object.has("max")) {
                    maxes.set(i, (Object)object.get("max").getAsInt());
                    continue;
                }
                maxes.set(i, (Object)1);
            }
            return new EvaporationRecipe(recipeId, l, t, w, fluid, bucket, biomes, (NonNullList<ItemStack>)stacks, (NonNullList<Float>)weights, (NonNullList<Integer>)mins, (NonNullList<Integer>)maxes);
        }

        public EvaporationRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            boolean l = buffer.readBoolean();
            int t = buffer.readInt();
            int w = buffer.readInt();
            FluidStack input = buffer.readFluidStack();
            Ingredient b = Ingredient.func_199566_b((PacketBuffer)buffer);
            int biomesSize = buffer.readInt();
            String[] biomeArray = new String[biomesSize];
            for (int i = 0; i < biomesSize; ++i) {
                biomeArray[i] = buffer.func_218666_n();
            }
            List<String> biomes = Arrays.asList(biomeArray);
            NonNullList stacks = NonNullList.func_191197_a((int)t, (Object)ItemStack.field_190927_a);
            for (int k = 0; k < stacks.size(); ++k) {
                stacks.set(k, (Object)buffer.func_150791_c());
            }
            NonNullList weights = NonNullList.func_191197_a((int)t, (Object)Float.valueOf(0.0f));
            for (int k = 0; k < weights.size(); ++k) {
                weights.set(k, (Object)Float.valueOf(buffer.readFloat()));
            }
            NonNullList mins = NonNullList.func_191197_a((int)t, (Object)1);
            for (int k = 0; k < mins.size(); ++k) {
                mins.set(k, (Object)buffer.readInt());
            }
            NonNullList maxes = NonNullList.func_191197_a((int)t, (Object)1);
            for (int k = 0; k < maxes.size(); ++k) {
                maxes.set(k, (Object)buffer.readInt());
            }
            return new EvaporationRecipe(recipeId, l, t, w, input, b, biomes, (NonNullList<ItemStack>)stacks, (NonNullList<Float>)weights, (NonNullList<Integer>)mins, (NonNullList<Integer>)maxes);
        }

        public void write(PacketBuffer buffer, EvaporationRecipe recipe) {
            buffer.writeBoolean(recipe.isLarge());
            buffer.writeInt(recipe.total);
            buffer.writeInt(recipe.time);
            buffer.writeFluidStack(recipe.fluid);
            recipe.bucket.func_199564_a(buffer);
            buffer.writeInt(recipe.getBiomes().size());
            for (int i = 0; i < recipe.getBiomes().size(); ++i) {
                buffer.func_180714_a(recipe.getBiomes().get(i));
            }
            int count = 0;
            for (ItemStack stack : recipe.recipeOutputs) {
                buffer.func_150788_a(stack);
                ++count;
            }
            while (count < recipe.total) {
                buffer.func_150788_a(ItemStack.field_190927_a);
                ++count;
            }
            count = 0;
            Iterator iterator = recipe.weights.iterator();
            while (iterator.hasNext()) {
                float chance = ((Float)iterator.next()).floatValue();
                buffer.writeFloat(chance);
                ++count;
            }
            while (count < recipe.total) {
                buffer.writeFloat(0.0f);
                ++count;
            }
            count = 0;
            iterator = recipe.mins.iterator();
            while (iterator.hasNext()) {
                int add = (Integer)iterator.next();
                buffer.writeInt(add);
                ++count;
            }
            while (count < recipe.total) {
                buffer.writeInt(1);
                ++count;
            }
            count = 0;
            iterator = recipe.maxes.iterator();
            while (iterator.hasNext()) {
                int add = (Integer)iterator.next();
                buffer.writeInt(add);
                ++count;
            }
            while (count < recipe.total) {
                buffer.writeInt(1);
                ++count;
            }
        }
    }
}

