/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.recipe;

import com.cannolicatfish.rankine.init.RankineRecipeTypes;
import com.cannolicatfish.rankine.recipe.helper.AlloyIngredientHelper;
import com.cannolicatfish.rankine.util.WeightedCollection;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Iterator;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SluicingRecipe
implements IRecipe<IInventory> {
    private final int total;
    private final Ingredient ingredient;
    private final NonNullList<ItemStack> recipeOutputs;
    private final ResourceLocation id;
    private final NonNullList<Float> weights;
    private final NonNullList<Integer> mins;
    private final NonNullList<Integer> maxes;
    public static final Serializer SERIALIZER = new Serializer();

    public SluicingRecipe(ResourceLocation idIn, int totalIn, Ingredient ingredientIn, NonNullList<ItemStack> recipeOutputsIn, NonNullList<Float> weightsIn, NonNullList<Integer> minsIn, NonNullList<Integer> maxesIn) {
        this.total = totalIn;
        this.id = idIn;
        this.ingredient = ingredientIn;
        this.recipeOutputs = recipeOutputsIn;
        this.weights = weightsIn;
        this.mins = minsIn;
        this.maxes = maxesIn;
    }

    public String func_193358_e() {
        return "";
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_191197_a((int)1, (Object)this.ingredient);
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public Float getChance(int index) {
        float in = ((Float)this.getWeights().get(index)).floatValue();
        return Float.valueOf(in / this.getWeights().stream().reduce(Float.valueOf(0.0f), Float::sum).floatValue());
    }

    public NonNullList<Float> getWeights() {
        return this.weights;
    }

    public NonNullList<ItemStack> getOutputs() {
        return this.recipeOutputs;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.getIngredient().test(inv.func_70301_a(0));
    }

    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ItemStack getSluicingResult(World worldIn) {
        WeightedCollection<ItemStack> col = new WeightedCollection<ItemStack>();
        for (int i = 0; i < this.recipeOutputs.size(); ++i) {
            col.add(((Float)this.weights.get(i)).floatValue(), new ItemStack((IItemProvider)((ItemStack)this.recipeOutputs.get(i)).func_77973_b(), ((Integer)this.maxes.get(i)).equals(this.mins.get(i)) ? (Integer)this.maxes.get(i) : worldIn.func_201674_k().nextInt((Integer)this.maxes.get(i) - (Integer)this.mins.get(i)) + (Integer)this.mins.get(i)));
        }
        return ((ItemStack)col.getRandomElement()).func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static ItemStack deserializeItem(JsonObject object) {
        String s = JSONUtils.func_151200_h((JsonObject)object, (String)"item");
        Item item = (Item)Registry.field_212630_s.func_241873_b(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
        return AlloyIngredientHelper.getItemStack(object, true);
    }

    public IRecipeType<?> func_222127_g() {
        return RankineRecipeTypes.SLUICING;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SluicingRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("rankine", "sluicing");

        public SluicingRecipe read(ResourceLocation recipeId, JsonObject json) {
            int t = json.get("total").getAsInt();
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
            NonNullList stacks = NonNullList.func_191197_a((int)t, (Object)ItemStack.field_190927_a);
            NonNullList weights = NonNullList.func_191197_a((int)t, (Object)Float.valueOf(0.0f));
            NonNullList mins = NonNullList.func_191197_a((int)t, (Object)1);
            NonNullList maxes = NonNullList.func_191197_a((int)t, (Object)1);
            for (int i = 0; i < t; ++i) {
                String output = "output" + (i + 1);
                if (!json.has(output)) continue;
                JsonObject object = JSONUtils.func_152754_s((JsonObject)json, (String)output);
                stacks.set(i, (Object)SluicingRecipe.deserializeItem(object));
                if (object.has("weight")) {
                    weights.set(i, (Object)Float.valueOf(object.get("weight").getAsFloat()));
                } else {
                    weights.set(i, (Object)Float.valueOf(0.0f));
                }
                if (object.has("min")) {
                    mins.set(i, (Object)object.get("min").getAsInt());
                } else {
                    mins.set(i, (Object)1);
                }
                if (object.has("max")) {
                    maxes.set(i, (Object)object.get("max").getAsInt());
                    continue;
                }
                maxes.set(i, (Object)1);
            }
            return new SluicingRecipe(recipeId, t, ingredient, (NonNullList<ItemStack>)stacks, (NonNullList<Float>)weights, (NonNullList<Integer>)mins, (NonNullList<Integer>)maxes);
        }

        public SluicingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int t = buffer.readInt();
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            NonNullList stacks = NonNullList.func_191197_a((int)t, (Object)ItemStack.field_190927_a);
            for (int k = 0; k < stacks.size(); ++k) {
                stacks.set(k, (Object)buffer.func_150791_c());
            }
            NonNullList weights = NonNullList.func_191197_a((int)t, (Object)Float.valueOf(0.0f));
            for (int k = 0; k < weights.size(); ++k) {
                weights.set(k, (Object)Float.valueOf(buffer.readFloat()));
            }
            NonNullList mins = NonNullList.func_191197_a((int)t, (Object)1);
            for (int k = 0; k < mins.size(); ++k) {
                mins.set(k, (Object)buffer.readInt());
            }
            NonNullList maxes = NonNullList.func_191197_a((int)t, (Object)1);
            for (int k = 0; k < maxes.size(); ++k) {
                maxes.set(k, (Object)buffer.readInt());
            }
            return new SluicingRecipe(recipeId, t, input, (NonNullList<ItemStack>)stacks, (NonNullList<Float>)weights, (NonNullList<Integer>)mins, (NonNullList<Integer>)maxes);
        }

        public void write(PacketBuffer buffer, SluicingRecipe recipe) {
            buffer.writeInt(recipe.total);
            recipe.getIngredient().func_199564_a(buffer);
            int count = 0;
            for (ItemStack stack : recipe.recipeOutputs) {
                buffer.func_150788_a(stack);
                ++count;
            }
            while (count < recipe.total) {
                buffer.func_150788_a(ItemStack.field_190927_a);
                ++count;
            }
            count = 0;
            Iterator iterator = recipe.weights.iterator();
            while (iterator.hasNext()) {
                float chance = ((Float)iterator.next()).floatValue();
                buffer.writeFloat(chance);
                ++count;
            }
            while (count < recipe.total) {
                buffer.writeFloat(0.0f);
                ++count;
            }
            count = 0;
            iterator = recipe.mins.iterator();
            while (iterator.hasNext()) {
                int add = (Integer)iterator.next();
                buffer.writeInt(add);
                ++count;
            }
            while (count < recipe.total) {
                buffer.writeInt(1);
                ++count;
            }
            count = 0;
            iterator = recipe.maxes.iterator();
            while (iterator.hasNext()) {
                int add = (Integer)iterator.next();
                buffer.writeInt(add);
                ++count;
            }
            while (count < recipe.total) {
                buffer.writeInt(1);
                ++count;
            }
        }
    }
}

