/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.recipe.helper;

import com.cannolicatfish.rankine.items.alloys.AlloyItem;
import com.cannolicatfish.rankine.util.PeriodicTableUtils;
import java.awt.Color;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;

public class AlloyColorHelper {
    public int getColor(ItemStack stack, int tintIndex) {
        PeriodicTableUtils utils = PeriodicTableUtils.getInstance();
        INBT nbt = AlloyItem.getComposition(stack).func_150305_b(0).func_74781_a("comp");
        if (nbt != null) {
            boolean weighted = true;
            ArrayList<AbstractMap.SimpleEntry<PeriodicTableUtils.Element, Integer>> elements = new ArrayList<AbstractMap.SimpleEntry<PeriodicTableUtils.Element, Integer>>();
            if (nbt.func_150285_a_().contains("-")) {
                String[] split;
                for (String s : split = nbt.func_150285_a_().split("-")) {
                    if (s.replaceAll("[A-Za-z]+", "").matches("-?\\d+")) {
                        elements.add(new AbstractMap.SimpleEntry<PeriodicTableUtils.Element, Integer>(utils.getElementBySymbol(s.replaceAll("[^A-Za-z]+", "")), Integer.parseInt(s.replaceAll("[A-Za-z]+", ""))));
                        continue;
                    }
                    elements.add(new AbstractMap.SimpleEntry<PeriodicTableUtils.Element, Object>(utils.getElementBySymbol(s.replaceAll("[^A-Za-z]+", "")), null));
                    weighted = false;
                }
            } else {
                String s = nbt.func_150285_a_();
                if (s.replaceAll("[A-Za-z]+", "").matches("-?\\d+")) {
                    elements.add(new AbstractMap.SimpleEntry<PeriodicTableUtils.Element, Integer>(utils.getElementBySymbol(s.replaceAll("[^A-Za-z]+", "")), Integer.parseInt(s.replaceAll("[A-Za-z]+", ""))));
                } else {
                    elements.add(new AbstractMap.SimpleEntry<PeriodicTableUtils.Element, Object>(utils.getElementBySymbol(s.replaceAll("[^A-Za-z]+", "")), null));
                    weighted = false;
                }
            }
            int color = elements.size() >= 2 ? (weighted ? this.returnBlendWeighted(elements) : this.returnBlend(elements)) : (elements.size() == 1 ? ((PeriodicTableUtils.Element)((Object)((AbstractMap.SimpleEntry)elements.get(0)).getKey())).getColor() : 0xFFFFFF);
            return color;
        }
        return 0xFFFFFF;
    }

    private int returnBlend(List<AbstractMap.SimpleEntry<PeriodicTableUtils.Element, Integer>> elements) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        for (AbstractMap.SimpleEntry<PeriodicTableUtils.Element, Integer> e : elements) {
            Color col = new Color(e.getKey().getColor());
            r += (float)col.getRed();
            g += (float)col.getGreen();
            b += (float)col.getBlue();
        }
        int rgb = Math.round(r / (float)elements.size());
        rgb = (rgb << 8) + Math.round(g / (float)elements.size());
        rgb = (rgb << 8) + Math.round(b / (float)elements.size());
        return rgb;
    }

    private int returnBlendWeighted(List<AbstractMap.SimpleEntry<PeriodicTableUtils.Element, Integer>> elements) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        for (AbstractMap.SimpleEntry<PeriodicTableUtils.Element, Integer> e : elements) {
            Color col = new Color(e.getKey().getColor());
            r += (float)(col.getRed() * e.getValue()) / 100.0f;
            g += (float)(col.getGreen() * e.getValue()) / 100.0f;
            b += (float)(col.getBlue() * e.getValue()) / 100.0f;
        }
        int rgb = Math.round(r);
        rgb = (rgb << 8) + Math.round(g);
        rgb = (rgb << 8) + Math.round(b);
        return rgb;
    }
}

