/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.recipe.helper;

import com.cannolicatfish.rankine.items.alloys.AlloyData;
import com.cannolicatfish.rankine.items.alloys.AlloyItem;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class AlloyIngredientHelper {
    public static Ingredient deserialize(@Nullable JsonElement json, @Nullable String alloyData) {
        if (json != null && !json.isJsonNull()) {
            Ingredient ret = CraftingHelper.getIngredient((JsonElement)json);
            if (alloyData != null) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (ItemStack s : ret.func_193365_a()) {
                    AlloyItem.addAlloy(s, new AlloyData(alloyData));
                    stacks.add(s);
                }
                ret = Ingredient.func_193369_a((ItemStack[])stacks.toArray(new ItemStack[0]));
            }
            if (ret != null) {
                return ret;
            }
            if (json.isJsonObject()) {
                return Ingredient.func_209357_a(Stream.of(AlloyIngredientHelper.deserializeItemList(json.getAsJsonObject())));
            }
            if (json.isJsonArray()) {
                JsonArray jsonarray = json.getAsJsonArray();
                if (jsonarray.size() == 0) {
                    throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
                }
                return Ingredient.func_209357_a(StreamSupport.stream(jsonarray.spliterator(), false).map(element -> AlloyIngredientHelper.deserializeItemList(JSONUtils.func_151210_l((JsonElement)element, (String)"item"))));
            }
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }
        throw new JsonSyntaxException("Item cannot be null");
    }

    public static Ingredient.IItemList deserializeItemList(JsonObject json) {
        if (json.has("item") && json.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (json.has("item")) {
            ResourceLocation resourcelocation1 = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"item"));
            Item item = (Item)Registry.field_212630_s.func_241873_b(resourcelocation1).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + resourcelocation1 + "'"));
            ItemStack ret = new ItemStack((IItemProvider)item);
            if (json.has("alloyData")) {
                System.out.println("AlloyData detected in recipe!: " + JSONUtils.func_151200_h((JsonObject)json, (String)"alloyData"));
                AlloyItem.addAlloy(ret, new AlloyData(JSONUtils.func_151200_h((JsonObject)json, (String)"alloyData")));
            }
            return new Ingredient.SingleItemList(ret);
        }
        if (json.has("tag")) {
            ResourceLocation resourcelocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag"));
            ITag itag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(resourcelocation);
            if (itag == null) {
                throw new JsonSyntaxException("Unknown item tag '" + resourcelocation + "'");
            }
            return new Ingredient.TagList(itag);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }

    public static ItemStack getItemStack(JsonObject json, boolean readNBT) {
        return AlloyIngredientHelper.getItemStack(json, readNBT, true);
    }

    public static ItemStack getItemStack(JsonObject json, boolean readNBT, boolean includeCount) {
        String itemName = JSONUtils.func_151200_h((JsonObject)json, (String)"item");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item == null) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        }
        if (readNBT && json.has("nbt")) {
            try {
                JsonElement element = json.get("nbt");
                CompoundNBT nbt = element.isJsonObject() ? JsonToNBT.func_180713_a((String)new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson(element)) : JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)element, (String)"nbt"));
                CompoundNBT tmp = new CompoundNBT();
                if (nbt.func_74764_b("ForgeCaps")) {
                    tmp.func_218657_a("ForgeCaps", nbt.func_74781_a("ForgeCaps"));
                    nbt.func_82580_o("ForgeCaps");
                }
                tmp.func_218657_a("tag", (INBT)nbt);
                tmp.func_74778_a("id", itemName);
                if (includeCount) {
                    tmp.func_74768_a("Count", JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)1));
                } else {
                    tmp.func_74768_a("Count", 1);
                }
                return ItemStack.func_199557_a((CompoundNBT)tmp);
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
            }
        }
        ItemStack ret = new ItemStack((IItemProvider)item, JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)1));
        if (json.has("alloyData")) {
            AlloyItem.addAlloy(ret, new AlloyData(JSONUtils.func_151200_h((JsonObject)json, (String)"alloyData")));
        }
        return ret;
    }
}

