/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.recipe.helper;

import com.cannolicatfish.rankine.init.RankineRecipeTypes;
import com.cannolicatfish.rankine.recipe.AlloyingRecipe;
import com.cannolicatfish.rankine.util.PeriodicTableUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class AlloyRecipeHelper {
    private static final PeriodicTableUtils utils = PeriodicTableUtils.getInstance();

    public static int returnMaterialCountFromStack(ItemStack stack) {
        Item item = stack.func_77973_b();
        ResourceLocation reg = item.getRegistryName();
        String registry = "";
        if (reg != null) {
            registry = reg.func_110623_a();
        }
        if (stack.func_77973_b().getTags().contains(new ResourceLocation("forge:storage_blocks")) || stack.func_77973_b() instanceof BlockItem || registry.contains("block")) {
            return 81 * stack.func_190916_E();
        }
        if (stack.func_77973_b().getTags().contains(new ResourceLocation("forge:ingots")) || registry.contains("ingot")) {
            return 9 * stack.func_190916_E();
        }
        if (stack.func_77973_b().getTags().contains(new ResourceLocation("forge:nuggets")) || registry.contains("nugget")) {
            return stack.func_190916_E();
        }
        if (stack.func_77973_b() == Items.field_234760_kn_ || registry.contains("scrap")) {
            return 2 * stack.func_190916_E();
        }
        return 9 * stack.func_190916_E();
    }

    public static String getDirectComposition(List<Integer> percents, List<String> inputs) {
        StringBuilder ret = new StringBuilder();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < inputs.size(); ++i) {
            map.put(inputs.get(i), percents.get(i));
        }
        ArrayList<Integer> sPercents = new ArrayList<Integer>();
        ArrayList<String> sInputs = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : AlloyRecipeHelper.mapStringsSort(map).entrySet()) {
            if (entry.getValue() <= 0) continue;
            sPercents.add(entry.getValue());
            sInputs.add(entry.getKey());
        }
        Collections.reverse(sPercents);
        Collections.reverse(sInputs);
        for (int i = 0; i < sPercents.size(); ++i) {
            ret.append(sPercents.get(i)).append((String)sInputs.get(i));
            if (i == sPercents.size() - 1) continue;
            ret.append("-");
        }
        return ret.toString();
    }

    public static Map<String, Integer> mapStringsSort(Map<String, Integer> map) {
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(map.entrySet());
        list.sort((o1, o2) -> {
            if (((Integer)o1.getValue()).equals(o2.getValue())) {
                return ((String)o2.getKey()).compareToIgnoreCase((String)o1.getKey());
            }
            return (Integer)o1.getValue() < (Integer)o2.getValue() ? -1 : 1;
        });
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : list) {
            result.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return result;
    }

    public static String getAlloyFromComposition(String comp, World worldIn) {
        ArrayList<PeriodicTableUtils.Element> elements = new ArrayList<PeriodicTableUtils.Element>();
        ArrayList<Integer> percents = new ArrayList<Integer>();
        for (String s : comp.split("-")) {
            String str = s.replaceAll("[^A-Za-z]+", "");
            int num = Integer.parseInt(s.replaceAll("[A-Za-z]+", ""));
            elements.add(utils.getElementBySymbol(str));
            percents.add(num);
        }
        for (AlloyingRecipe recipe : worldIn.func_199532_z().func_241447_a_(RankineRecipeTypes.ALLOYING)) {
            int perc;
            int elemindex;
            int recindex;
            boolean flag = true;
            List<PeriodicTableUtils.Element> req = recipe.getElementList(true);
            NonNullList<PeriodicTableUtils.Element> all = recipe.getElements();
            NonNullList<Float> mins = recipe.getMins();
            NonNullList<Float> maxes = recipe.getMaxes();
            for (PeriodicTableUtils.Element e : req) {
                if (!elements.contains((Object)e)) {
                    flag = false;
                    break;
                }
                recindex = all.indexOf((Object)e);
                elemindex = elements.indexOf((Object)e);
                perc = (Integer)percents.get(elemindex);
                if (Math.round(((Float)mins.get(recindex)).floatValue() * 100.0f) <= perc && Math.round(((Float)maxes.get(recindex)).floatValue() * 100.0f) >= perc) continue;
                flag = false;
                break;
            }
            if (flag) {
                for (PeriodicTableUtils.Element el : elements) {
                    if (!all.contains((Object)el)) {
                        flag = false;
                        break;
                    }
                    recindex = all.indexOf((Object)el);
                    elemindex = elements.indexOf((Object)el);
                    perc = (Integer)percents.get(elemindex);
                    if (Math.round(((Float)mins.get(recindex)).floatValue() * 100.0f) <= perc && Math.round(((Float)maxes.get(recindex)).floatValue() * 100.0f) >= perc) continue;
                    flag = false;
                    break;
                }
            }
            if (!flag) continue;
            String name = new TranslationTextComponent(recipe.func_77571_b().func_77977_a()).getString();
            if (name.contains(" Ingot")) {
                name = name.split(" Ingot")[0];
            }
            if (name.contains(" Alloy") && !name.contains("Heavy Alloy")) {
                name = name.split(" Alloy")[0];
            }
            return name;
        }
        if (elements.size() >= 3) {
            return ((PeriodicTableUtils.Element)((Object)elements.get(0))).name().charAt(0) + ((PeriodicTableUtils.Element)((Object)elements.get(0))).name().substring(1).toLowerCase() + " Alloy";
        }
        if (elements.size() == 2) {
            return ((PeriodicTableUtils.Element)((Object)elements.get(0))).name().charAt(0) + ((PeriodicTableUtils.Element)((Object)elements.get(0))).name().substring(1).toLowerCase() + "-" + ((PeriodicTableUtils.Element)((Object)elements.get(1))).name().charAt(0) + ((PeriodicTableUtils.Element)((Object)elements.get(1))).name().substring(1).toLowerCase() + " Alloy";
        }
        if (elements.size() == 1) {
            return ((PeriodicTableUtils.Element)((Object)elements.get(0))).name().charAt(0) + ((PeriodicTableUtils.Element)((Object)elements.get(0))).name().substring(1).toLowerCase();
        }
        return "false";
    }
}

