/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.recipe.helper;

import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;

public class FluidHelper {
    private static final UUID SLOW_FALLING_ID = UUID.fromString("A5B6CF2A-2F7C-31EF-9022-7C3E7D5E6ABA");
    private static final AttributeModifier SLOW_FALLING = new AttributeModifier(SLOW_FALLING_ID, "Slow falling acceleration reduction", -0.07, AttributeModifier.Operation.ADDITION);

    public static Vector3d handleFluidAcceleration(Entity ent, double motionScale) {
        int j1;
        AxisAlignedBB axisalignedbb = ent.func_174813_aQ().func_186664_h(0.001);
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)axisalignedbb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        if (!ent.field_70170_p.func_217344_a(i, k, i1, j, l, j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f))) {
            return Vector3d.field_186680_a;
        }
        double d0 = 0.0;
        boolean flag = ent.func_96092_aw();
        boolean flag1 = false;
        Vector3d vector3d = Vector3d.field_186680_a;
        int k1 = 0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = k; i2 < l; ++i2) {
                for (int j2 = i1; j2 < j1; ++j2) {
                    blockpos$mutable.func_181079_c(l1, i2, j2);
                    FluidState fluidstate = ent.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    double d1 = (float)i2 + fluidstate.func_215679_a((IBlockReader)ent.field_70170_p, (BlockPos)blockpos$mutable);
                    if (!(d1 >= axisalignedbb.field_72338_b)) continue;
                    flag1 = true;
                    d0 = Math.max(d1 - axisalignedbb.field_72338_b, d0);
                    if (!flag) continue;
                    Vector3d vector3d1 = fluidstate.func_215673_c((IBlockReader)ent.field_70170_p, (BlockPos)blockpos$mutable);
                    if (d0 < 0.4) {
                        vector3d1 = vector3d1.func_186678_a(d0);
                    }
                    vector3d = vector3d.func_178787_e(vector3d1);
                    ++k1;
                }
            }
        }
        if (vector3d.func_72433_c() > 0.0) {
            if (k1 > 0) {
                vector3d = vector3d.func_186678_a(1.0 / (double)k1);
            }
            if (!(ent instanceof PlayerEntity)) {
                vector3d = vector3d.func_72432_b();
            }
            Vector3d vector3d2 = ent.func_213322_ci();
            vector3d = vector3d.func_186678_a(motionScale);
            double d2 = 0.003;
            if (Math.abs(vector3d2.field_72450_a) < 0.003 && Math.abs(vector3d2.field_72449_c) < 0.003 && vector3d.func_72433_c() < 0.0045000000000000005) {
                vector3d = vector3d.func_72432_b().func_186678_a(0.0045000000000000005);
            }
            ent.func_213317_d(ent.func_213322_ci().func_178787_e(vector3d));
        }
        return vector3d;
    }

    public static void travel(Vector3d travelVector, LivingEntity ent, boolean inLiquid) {
        if (ent.func_70613_aW() || ent.func_184186_bw()) {
            boolean flag;
            double d0 = 0.08;
            ModifiableAttributeInstance gravity = ent.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            boolean bl = flag = ent.func_213322_ci().field_72448_b <= 0.0;
            if (flag && ent.func_70644_a(Effects.field_204839_B)) {
                if (!gravity.func_180374_a(SLOW_FALLING)) {
                    gravity.func_233767_b_(SLOW_FALLING);
                }
                ent.field_70143_R = 0.0f;
            } else if (gravity.func_180374_a(SLOW_FALLING)) {
                gravity.func_111124_b(SLOW_FALLING);
            }
            d0 = gravity.func_111126_e();
            FluidState fluidstate = ent.field_70170_p.func_204610_c(ent.func_233580_cy_());
            if (inLiquid && !ent.func_230285_a_(fluidstate.func_206886_c())) {
                double d7 = ent.func_226278_cu_();
                ent.func_213309_a(0.02f, travelVector);
                ent.func_213315_a(MoverType.SELF, ent.func_213322_ci());
                if (ent.func_233571_b_((ITag)FluidTags.field_206960_b) <= ent.func_233579_cu_()) {
                    ent.func_213317_d(ent.func_213322_ci().func_216372_d(0.5, (double)0.8f, 0.5));
                    Vector3d vector3d3 = ent.func_233626_a_(d0, flag, ent.func_213322_ci());
                    ent.func_213317_d(vector3d3);
                } else {
                    ent.func_213317_d(ent.func_213322_ci().func_186678_a(0.5));
                }
                if (!ent.func_189652_ae()) {
                    ent.func_213317_d(ent.func_213322_ci().func_72441_c(0.0, -d0 / 4.0, 0.0));
                }
                Vector3d vector3d4 = ent.func_213322_ci();
                if (ent.field_70123_F && ent.func_70038_c(vector3d4.field_72450_a, vector3d4.field_72448_b + (double)0.6f - ent.func_226278_cu_() + d7, vector3d4.field_72449_c)) {
                    ent.func_213293_j(vector3d4.field_72450_a, (double)0.3f, vector3d4.field_72449_c);
                }
            }
        }
        ent.func_233629_a_(ent, ent instanceof IFlyingAnimal);
    }

    public static double horizontalMag(Vector3d vec) {
        return vec.field_72450_a * vec.field_72450_a + vec.field_72449_c * vec.field_72449_c;
    }

    protected static BlockPos getPositionUnderneath(Entity ent) {
        return new BlockPos(ent.func_213303_ch().field_72450_a, ent.func_174813_aQ().field_72338_b - 0.5000001, ent.func_213303_ch().field_72449_c);
    }

    protected static void setFlag(Entity ent, int flag, boolean set) {
        DataParameter FLAGS = EntityDataManager.func_187226_a(Entity.class, (IDataSerializer)DataSerializers.field_187191_a);
        byte b0 = (Byte)ent.func_184212_Q().func_187225_a(FLAGS);
        if (set) {
            ent.func_184212_Q().func_187227_b(FLAGS, (Object)((byte)(b0 | 1 << flag)));
        } else {
            ent.func_184212_Q().func_187227_b(FLAGS, (Object)((byte)(b0 & ~(1 << flag))));
        }
    }

    public static int decreaseAirSupply(LivingEntity ent, World world, int air, int amount) {
        int i = EnchantmentHelper.func_185292_c((LivingEntity)ent);
        return i > 0 && world.func_201674_k().nextInt(i + 1) > 0 ? air : air - amount;
    }
}

