/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.util;

import com.cannolicatfish.rankine.init.Config;
import com.cannolicatfish.rankine.util.elements.ActiniumElement;
import com.cannolicatfish.rankine.util.elements.AluminumElement;
import com.cannolicatfish.rankine.util.elements.AmericiumElement;
import com.cannolicatfish.rankine.util.elements.AntimonyElement;
import com.cannolicatfish.rankine.util.elements.ArgonElement;
import com.cannolicatfish.rankine.util.elements.ArsenicElement;
import com.cannolicatfish.rankine.util.elements.AstatineElement;
import com.cannolicatfish.rankine.util.elements.BariumElement;
import com.cannolicatfish.rankine.util.elements.BerkeliumElement;
import com.cannolicatfish.rankine.util.elements.BerylliumElement;
import com.cannolicatfish.rankine.util.elements.BismuthElement;
import com.cannolicatfish.rankine.util.elements.BohriumElement;
import com.cannolicatfish.rankine.util.elements.BoronElement;
import com.cannolicatfish.rankine.util.elements.BromineElement;
import com.cannolicatfish.rankine.util.elements.CadmiumElement;
import com.cannolicatfish.rankine.util.elements.CalciumElement;
import com.cannolicatfish.rankine.util.elements.CaliforniumElement;
import com.cannolicatfish.rankine.util.elements.CarbonElement;
import com.cannolicatfish.rankine.util.elements.CeriumElement;
import com.cannolicatfish.rankine.util.elements.CesiumElement;
import com.cannolicatfish.rankine.util.elements.ChlorineElement;
import com.cannolicatfish.rankine.util.elements.ChromiumElement;
import com.cannolicatfish.rankine.util.elements.CobaltElement;
import com.cannolicatfish.rankine.util.elements.CoperniciumElement;
import com.cannolicatfish.rankine.util.elements.CopperElement;
import com.cannolicatfish.rankine.util.elements.CuriumElement;
import com.cannolicatfish.rankine.util.elements.DarmstadtiumElement;
import com.cannolicatfish.rankine.util.elements.DracocaeliElement;
import com.cannolicatfish.rankine.util.elements.DubniumElement;
import com.cannolicatfish.rankine.util.elements.DysprosiumElement;
import com.cannolicatfish.rankine.util.elements.EinsteiniumElement;
import com.cannolicatfish.rankine.util.elements.ElementInterface;
import com.cannolicatfish.rankine.util.elements.EnditeElement;
import com.cannolicatfish.rankine.util.elements.ErbiumElement;
import com.cannolicatfish.rankine.util.elements.EuropiumElement;
import com.cannolicatfish.rankine.util.elements.FermiumElement;
import com.cannolicatfish.rankine.util.elements.FleroviumElement;
import com.cannolicatfish.rankine.util.elements.FluorineElement;
import com.cannolicatfish.rankine.util.elements.FranciumElement;
import com.cannolicatfish.rankine.util.elements.GadoliniumElement;
import com.cannolicatfish.rankine.util.elements.GalliumElement;
import com.cannolicatfish.rankine.util.elements.GermaniumElement;
import com.cannolicatfish.rankine.util.elements.GhastiumElement;
import com.cannolicatfish.rankine.util.elements.GoldElement;
import com.cannolicatfish.rankine.util.elements.HafniumElement;
import com.cannolicatfish.rankine.util.elements.HassiumElement;
import com.cannolicatfish.rankine.util.elements.HeliumElement;
import com.cannolicatfish.rankine.util.elements.HolmiumElement;
import com.cannolicatfish.rankine.util.elements.HydrogenElement;
import com.cannolicatfish.rankine.util.elements.IndiumElement;
import com.cannolicatfish.rankine.util.elements.IodineElement;
import com.cannolicatfish.rankine.util.elements.IridiumElement;
import com.cannolicatfish.rankine.util.elements.IronElement;
import com.cannolicatfish.rankine.util.elements.KryptonElement;
import com.cannolicatfish.rankine.util.elements.LanthanumElement;
import com.cannolicatfish.rankine.util.elements.LawrenciumElement;
import com.cannolicatfish.rankine.util.elements.LeadElement;
import com.cannolicatfish.rankine.util.elements.LithiumElement;
import com.cannolicatfish.rankine.util.elements.LivermoriumElement;
import com.cannolicatfish.rankine.util.elements.LutetiumElement;
import com.cannolicatfish.rankine.util.elements.MagnesiumElement;
import com.cannolicatfish.rankine.util.elements.ManaElement;
import com.cannolicatfish.rankine.util.elements.ManganeseElement;
import com.cannolicatfish.rankine.util.elements.MeitneriumElement;
import com.cannolicatfish.rankine.util.elements.MendeleviumElement;
import com.cannolicatfish.rankine.util.elements.MercuryElement;
import com.cannolicatfish.rankine.util.elements.MolybdenumElement;
import com.cannolicatfish.rankine.util.elements.MoscoviumElement;
import com.cannolicatfish.rankine.util.elements.NeodymiumElement;
import com.cannolicatfish.rankine.util.elements.NeonElement;
import com.cannolicatfish.rankine.util.elements.NeptuniumElement;
import com.cannolicatfish.rankine.util.elements.NetheriteElement;
import com.cannolicatfish.rankine.util.elements.NickelElement;
import com.cannolicatfish.rankine.util.elements.NihoniumElement;
import com.cannolicatfish.rankine.util.elements.NiobiumElement;
import com.cannolicatfish.rankine.util.elements.NitrogenElement;
import com.cannolicatfish.rankine.util.elements.NobeliumElement;
import com.cannolicatfish.rankine.util.elements.NoneElement;
import com.cannolicatfish.rankine.util.elements.OganessonElement;
import com.cannolicatfish.rankine.util.elements.OsmiumElement;
import com.cannolicatfish.rankine.util.elements.OxygenElement;
import com.cannolicatfish.rankine.util.elements.PalladiumElement;
import com.cannolicatfish.rankine.util.elements.PhlogistonElement;
import com.cannolicatfish.rankine.util.elements.PhosphorusElement;
import com.cannolicatfish.rankine.util.elements.PlatinumElement;
import com.cannolicatfish.rankine.util.elements.PlutoniumElement;
import com.cannolicatfish.rankine.util.elements.PoloniumElement;
import com.cannolicatfish.rankine.util.elements.PotassiumElement;
import com.cannolicatfish.rankine.util.elements.PraseodymiumElement;
import com.cannolicatfish.rankine.util.elements.PrismarineElement;
import com.cannolicatfish.rankine.util.elements.PromethiumElement;
import com.cannolicatfish.rankine.util.elements.ProtactiniumElement;
import com.cannolicatfish.rankine.util.elements.RadiumElement;
import com.cannolicatfish.rankine.util.elements.RadonElement;
import com.cannolicatfish.rankine.util.elements.RheniumElement;
import com.cannolicatfish.rankine.util.elements.RhodiumElement;
import com.cannolicatfish.rankine.util.elements.RoentgeniumElement;
import com.cannolicatfish.rankine.util.elements.RubidiumElement;
import com.cannolicatfish.rankine.util.elements.RutheniumElement;
import com.cannolicatfish.rankine.util.elements.RutherfordiumElement;
import com.cannolicatfish.rankine.util.elements.SamariumElement;
import com.cannolicatfish.rankine.util.elements.ScandiumElement;
import com.cannolicatfish.rankine.util.elements.SeaborgiumElement;
import com.cannolicatfish.rankine.util.elements.SeleniumElement;
import com.cannolicatfish.rankine.util.elements.SiliconElement;
import com.cannolicatfish.rankine.util.elements.SilverElement;
import com.cannolicatfish.rankine.util.elements.SlimeElement;
import com.cannolicatfish.rankine.util.elements.SodiumElement;
import com.cannolicatfish.rankine.util.elements.StrontiumElement;
import com.cannolicatfish.rankine.util.elements.SulfurElement;
import com.cannolicatfish.rankine.util.elements.TantalumElement;
import com.cannolicatfish.rankine.util.elements.TechnetiumElement;
import com.cannolicatfish.rankine.util.elements.TelluriumElement;
import com.cannolicatfish.rankine.util.elements.TennessineElement;
import com.cannolicatfish.rankine.util.elements.TerbiumElement;
import com.cannolicatfish.rankine.util.elements.ThalliumElement;
import com.cannolicatfish.rankine.util.elements.ThoriumElement;
import com.cannolicatfish.rankine.util.elements.ThuliumElement;
import com.cannolicatfish.rankine.util.elements.TinElement;
import com.cannolicatfish.rankine.util.elements.TitaniumElement;
import com.cannolicatfish.rankine.util.elements.TungstenElement;
import com.cannolicatfish.rankine.util.elements.UraniumElement;
import com.cannolicatfish.rankine.util.elements.VanadiumElement;
import com.cannolicatfish.rankine.util.elements.WitherElement;
import com.cannolicatfish.rankine.util.elements.XenonElement;
import com.cannolicatfish.rankine.util.elements.YtterbiumElement;
import com.cannolicatfish.rankine.util.elements.YttriumElement;
import com.cannolicatfish.rankine.util.elements.ZincElement;
import com.cannolicatfish.rankine.util.elements.ZirconiumElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public final class PeriodicTableUtils {
    private static final PeriodicTableUtils INSTANCE = new PeriodicTableUtils();
    public final List<String> names = Arrays.asList("None", "Hydrogen", "Helium", "Lithium", "Beryllium", "Boron", "Carbon", "Nitrogen", "Oxygen", "Flourine", "Neon", "Sodium", "Magnesium", "Aluminum", "Silicon", "Phosphorus", "Sulfur", "Chlorine", "Argon", "Potassium", "Calcium", "Scandium", "Titanium", "Vanadium", "Chromium", "Manganese", "Iron", "Cobalt", "Nickel", "Copper", "Zinc", "Gallium", "Germanium", "Arsenic", "Selenium", "Bromine", "Krypton", "Rubidium", "Strontium", "Yttrium", "Zirconium", "Niobium", "Molybdenum", "Technetium", "Ruthenium", "Rhodium", "Palladium", "Silver", "Cadmium", "Indium", "Tin", "Antimony", "Tellurium", "Iodine", "Xenon", "Cesium", "Barium", "Lanthanum", "Cerium", "Praseodymium", "Neodymium", "Promethium", "Samarium", "Europium", "Gadolinium", "Terbium", "Dysprosium", "Holmium", "Erbium", "Thulium", "Ytterbium", "Lutetium", "Hafnium", "Tantalum", "Tungsten", "Rhenium", "Osmium", "Iridium", "Platinum", "Gold", "Mercury", "Thallium", "Lead", "Bismuth", "Polonium", "Astatine", "Radon", "Francium", "Radium", "Actinium", "Thorium", "Proactinium", "Uranium", "Neptunium", "Plutonium ", "Americium", "Curium", "Berkelium", "Californium", "Einsteinium", "Fermium", "Mendelevium", "Nobelium", "Lawrencium", "Rutherfordium", "Dubnium", "Seaborgium", "Bohrium", "Hassium", "Meiterium", "Darmstadtium", "Roentgenium", "Copernicium", "Nihonium", "Flerovium", "Moscovium", "Livermorium", "Tennessine", "Oganesson", "Netherite");
    public final List<String> symbols = Arrays.asList("", "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os ", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Nr");
    public final List<Element> amalgamExtras = Arrays.asList(Element.IRON, Element.PLATINUM, Element.TUNGSTEN, Element.TANTALUM);
    public final List<Element> amalgamNonmetals = Arrays.asList(Element.BORON, Element.CARBON, Element.SILICON, Element.PHOSPHORUS, Element.SULFUR, Element.ARSENIC, Element.ANTIMONY);

    public static PeriodicTableUtils getInstance() {
        return INSTANCE;
    }

    public List<String> getElementNames() {
        return this.names;
    }

    public List<String> getImplementedElementNames() {
        ArrayList<String> elements = new ArrayList<String>();
        for (Element e : Element.values()) {
            elements.add(e.toString().toLowerCase());
        }
        return elements;
    }

    public Element getElementFromItem(Item item) {
        for (ResourceLocation tag : item.getTags()) {
            if (!tag.toString().contains("rankine:elements/") && !tag.toString().contains("forge:ingots/") && !tag.toString().contains("forge:storage_blocks/") && !tag.toString().contains("forge:nuggets/")) continue;
            String temp = tag.func_110623_a().split("/")[1];
            if (!this.getImplementedElementNames().contains(temp)) continue;
            return Element.valueOfCaseIgnored(temp);
        }
        return Element.NONE;
    }

    public Element getElementFromIngotItem(Item item) {
        for (ResourceLocation tag : item.getTags()) {
            if (!tag.toString().contains("rankine:elements/") && !tag.toString().contains("forge:ingots/") && !tag.toString().contains("forge:storage_blocks/") && !tag.toString().contains("forge:nuggets/")) continue;
            String temp = tag.func_110623_a().split("/")[1];
            if (!this.getImplementedElementNames().contains(temp) || !item.getTags().contains(new ResourceLocation("forge:ingots")) && (item.getRegistryName() == null || !item.getRegistryName().toString().contains("ingot"))) continue;
            return Element.valueOfCaseIgnored(temp);
        }
        return Element.NONE;
    }

    public boolean hasElement(Item item) {
        return this.getElementFromItem(item) != Element.NONE;
    }

    public List<String> getElementSymbols() {
        return this.symbols;
    }

    public Element getElementbyNumber(int x) {
        for (Element i : Element.values()) {
            if (i.getAtomicNumber() != x) continue;
            return i;
        }
        return Element.NONE;
    }

    public Item getElementIngot(Element element) {
        Item elementIngot;
        String namespace = "rankine";
        if (element == Element.IRON || element == Element.GOLD || element == Element.NETHERITE) {
            namespace = "minecraft";
        }
        if ((elementIngot = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(namespace, element.name().toLowerCase(Locale.ROOT) + "_ingot"))) != null) {
            return elementIngot;
        }
        return Items.field_190931_a;
    }

    public Element getAdjacentElement(Element element, int direction) {
        if (element == Element.NONE) {
            return Element.NONE;
        }
        int atom = element.getAtomicNumber();
        switch (direction) {
            case 3: {
                int up = 0;
                if (atom == 3) {
                    up = 1;
                } else if (atom >= 10 && atom <= 20) {
                    up = 8;
                } else if (atom >= 31 && atom <= 57) {
                    up = 18;
                } else if (atom >= 72 && atom <= 121) {
                    up = 32;
                } else if (atom >= 140 && atom <= 218) {
                    up = 50;
                }
                if (((Boolean)Config.MACHINES.RANKINE_BOX_UP.get()).booleanValue() && up != 0) {
                    return this.getElementbyNumber(atom - up);
                }
                return Element.NONE;
            }
            case 4: {
                if (((Boolean)Config.MACHINES.RANKINE_BOX_RIGHT.get()).booleanValue()) {
                    return this.getElementbyNumber(atom + 1);
                }
                return Element.NONE;
            }
            case 5: {
                int down = 0;
                if (atom == 1) {
                    down = 1;
                } else if (atom >= 3 && atom <= 12) {
                    down = 8;
                } else if (atom >= 19 && atom <= 39) {
                    down = 18;
                } else if (atom >= 40 && atom <= 89) {
                    down = 32;
                } else if (atom >= 90 && atom <= 168) {
                    down = 50;
                }
                if (((Boolean)Config.MACHINES.RANKINE_BOX_DOWN.get()).booleanValue() && down != 0) {
                    return this.getElementbyNumber(atom + down);
                }
                return Element.NONE;
            }
            case 6: {
                if (((Boolean)Config.MACHINES.RANKINE_BOX_LEFT.get()).booleanValue()) {
                    return this.getElementbyNumber(atom - 1);
                }
                return Element.NONE;
            }
        }
        return Element.NONE;
    }

    public String getElementNameBySymbol(String symbol) {
        int index = this.symbols.indexOf(symbol);
        return this.names.get(index);
    }

    public Element getElementBySymbol(String symbol) {
        for (Element i : Element.values()) {
            if (!i.symbol.equals(symbol)) continue;
            return i;
        }
        return Element.NONE;
    }

    public int calcDurability(List<Element> elements, List<Integer> percents) {
        int index = 0;
        int durability = 0;
        for (Element e : elements) {
            durability += e.element.getDurabilityFromPercent(percents.get(index));
            ++index;
        }
        return durability;
    }

    public float calcMiningSpeed(List<Element> elements, List<Integer> percents) {
        int index = 0;
        float miningSpeed = 0.0f;
        for (Element e : elements) {
            miningSpeed += e.element.getMiningSpeedFromPercent(percents.get(index));
            ++index;
        }
        return miningSpeed;
    }

    public int calcMiningLevel(List<Element> elements, List<Integer> percents) {
        int index = 0;
        ArrayList<Integer> levels = new ArrayList<Integer>();
        for (Element e : elements) {
            levels.add(e.element.getMiningLevelFromPercent(percents.get(index)));
            ++index;
        }
        return (Integer)Collections.max(levels);
    }

    public float calcArrowDamage(List<Element> elements, List<Integer> percents) {
        int hl = this.calcMiningLevel(elements, percents);
        float dmg = this.calcDamage(elements, percents);
        return 2.0f + 0.5f * (float)hl + 0.5f * dmg;
    }

    public int calcDamageReduceAmount(List<Element> elements, List<Integer> percents, EquipmentSlotType slotType) {
        int base = slotType == EquipmentSlotType.CHEST ? 3 : (slotType == EquipmentSlotType.LEGS ? 2 : 1);
        int index = 0;
        ArrayList<Integer> levels = new ArrayList<Integer>();
        for (Element e : elements) {
            levels.add(e.element.getMiningLevelFromPercent(percents.get(index)));
            ++index;
        }
        int dr = (Integer)Collections.max(levels);
        if (slotType == EquipmentSlotType.CHEST || slotType == EquipmentSlotType.LEGS) {
            return Math.min(base + dr, 10);
        }
        if (slotType == EquipmentSlotType.FEET) {
            if (dr >= 5) {
                return base + 2;
            }
            if (dr >= 3) {
                return base + 1;
            }
            return base;
        }
        if (dr >= 5) {
            return base + 3;
        }
        if (dr >= 3) {
            return base + 2;
        }
        if (dr >= 1) {
            return base + 1;
        }
        return base;
    }

    public float calcDamage(List<Element> elements, List<Integer> percents) {
        int index = 0;
        ArrayList<Float> levels = new ArrayList<Float>();
        for (Element e : elements) {
            levels.add(Float.valueOf(e.element.getDamageFromPercent(percents.get(index))));
            ++index;
        }
        return ((Float)Collections.max(levels)).floatValue();
    }

    public float calcAttackSpeed(List<Element> elements, List<Integer> percents) {
        int index = 0;
        ArrayList<Float> levels = new ArrayList<Float>();
        for (Element e : elements) {
            levels.add(Float.valueOf(e.element.getAttackSpeedFromPercent(percents.get(index))));
            ++index;
        }
        return ((Float)Collections.max(levels)).floatValue();
    }

    public int calcEnchantability(List<Element> elements, List<Integer> percents) {
        int index = 0;
        int enchant = 0;
        for (Element e : elements) {
            enchant += e.element.getEnchantabilityFromPercent(percents.get(index));
            ++index;
        }
        return enchant;
    }

    public float calcCorrResist(List<Element> elements, List<Integer> percents) {
        int index = 0;
        float corrResist = 0.0f;
        for (Element e : elements) {
            corrResist += e.element.getCorrResistFromPercent(percents.get(index));
            ++index;
        }
        return corrResist;
    }

    public float calcHeatResist(List<Element> elements, List<Integer> percents) {
        int index = 0;
        float heatResist = 0.0f;
        for (Element e : elements) {
            heatResist += e.element.getHeatResistFromPercent(percents.get(index));
            ++index;
        }
        return heatResist;
    }

    public float calcToughness(List<Element> elements, List<Integer> percents) {
        int index = 0;
        float tough = 0.0f;
        for (Element e : elements) {
            tough += e.element.getToughnessFromPercent(percents.get(index));
            ++index;
        }
        return tough;
    }

    public int calcArmorDurability(List<Element> elements, List<Integer> percents, int extra, EquipmentSlotType slotType) {
        int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
        int durability = this.calcDurability(elements, percents) + extra;
        if (durability <= 100) {
            return Math.round((float)(MAX_DAMAGE_ARRAY[slotType.func_188454_b()] * durability) / 10.0f);
        }
        return Math.round((float)MAX_DAMAGE_ARRAY[slotType.func_188454_b()] * (10.0f + (float)(durability - 100) / 50.0f));
    }

    public int calcArmorToughness(List<Element> elements, List<Integer> percents) {
        int index = 0;
        float tough = 0.0f;
        for (Element e : elements) {
            tough += e.element.getToughnessFromPercent(percents.get(index));
            ++index;
        }
        if ((double)tough >= 0.4) {
            return 4;
        }
        if ((double)tough >= 0.3) {
            return 3;
        }
        if ((double)tough >= 0.2) {
            return 2;
        }
        if ((double)tough >= 0.1) {
            return 1;
        }
        return 0;
    }

    public List<Enchantment> getEnchantments(List<Element> elements, List<Integer> percents) {
        int index = 0;
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        for (Element e : elements) {
            Enchantment en = e.element.getEnchantments(percents.get(index));
            if (en != null) {
                enchantments.add(en);
            }
            ++index;
        }
        return enchantments;
    }

    public static enum Element {
        NONE(-1, "X", new NoneElement()),
        HYDROGEN(1, "H", new HydrogenElement()),
        HELIUM(2, "He", new HeliumElement()),
        LITHIUM(3, "Li", new LithiumElement(), 0xD6F6FF),
        BERYLLIUM(4, "Be", new BerylliumElement(), 6672537),
        BORON(5, "B", new BoronElement(), 10194328),
        CARBON(6, "C", new CarbonElement(), 0x636363),
        NITROGEN(7, "N", new NitrogenElement()),
        OXYGEN(8, "O", new OxygenElement()),
        FLUORINE(9, "F", new FluorineElement()),
        NEON(10, "Ne", new NeonElement()),
        SODIUM(11, "Na", new SodiumElement()),
        MAGNESIUM(12, "Mg", new MagnesiumElement(), 15724505),
        ALUMINUM(13, "Al", new AluminumElement(), 15919335),
        SILICON(14, "Si", new SiliconElement(), 8684688),
        PHOSPHORUS(15, "P", new PhosphorusElement(), 14202036),
        SULFUR(16, "S", new SulfurElement(), 0xE0E060),
        CHLORINE(17, "Cl", new ChlorineElement()),
        ARGON(18, "Ar", new ArgonElement()),
        POTASSIUM(19, "K", new PotassiumElement()),
        CALCIUM(20, "Ca", new CalciumElement(), 15595448),
        SCANDIUM(21, "Sc", new ScandiumElement()),
        TITANIUM(22, "Ti", new TitaniumElement(), 13621208),
        VANADIUM(23, "V", new VanadiumElement(), 13416389),
        CHROMIUM(24, "Cr", new ChromiumElement(), 15462646),
        MANGANESE(25, "Mn", new ManganeseElement(), 15450555),
        IRON(26, "Fe", new IronElement(), 0xD8D8D8),
        COBALT(27, "Co", new CobaltElement(), 11653119),
        NICKEL(28, "Ni", new NickelElement(), 13625311),
        COPPER(29, "Cu", new CopperElement(), 15382670),
        ZINC(30, "Zn", new ZincElement(), 14870226),
        GALLIUM(31, "Ga", new GalliumElement(), 9207455),
        GERMANIUM(32, "Ge", new GermaniumElement()),
        ARSENIC(33, "As", new ArsenicElement()),
        SELENIUM(34, "Se", new SeleniumElement()),
        BROMINE(35, "Br", new BromineElement()),
        KRYPTON(36, "K", new KryptonElement()),
        RUBIDIUM(37, "Rb", new RubidiumElement()),
        STRONTIUM(38, "Sr", new StrontiumElement()),
        YTTRIUM(39, "Y", new YttriumElement()),
        ZIRCONIUM(40, "Zr", new ZirconiumElement(), 9018824),
        NIOBIUM(41, "Nb", new NiobiumElement(), 10200279),
        MOLYBDENUM(42, "Mo", new MolybdenumElement(), 13615061),
        TECHNETIUM(43, "Tc", new TechnetiumElement()),
        RUTHENIUM(44, "Ru", new RutheniumElement()),
        RHODIUM(45, "Rh", new RhodiumElement()),
        PALLADIUM(46, "Pd", new PalladiumElement(), 15699840),
        SILVER(47, "Ag", new SilverElement(), 0xEFEFEF),
        CADMIUM(48, "Cd", new CadmiumElement()),
        INDIUM(49, "In", new IndiumElement(), 6315469),
        TIN(50, "Sn", new TinElement(), 11975882),
        ANTIMONY(51, "Sb", new AntimonyElement(), 13683045),
        TELLURIUM(52, "Te", new TelluriumElement()),
        IODINE(53, "I", new IodineElement()),
        XENON(54, "Xe", new XenonElement()),
        CESIUM(55, "Cs", new CesiumElement()),
        BARIUM(56, "Ba", new BariumElement()),
        LANTHANUM(57, "La", new LanthanumElement()),
        CERIUM(58, "Ce", new CeriumElement()),
        PRASEODYMIUM(59, "Pr", new PraseodymiumElement()),
        NEODYMIUM(60, "Nd", new NeodymiumElement()),
        PROMETHIUM(61, "Pm", new PromethiumElement()),
        SAMARIUM(62, "Sm", new SamariumElement()),
        EUROPIUM(63, "Eu", new EuropiumElement()),
        GADOLINIUM(64, "Gd", new GadoliniumElement()),
        TERBIUM(65, "Tb", new TerbiumElement()),
        DYSPROSIUM(66, "Dy", new DysprosiumElement()),
        HOLMIUM(67, "Ho", new HolmiumElement()),
        ERBIUM(68, "Er", new ErbiumElement()),
        THULIUM(69, "Tm", new ThuliumElement()),
        YTTERBIUM(70, "Yb", new YtterbiumElement()),
        LUTETIUM(71, "Lu", new LutetiumElement()),
        HAFNIUM(72, "Hf", new HafniumElement()),
        TANTALUM(73, "Ta", new TantalumElement()),
        TUNGSTEN(74, "W", new TungstenElement(), 12693657),
        RHENIUM(75, "Re", new RheniumElement()),
        OSMIUM(76, "Os", new OsmiumElement()),
        IRIDIUM(77, "Ir", new IridiumElement()),
        PLATINUM(78, "Pt", new PlatinumElement(), 14016232),
        GOLD(79, "Au", new GoldElement(), 0xFDF55F),
        MERCURY(80, "Hg", new MercuryElement(), 15721704),
        THALLIUM(81, "Tl", new ThalliumElement()),
        LEAD(82, "Pb", new LeadElement(), 10131385),
        BISMUTH(83, "Bi", new BismuthElement(), 14407127),
        POLONIUM(84, "Po", new PoloniumElement()),
        ASTATINE(85, "At", new AstatineElement()),
        RADON(86, "Rn", new RadonElement()),
        FRANCIUM(87, "Fr", new FranciumElement()),
        RADIUM(88, "Ra", new RadiumElement()),
        ACTINIUM(89, "Ac", new ActiniumElement()),
        THORIUM(90, "Th", new ThoriumElement()),
        PROTACTINIUM(91, "Pa", new ProtactiniumElement()),
        URANIUM(92, "U", new UraniumElement()),
        NEPTUNIUM(93, "Np", new NeptuniumElement()),
        PLUTONIUM(94, "Pu", new PlutoniumElement()),
        AMERICIUM(95, "Am", new AmericiumElement()),
        CURIUM(96, "Cm", new CuriumElement()),
        BERKELIUM(97, "Bk", new BerkeliumElement()),
        CALIFORNIUM(98, "Cf", new CaliforniumElement()),
        EINSTEINIUM(99, "Es", new EinsteiniumElement()),
        FERMIUM(100, "Fm", new FermiumElement()),
        MENDELEVIUM(101, "Md", new MendeleviumElement()),
        NOBELIUM(102, "No", new NobeliumElement()),
        LAWRENCIUM(103, "Lr", new LawrenciumElement()),
        RUTHERFORDIUM(104, "Rf", new RutherfordiumElement()),
        DUBNIUM(105, "Db", new DubniumElement()),
        SEABORGIUM(106, "Sg", new SeaborgiumElement()),
        BOHRIUM(107, "Bh", new BohriumElement()),
        HASSIUM(108, "Hs", new HassiumElement()),
        MEITNERIUM(109, "Mt", new MeitneriumElement()),
        DARMSTADTIUM(110, "Ds", new DarmstadtiumElement()),
        ROENTGENIUM(111, "Rg", new RoentgeniumElement()),
        COPERNICIUM(112, "Cn", new CoperniciumElement()),
        NIHONIUM(113, "Nh", new NihoniumElement()),
        FLEROVIUM(114, "Fl", new FleroviumElement()),
        MOSCOVIUM(115, "Mc", new MoscoviumElement()),
        LIVERMORIUM(116, "Lv", new LivermoriumElement()),
        TENNESSINE(117, "Ts", new TennessineElement()),
        OGANESSON(118, "Og", new OganessonElement()),
        MANA(122, "M", new ManaElement(), 7845107),
        NETHERITE(161, "Nr", new NetheriteElement(), 4997443),
        SLIME(162, "Sl", new SlimeElement(), 7781997),
        PRISMARINE(163, "Mr", new PrismarineElement(), 10801602),
        WITHER(164, "Wi", new WitherElement(), 0x171717),
        GHASTIUM(165, "Gh", new GhastiumElement(), 0xCFF1F1),
        PHLOGISTON(166, "Pg", new PhlogistonElement(), 16761088),
        ENDITE(167, "Ed", new EnditeElement(), 2458740),
        DRACOCAELI(168, "Dr", new DracocaeliElement(), 11283579);

        public final int atomicNumber;
        public final String symbol;
        public final ElementInterface element;
        public final int color;

        private Element(int atomicNumber, String symbol, ElementInterface element, int color) {
            this.atomicNumber = atomicNumber;
            this.symbol = symbol;
            this.element = element;
            this.color = color;
        }

        private Element(int atomicNumber, String symbol, ElementInterface element) {
            this(atomicNumber, symbol, element, 0xFFFFFF);
        }

        public int getAtomicNumber() {
            return this.atomicNumber;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public int getColor() {
            return this.color;
        }

        public static Element valueOfCaseIgnored(String string) {
            return Element.valueOf(string.toUpperCase());
        }
    }
}

