/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.util;

import com.cannolicatfish.rankine.items.alloys.AlloyData;
import com.cannolicatfish.rankine.items.alloys.AlloyItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.BasicTrade;

public class RankineVillagerTrades {
    public static List<VillagerTrades.ITrade> returnTagTrades(ResourceLocation tag, Item fallback, int amount, int emeraldCount, int maxUses, int xpValue, float mult) {
        ITag e = ItemTags.func_199903_a().func_199910_a(tag);
        ArrayList<VillagerTrades.ITrade> trades = new ArrayList<VillagerTrades.ITrade>();
        if (e != null) {
            for (Item item : e.func_230236_b_()) {
                trades.add((VillagerTrades.ITrade)new BasicTrade(emeraldCount, new ItemStack((IItemProvider)item, amount), maxUses, xpValue, mult));
            }
        } else {
            trades.add((VillagerTrades.ITrade)new BasicTrade(emeraldCount, new ItemStack((IItemProvider)fallback, amount), maxUses, xpValue, mult));
        }
        return trades;
    }

    public static class RandomItemFromTagForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack sellingStack;
        private final int emeraldCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public RandomItemFromTagForEmeraldsTrade(ResourceLocation tag, Item fallback, int amount, int emeraldCount, int maxUses, int xpValue) {
            this(tag, fallback, emeraldCount, amount, maxUses, xpValue, 0.05f);
        }

        public RandomItemFromTagForEmeraldsTrade(ResourceLocation tag, Item fallback, int amount, int emeraldCount, int maxUses, int xpValue, float priceMultiplier) {
            ITag e = ItemTags.func_199903_a().func_199910_a(tag);
            this.sellingStack = e != null ? new ItemStack((IItemProvider)e.func_205596_a(new Random()), amount) : new ItemStack((IItemProvider)fallback, amount);
            this.emeraldCount = emeraldCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC), this.sellingStack, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    public static class EnchantedAlloyItemForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack sellingStack;
        private final int emeraldCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;
        private final String alloyData;

        public EnchantedAlloyItemForEmeraldsTrade(Item p_i50535_1_, String alloyData, int emeraldCount, int maxUses, int xpValue) {
            this(p_i50535_1_, alloyData, emeraldCount, maxUses, xpValue, 0.05f);
        }

        public EnchantedAlloyItemForEmeraldsTrade(Item sellItem, String alloyData, int emeraldCount, int maxUses, int xpValue, float priceMultiplier) {
            this.sellingStack = new ItemStack((IItemProvider)sellItem);
            this.emeraldCount = emeraldCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.alloyData = alloyData;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            int i = 5 + rand.nextInt(15);
            ItemStack itemstack = EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)new ItemStack((IItemProvider)this.sellingStack.func_77973_b()), (int)i, (boolean)false);
            AlloyItem.addAlloy(itemstack, new AlloyData(this.alloyData));
            int j = Math.min(this.emeraldCount + i, 64);
            ItemStack itemstack1 = new ItemStack((IItemProvider)Items.field_151166_bC, j);
            return new MerchantOffer(itemstack1, itemstack, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }
}

