/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;

public class WeightedCollection<I> {
    private final NavigableMap<Float, I> map = new TreeMap<Float, I>();
    private final Random random;
    private float total = 0.0f;

    public WeightedCollection() {
        this(new Random());
    }

    public WeightedCollection(Random random) {
        this.random = random;
    }

    public WeightedCollection<I> add(float weight, I result) {
        if (weight <= 0.0f) {
            return this;
        }
        this.total += weight;
        this.map.put(Float.valueOf(this.total), result);
        return this;
    }

    public I getRandomElement() {
        float value = this.random.nextFloat() * this.total;
        return this.map.higherEntry(Float.valueOf(value)).getValue();
    }

    public NavigableMap<Float, I> getMap() {
        return this.map;
    }

    public Collection<I> getEntries() {
        return this.map.values();
    }

    public Set<Float> getWeights() {
        return this.map.keySet();
    }

    public List<Float> returnConvertedWeights() {
        ArrayList<Float> weights = new ArrayList<Float>(this.getWeights());
        float sum = 0.0f;
        Iterator iterator = weights.iterator();
        while (iterator.hasNext()) {
            float i = ((Float)iterator.next()).floatValue();
            sum += i;
        }
        ArrayList<Float> ret = new ArrayList<Float>();
        Iterator iterator2 = weights.iterator();
        while (iterator2.hasNext()) {
            float i = ((Float)iterator2.next()).floatValue();
            ret.add(Float.valueOf(Math.round(i / sum) * 100));
        }
        return ret;
    }
}

