/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.util.alloys;

import com.cannolicatfish.rankine.items.tools.HammerItem;
import com.cannolicatfish.rankine.items.tools.SpearItem;
import java.util.Collections;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.util.ResourceLocation;

public class AlloyEnchantmentHandler {
    static AlloyEnchantmentHandler EMPTY = new AlloyEnchantmentHandler();
    private final List<ResourceLocation> axeEnchants;
    private final List<ResourceLocation> hammerEnchants;
    private final List<ResourceLocation> hoeEnchants;
    private final List<ResourceLocation> pickaxeEnchants;
    private final List<ResourceLocation> shovelEnchants;
    private final List<ResourceLocation> spearEnchants;
    private final List<ResourceLocation> swordEnchants;
    private final int start;
    private final int interval;
    private final int maxLvl;

    public AlloyEnchantmentHandler(List<ResourceLocation> axeEnchantsIn, List<ResourceLocation> hammerEnchantsIn, List<ResourceLocation> hoeEnchantsIn, List<ResourceLocation> pickaxeEnchantsIn, List<ResourceLocation> shovelEnchantsIn, List<ResourceLocation> spearEnchantsIn, List<ResourceLocation> swordEnchantsIn, int start, int interval, int maxLvl) {
        this.axeEnchants = axeEnchantsIn;
        this.hammerEnchants = hammerEnchantsIn;
        this.hoeEnchants = hoeEnchantsIn;
        this.pickaxeEnchants = pickaxeEnchantsIn;
        this.shovelEnchants = shovelEnchantsIn;
        this.spearEnchants = spearEnchantsIn;
        this.swordEnchants = swordEnchantsIn;
        this.start = start;
        this.interval = interval;
        this.maxLvl = maxLvl;
    }

    public AlloyEnchantmentHandler(List<ResourceLocation> axeEnchantsIn, List<ResourceLocation> hammerEnchantsIn, List<ResourceLocation> hoeEnchantsIn, List<ResourceLocation> pickaxeEnchantsIn, List<ResourceLocation> shovelEnchantsIn, List<ResourceLocation> spearEnchantsIn, List<ResourceLocation> swordEnchantsIn) {
        this(axeEnchantsIn, hammerEnchantsIn, hoeEnchantsIn, pickaxeEnchantsIn, shovelEnchantsIn, spearEnchantsIn, swordEnchantsIn, 15, 5, 5);
    }

    public AlloyEnchantmentHandler() {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), 15, 5, 5);
    }

    public AlloyEnchantmentHandler(int start, int interval, int maxLvl) {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), start, interval, maxLvl);
    }

    public List<ResourceLocation> getEnchantmentsForItem(ItemStack stack) {
        return this.getEnchantmentsForItem(stack.func_77973_b());
    }

    public List<ResourceLocation> getEnchantmentsForItem(Item item) {
        if (item instanceof AxeItem) {
            return this.axeEnchants;
        }
        if (item instanceof HammerItem) {
            return this.hammerEnchants;
        }
        if (item instanceof HoeItem) {
            return this.hoeEnchants;
        }
        if (item instanceof PickaxeItem) {
            return this.pickaxeEnchants;
        }
        if (item instanceof ShovelItem) {
            return this.shovelEnchants;
        }
        if (item instanceof SpearItem) {
            return this.spearEnchants;
        }
        if (item instanceof SwordItem) {
            return this.swordEnchants;
        }
        return Collections.emptyList();
    }

    public int returnEnchantmentLevel(Enchantment en, int enchantability) {
        if (en.func_190936_d()) {
            return 1;
        }
        if (enchantability < this.start) {
            return 0;
        }
        if (enchantability >= this.start + this.interval * this.maxLvl) {
            return Math.min(this.maxLvl, en.func_77325_b());
        }
        for (int i = 1; i < this.maxLvl + 1; ++i) {
            if (enchantability < this.start + this.interval * (i - 1) || enchantability >= this.start + this.interval * i) continue;
            return Math.min(i, en.func_77325_b());
        }
        return 0;
    }
}

