/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.util.elements;

import com.cannolicatfish.rankine.util.PeriodicTableUtils;
import com.cannolicatfish.rankine.util.elements.ElementInterface;
import net.minecraft.enchantment.Enchantment;

public class ChromiumElement
implements ElementInterface {
    @Override
    public PeriodicTableUtils.Element getReference() {
        return PeriodicTableUtils.Element.CHROMIUM;
    }

    @Override
    public int getDurabilityFromPercent(int x) {
        return 4 * x;
    }

    @Override
    public float getDamageFromPercent(int x) {
        return 0.0f;
    }

    @Override
    public float getAttackSpeedFromPercent(int x) {
        return 0.0f;
    }

    @Override
    public float getMiningSpeedFromPercent(int x) {
        return Math.round((float)x / 25.0f);
    }

    @Override
    public int getMiningLevelFromPercent(int x) {
        if (x >= 18) {
            return 3;
        }
        if (x >= 12) {
            return 2;
        }
        if (x >= 6) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getEnchantabilityFromPercent(int x) {
        if (x >= 50) {
            return Math.round(4.0f + 2.0f * ((float)x / 10.0f - 5.0f));
        }
        return Math.max(x / 10 - 1, 0);
    }

    @Override
    public float getCorrResistFromPercent(int x) {
        if (x <= 25) {
            return (float)((double)0.15f * Math.log10(x) + (double)0.3f) / 2.0f;
        }
        return 0.2f + (float)x / 125.0f;
    }

    @Override
    public float getHeatResistFromPercent(int x) {
        return 0.0f;
    }

    @Override
    public float getToughnessFromPercent(int x) {
        if (x < 10) {
            return (float)x / 200.0f;
        }
        return 0.05f;
    }

    @Override
    public float getElectrodePotentialFromPercent(int x) {
        return -0.74f;
    }

    @Override
    public Enchantment getEnchantments(int x) {
        return null;
    }
}

