/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.util.elements;

import com.cannolicatfish.rankine.util.PeriodicTableUtils;
import com.cannolicatfish.rankine.util.elements.ElementInterface;
import net.minecraft.enchantment.Enchantment;

public class ManganeseElement
implements ElementInterface {
    @Override
    public PeriodicTableUtils.Element getReference() {
        return PeriodicTableUtils.Element.MANGANESE;
    }

    @Override
    public int getDurabilityFromPercent(int x) {
        if (x <= 2) {
            return 50 * x;
        }
        if (x <= 10) {
            return 100 - x * 25;
        }
        if (x <= 12) {
            return (x - 10) * 200 - 150;
        }
        if (x <= 16) {
            return 250 - 10 * x;
        }
        return 90 - x / 2;
    }

    @Override
    public float getDamageFromPercent(int x) {
        return 0.0f;
    }

    @Override
    public float getAttackSpeedFromPercent(int x) {
        return 0.0f;
    }

    @Override
    public float getMiningSpeedFromPercent(int x) {
        if (x <= 2) {
            return (float)x * 0.25f;
        }
        if (x <= 10) {
            return 1.0f - (float)x / 5.0f;
        }
        if (x <= 12) {
            return -1 + (x - 10);
        }
        if (x <= 16) {
            return 1.0f - (float)x / 20.0f;
        }
        return 0.21f - (float)x / 500.0f;
    }

    @Override
    public int getMiningLevelFromPercent(int x) {
        if (x >= 10 && x <= 16) {
            return 2;
        }
        if (x > 0 && x <= 4) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getEnchantabilityFromPercent(int x) {
        return Math.round((float)(-x) / 5.0f);
    }

    @Override
    public float getCorrResistFromPercent(int x) {
        return 0.0f;
    }

    @Override
    public float getHeatResistFromPercent(int x) {
        return 0.0f;
    }

    @Override
    public float getToughnessFromPercent(int x) {
        if (x >= 10 && x <= 16) {
            return 0.05f;
        }
        return 0.0f;
    }

    @Override
    public float getElectrodePotentialFromPercent(int x) {
        return -1.185f;
    }

    @Override
    public Enchantment getEnchantments(int x) {
        return null;
    }
}

