/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.util.elements;

import com.cannolicatfish.rankine.util.PeriodicTableUtils;
import com.cannolicatfish.rankine.util.elements.ElementInterface;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;

public class SilverElement
implements ElementInterface {
    @Override
    public PeriodicTableUtils.Element getReference() {
        return PeriodicTableUtils.Element.SILVER;
    }

    @Override
    public int getDurabilityFromPercent(int x) {
        return (int)Math.round(Math.log(4.0f * (float)x + 1.0f) * (double)x / 10.0);
    }

    @Override
    public float getDamageFromPercent(int x) {
        return 0.0f;
    }

    @Override
    public float getAttackSpeedFromPercent(int x) {
        return 0.0f;
    }

    @Override
    public float getMiningSpeedFromPercent(int x) {
        return (float)(2 * x) / 25.0f;
    }

    @Override
    public int getMiningLevelFromPercent(int x) {
        return 0;
    }

    @Override
    public int getEnchantabilityFromPercent(int x) {
        if (x >= 10) {
            return 5 + Math.round((float)(x - 10) / 6.0f);
        }
        return Math.round((float)x / 2.0f);
    }

    @Override
    public float getCorrResistFromPercent(int x) {
        return (float)x / 100.0f;
    }

    @Override
    public float getHeatResistFromPercent(int x) {
        return (float)x / 500.0f;
    }

    @Override
    public float getToughnessFromPercent(int x) {
        return (float)(-x) / 500.0f;
    }

    @Override
    public float getElectrodePotentialFromPercent(int x) {
        return 0.7996f;
    }

    @Override
    public Enchantment getEnchantments(int x) {
        if (x >= 50) {
            return Enchantments.field_185303_l;
        }
        return null;
    }
}

