/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.util.elements;

import com.cannolicatfish.rankine.init.RankineEnchantments;
import com.cannolicatfish.rankine.util.PeriodicTableUtils;
import com.cannolicatfish.rankine.util.elements.ElementInterface;
import net.minecraft.enchantment.Enchantment;

public class WitherElement
implements ElementInterface {
    @Override
    public PeriodicTableUtils.Element getReference() {
        return PeriodicTableUtils.Element.WITHER;
    }

    @Override
    public int getDurabilityFromPercent(int x) {
        return (int)Math.round(Math.pow((float)x / 2.0f, 2.0) / 2.0);
    }

    @Override
    public float getDamageFromPercent(int x) {
        if (x <= 50) {
            return (float)x / 20.0f;
        }
        return 2.5f;
    }

    @Override
    public float getAttackSpeedFromPercent(int x) {
        if (x <= 40) {
            return (float)x / 20.0f;
        }
        return 2.0f;
    }

    @Override
    public float getMiningSpeedFromPercent(int x) {
        return (float)(-x) / 10.0f;
    }

    @Override
    public int getMiningLevelFromPercent(int x) {
        if (x >= 10) {
            return 4;
        }
        if (x >= 0) {
            return 3;
        }
        return 0;
    }

    @Override
    public int getEnchantabilityFromPercent(int x) {
        return Math.round((float)x * 0.2f);
    }

    @Override
    public float getCorrResistFromPercent(int x) {
        return 0.0f;
    }

    @Override
    public float getHeatResistFromPercent(int x) {
        if (x <= 40) {
            return (float)x / 40.0f;
        }
        return 1.0f;
    }

    @Override
    public float getToughnessFromPercent(int x) {
        return (float)x / 625.0f;
    }

    @Override
    public float getElectrodePotentialFromPercent(int x) {
        return 0.0f;
    }

    @Override
    public Enchantment getEnchantments(int x) {
        if (x > 5) {
            return RankineEnchantments.WITHERING_CURSE;
        }
        return null;
    }
}

