/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.world.gen;

import com.cannolicatfish.rankine.init.RankineFeatures;
import com.cannolicatfish.rankine.init.WGConfig;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class DecorationGen {
    private static List<ResourceLocation> getBiomeNamesFromCategory(List<Biome.Category> biomeCats, boolean include) {
        ArrayList<ResourceLocation> b = new ArrayList<ResourceLocation>();
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (!biomeCats.isEmpty()) {
                for (Biome.Category cat : biomeCats) {
                    if (biome.func_201856_r() == cat && include) {
                        b.add(biome.getRegistryName());
                    }
                    if (include || biome.func_201856_r() == cat || biome.func_201856_r() == Biome.Category.NETHER || biome.func_201856_r() == Biome.Category.THEEND) continue;
                    b.add(biome.getRegistryName());
                }
                continue;
            }
            if (include || biome.func_201856_r() == Biome.Category.NETHER || biome.func_201856_r() == Biome.Category.THEEND) continue;
            b.add(biome.getRegistryName());
        }
        return b;
    }

    private static List<AbstractMap.SimpleEntry<ConfiguredFeature<?, ?>, List<ResourceLocation>>> getLocalModificationFeatures() {
        ArrayList LocalModifications = new ArrayList();
        if (((Boolean)WGConfig.MISC.METEORITE_GEN.get()).booleanValue()) {
            LocalModifications.add(new AbstractMap.SimpleEntry(RankineFeatures.METEORITE, DecorationGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
        }
        return LocalModifications;
    }

    private static List<AbstractMap.SimpleEntry<ConfiguredFeature<?, ?>, List<ResourceLocation>>> getVegetalDecorationFeatures() {
        if (((Boolean)WGConfig.MISC.RANKINE_FAUNA.get()).booleanValue()) {
            return Arrays.asList(new AbstractMap.SimpleEntry(RankineFeatures.ELDERBERRY_BUSH, DecorationGen.getBiomeNamesFromCategory(Arrays.asList(Biome.Category.FOREST, Biome.Category.PLAINS), true)), new AbstractMap.SimpleEntry(RankineFeatures.SNOWBERRY_BUSH, DecorationGen.getBiomeNamesFromCategory(Arrays.asList(Biome.Category.EXTREME_HILLS, Biome.Category.ICY), true)), new AbstractMap.SimpleEntry(RankineFeatures.BLUEBERRY_BUSH, DecorationGen.getBiomeNamesFromCategory(Arrays.asList(Biome.Category.RIVER, Biome.Category.PLAINS), true)), new AbstractMap.SimpleEntry(RankineFeatures.CAMPHOR_BASIL_PLANT, DecorationGen.getBiomeNamesFromCategory(Arrays.asList(Biome.Category.RIVER, Biome.Category.JUNGLE), true)), new AbstractMap.SimpleEntry(RankineFeatures.RASPBERRY_BUSH, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.FOREST), true)), new AbstractMap.SimpleEntry(RankineFeatures.BLACKBERRY_BUSH, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.FOREST), true)), new AbstractMap.SimpleEntry(RankineFeatures.CRANBERRY_BUSH, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.SWAMP), true)), new AbstractMap.SimpleEntry(RankineFeatures.STRAWBERRY_BUSH, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.PLAINS), true)), new AbstractMap.SimpleEntry(RankineFeatures.PINEAPPLE_BUSH, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.JUNGLE), true)), new AbstractMap.SimpleEntry(RankineFeatures.BANANA_YUCCA_BUSH, DecorationGen.getBiomeNamesFromCategory(Arrays.asList(Biome.Category.SAVANNA, Biome.Category.DESERT, Biome.Category.MESA), true)), new AbstractMap.SimpleEntry(RankineFeatures.ALOE_PLANT, DecorationGen.getBiomeNamesFromCategory(Arrays.asList(Biome.Category.SAVANNA, Biome.Category.DESERT, Biome.Category.MESA), true)), new AbstractMap.SimpleEntry(RankineFeatures.YELLOW_BIRCH_TREE, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.FOREST), true)), new AbstractMap.SimpleEntry(RankineFeatures.BLACK_BIRCH_TREE, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.FOREST), true)), new AbstractMap.SimpleEntry(RankineFeatures.EASTERN_HEMLOCK_TREE, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.TAIGA), true)), new AbstractMap.SimpleEntry(RankineFeatures.CEDAR_TREE, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.TAIGA), true)), new AbstractMap.SimpleEntry(RankineFeatures.COCONUT_PALM_TREE, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.BEACH), true)), new AbstractMap.SimpleEntry(RankineFeatures.PINYON_PINE_TREE, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.SAVANNA), true)), new AbstractMap.SimpleEntry(RankineFeatures.BALSAM_FIR_TREE, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.SWAMP), true)), new AbstractMap.SimpleEntry(RankineFeatures.DEAD_BALSAM_FIR_TREE, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.SWAMP), true)), new AbstractMap.SimpleEntry(RankineFeatures.MAGNOLIA_TREE, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.RIVER), true)), new AbstractMap.SimpleEntry(RankineFeatures.JUNIPER_TREE, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.SAVANNA), true)), new AbstractMap.SimpleEntry(RankineFeatures.MAPLE_TREE, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.PLAINS), true)), new AbstractMap.SimpleEntry(RankineFeatures.BLACK_WALNUT_TREE, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.RIVER), true)), new AbstractMap.SimpleEntry(RankineFeatures.CORK_OAK_TREE, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.MUSHROOM), true)), new AbstractMap.SimpleEntry(RankineFeatures.SHARINGA_TREE, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.JUNGLE), true)), new AbstractMap.SimpleEntry(RankineFeatures.CINNAMON_TREE, DecorationGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.JUNGLE), true)));
        }
        return Collections.emptyList();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void addBiomeFeatures(BiomeLoadingEvent event) {
        if (event.getName() != null) {
            List<AbstractMap.SimpleEntry<ConfiguredFeature<?, ?>, List<ResourceLocation>>> localModificationFeatures = DecorationGen.getLocalModificationFeatures();
            for (AbstractMap.SimpleEntry<ConfiguredFeature<?, ?>, List<ResourceLocation>> entry : localModificationFeatures) {
                if (!entry.getValue().contains(event.getName())) continue;
                event.getGeneration().func_242510_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS.ordinal(), entry::getKey);
            }
            List<AbstractMap.SimpleEntry<ConfiguredFeature<?, ?>, List<ResourceLocation>>> vegetalDecorationFeatures = DecorationGen.getVegetalDecorationFeatures();
            for (AbstractMap.SimpleEntry<ConfiguredFeature<?, ?>, List<ResourceLocation>> entry : vegetalDecorationFeatures) {
                if (!entry.getValue().contains(event.getName())) continue;
                event.getGeneration().func_242510_a(GenerationStage.Decoration.VEGETAL_DECORATION.ordinal(), entry::getKey);
            }
        }
    }
}

