/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.world.gen;

import com.cannolicatfish.rankine.init.RankineFeatures;
import com.cannolicatfish.rankine.init.WGConfig;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class OreGen {
    private static List<ResourceLocation> getBiomeNamesFromCategory(List<Biome.Category> biomeCats, boolean include) {
        ArrayList<ResourceLocation> b = new ArrayList<ResourceLocation>();
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (!biomeCats.isEmpty()) {
                for (Biome.Category cat : biomeCats) {
                    if (biome.func_201856_r() == cat && include) {
                        b.add(biome.getRegistryName());
                    }
                    if (include || biome.func_201856_r() == cat || biome.func_201856_r() == Biome.Category.NETHER || biome.func_201856_r() == Biome.Category.THEEND) continue;
                    b.add(biome.getRegistryName());
                }
                continue;
            }
            if (include || biome.func_201856_r() == Biome.Category.NETHER || biome.func_201856_r() == Biome.Category.THEEND) continue;
            b.add(biome.getRegistryName());
        }
        return b;
    }

    private static List<AbstractMap.SimpleEntry<ConfiguredFeature<?, ?>, List<ResourceLocation>>> flatBedrock() {
        if (((Boolean)WGConfig.MISC.FLAT_BEDROCK.get()).booleanValue()) {
            return Arrays.asList(new AbstractMap.SimpleEntry(RankineFeatures.FLAT_BEDROCK, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)), new AbstractMap.SimpleEntry(RankineFeatures.FLAT_BEDROCK_NETHER, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
        }
        return Collections.emptyList();
    }

    private static List<AbstractMap.SimpleEntry<ConfiguredFeature<?, ?>, List<ResourceLocation>>> getUndergroundOreFeatures() {
        ArrayList OverworldFeatures = new ArrayList();
        if (((Boolean)WGConfig.MISC.VANILLA_ORES.get()).booleanValue()) {
            OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.GRAVEL_DISKS, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.OCEAN), false)));
            OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.SAND_DISKS, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.OCEAN), false)));
            OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.CLAY_DISKS, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.OCEAN), false)));
        }
        if (((Boolean)WGConfig.MISC.ALLUVIUM_GEN.get()).booleanValue()) {
            OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ALLUVIUM, OreGen.getBiomeNamesFromCategory(Arrays.asList(Biome.Category.OCEAN, Biome.Category.RIVER), true)));
        }
        if (((Boolean)WGConfig.MISC.EVAPORITE_GEN.get()).booleanValue()) {
            OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_EVAPORITE, OreGen.getBiomeNamesFromCategory(Arrays.asList(Biome.Category.OCEAN, Biome.Category.BEACH), false)));
        }
        if (((Boolean)WGConfig.MISC.MUD_GEN.get()).booleanValue()) {
            OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.MUD_FEATURE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
        }
        if (((Boolean)WGConfig.MISC.FIRE_CLAY_GEN.get()).booleanValue()) {
            OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.FIRE_CLAY, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
        }
        if ((Integer)WGConfig.LAYERS.OVERWORLD_STONE_LAYERS.get() != 0) {
            OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.OVERWORLD_STONE_GEN, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
            OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ANDESITE_VAR, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.EXTREME_HILLS), true)));
        }
        OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_INTRUSION, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
        OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.SILL_PHOSPHORITE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
        OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.SILL_IRONSTONE, OreGen.getBiomeNamesFromCategory(Arrays.asList(Biome.Category.MESA, Biome.Category.DESERT), true)));
        if (((Boolean)WGConfig.MISC.TUFF_GEN.get()).booleanValue()) {
            OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ANDESITIC_TUFF, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
            OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.RHYOLITIC_TUFF, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
            OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.THOLEIITIC_BASALTIC_TUFF, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
            OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.DACITIC_TUFF, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
        }
        OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NODULE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
        if (((Boolean)WGConfig.ORES.RANKINE_ORES_O.get()).booleanValue()) {
            if (((List)WGConfig.ORES.NATIVE_COPPER_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.NATIVE_COPPER_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_COPPER_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_COPPER_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_COPPER_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_COPPER_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_TIN_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.NATIVE_TIN_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TIN_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TIN_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_TIN_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TIN_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_GOLD_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.NATIVE_GOLD_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GOLD_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GOLD_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_GOLD_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GOLD_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_ALUMINUM_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.NATIVE_ALUMINUM_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ALUMINUM_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ALUMINUM_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_ALUMINUM_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ALUMINUM_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_LEAD_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.NATIVE_LEAD_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_LEAD_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_LEAD_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_LEAD_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_LEAD_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_SILVER_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.NATIVE_SILVER_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SILVER_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SILVER_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_SILVER_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SILVER_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_ARSENIC_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.NATIVE_ARSENIC_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ARSENIC_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ARSENIC_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_ARSENIC_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ARSENIC_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_BISMUTH_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.NATIVE_BISMUTH_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_BISMUTH_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_BISMUTH_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_BISMUTH_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_BISMUTH_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_SULFUR_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.NATIVE_SULFUR_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SULFUR_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SULFUR_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_SULFUR_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SULFUR_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_GALLIUM_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.NATIVE_GALLIUM_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GALLIUM_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GALLIUM_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_GALLIUM_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GALLIUM_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_INDIUM_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.NATIVE_INDIUM_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_INDIUM_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_INDIUM_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_INDIUM_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_INDIUM_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_TELLURIUM_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.NATIVE_TELLURIUM_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TELLURIUM_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TELLURIUM_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_TELLURIUM_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TELLURIUM_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_SELENIUM_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.NATIVE_SELENIUM_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SELENIUM_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SELENIUM_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_SELENIUM_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SELENIUM_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.MALACHITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.MALACHITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MALACHITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MALACHITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.MALACHITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MALACHITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.CASSITERITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.CASSITERITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CASSITERITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CASSITERITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.CASSITERITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CASSITERITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.BAUXITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.BAUXITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BAUXITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BAUXITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.BAUXITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BAUXITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.SPHALERITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.SPHALERITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPHALERITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPHALERITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.SPHALERITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPHALERITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.CINNABAR_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.CINNABAR_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CINNABAR_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CINNABAR_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.CINNABAR_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CINNABAR_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.MAGNETITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.MAGNETITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNETITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNETITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.MAGNETITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNETITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.PENTLANDITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.PENTLANDITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PENTLANDITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PENTLANDITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.PENTLANDITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PENTLANDITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.MAGNESITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.MAGNESITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNESITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNESITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.MAGNESITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNESITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.GALENA_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.GALENA_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GALENA_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GALENA_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.GALENA_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GALENA_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.VANADINITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.VANADINITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_VANADINITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_VANADINITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.VANADINITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_VANADINITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.BISMUTHINITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.BISMUTHINITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BISMUTHINITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BISMUTHINITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.BISMUTHINITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BISMUTHINITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.ACANTHITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.ACANTHITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ACANTHITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ACANTHITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.ACANTHITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ACANTHITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.PYROLUSITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.PYROLUSITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYROLUSITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYROLUSITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.PYROLUSITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYROLUSITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.CHROMITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.CHROMITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CHROMITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CHROMITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.CHROMITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CHROMITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.MOLYBDENITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.MOLYBDENITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOLYBDENITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOLYBDENITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.MOLYBDENITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOLYBDENITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.ILMENITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.ILMENITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ILMENITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ILMENITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.ILMENITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ILMENITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.COLUMBITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.COLUMBITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COLUMBITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COLUMBITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.COLUMBITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COLUMBITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.WOLFRAMITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.WOLFRAMITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_WOLFRAMITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_WOLFRAMITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.WOLFRAMITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_WOLFRAMITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.TANTALITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.TANTALITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TANTALITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TANTALITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.TANTALITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TANTALITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.PLUMBAGO_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.PLUMBAGO_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PLUMBAGO_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PLUMBAGO_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.PLUMBAGO_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PLUMBAGO_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.MOISSANITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.MOISSANITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOISSANITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOISSANITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.MOISSANITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOISSANITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.SPERRYLITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.SPERRYLITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPERRYLITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPERRYLITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.SPERRYLITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPERRYLITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.LIGNITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.LIGNITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LIGNITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LIGNITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.LIGNITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LIGNITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.SUBBITUMINOUS_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.SUBBITUMINOUS_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SUBBITUMINOUS_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SUBBITUMINOUS_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.SUBBITUMINOUS_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SUBBITUMINOUS_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.BITUMINOUS_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.BITUMINOUS_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BITUMINOUS_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BITUMINOUS_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.BITUMINOUS_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BITUMINOUS_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.ANTHRACITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.ANTHRACITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTHRACITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTHRACITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.ANTHRACITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTHRACITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.LAZURITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.LAZURITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LAZURITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LAZURITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.LAZURITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LAZURITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.DIAMOND_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.DIAMOND_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_DIAMOND_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_DIAMOND_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.DIAMOND_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_DIAMOND_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.GREENOCKITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.GREENOCKITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GREENOCKITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GREENOCKITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.GREENOCKITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GREENOCKITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.EMERALD_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.EMERALD_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_EMERALD_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_EMERALD_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.EMERALD_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_EMERALD_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.AQUAMARINE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.AQUAMARINE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_AQUAMARINE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_AQUAMARINE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.AQUAMARINE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_AQUAMARINE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.QUARTZ_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.QUARTZ_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_QUARTZ_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_QUARTZ_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.QUARTZ_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_QUARTZ_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.OPAL_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.OPAL_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_OPAL_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_OPAL_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.OPAL_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_OPAL_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.MAJORITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.MAJORITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAJORITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAJORITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.MAJORITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAJORITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.FLUORITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.FLUORITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_FLUORITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_FLUORITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.FLUORITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_FLUORITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.URANINITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.URANINITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_URANINITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_URANINITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.URANINITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_URANINITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.STIBNITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.STIBNITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_STIBNITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_STIBNITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.STIBNITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_STIBNITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.XENOTIME_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.XENOTIME_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_XENOTIME_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_XENOTIME_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.XENOTIME_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_XENOTIME_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.HALITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.HALITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_HALITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_HALITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.HALITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_HALITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.PINK_HALITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.PINK_HALITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PINK_HALITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PINK_HALITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.PINK_HALITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PINK_HALITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.INTERSPINIFEX_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.INTERSPINIFEX_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_INTERSPINIFEX_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_INTERSPINIFEX_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.INTERSPINIFEX_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_INTERSPINIFEX_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.PETALITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.PETALITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PETALITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PETALITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.PETALITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PETALITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.COBALTITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.COBALTITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COBALTITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COBALTITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.COBALTITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COBALTITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.CRYOLITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.CRYOLITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CRYOLITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CRYOLITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.CRYOLITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CRYOLITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.PYRITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.PYRITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYRITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYRITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.PYRITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYRITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.CELESTINE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.CELESTINE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CELESTINE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CELESTINE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.CELESTINE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CELESTINE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.MONAZITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.MONAZITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MONAZITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MONAZITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.MONAZITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MONAZITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.KAMACITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.KAMACITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_KAMACITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_KAMACITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.KAMACITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_KAMACITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.ANTITAENITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.ANTITAENITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTITAENITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTITAENITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.ANTITAENITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTITAENITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.TAENITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.TAENITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TAENITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TAENITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.TAENITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TAENITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.TETRATAENITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.TETRATAENITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TETRATAENITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TETRATAENITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.TETRATAENITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TETRATAENITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
            if (((List)WGConfig.ORES.LONSDALEITE_ORE_DIMENSION_LIST.get()).contains("overworld")) {
                if (((Boolean)WGConfig.ORES.LONSDALEITE_ORE_GENTYPE.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LONSDALEITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                } else {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LONSDALEITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
                if (((Boolean)WGConfig.ORES.LONSDALEITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    OverworldFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LONSDALEITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.emptyList(), false)));
                }
            }
        }
        return OverworldFeatures;
    }

    private static List<AbstractMap.SimpleEntry<ConfiguredFeature<?, ?>, List<ResourceLocation>>> getNetherOreFeatures() {
        ArrayList NetherFeatures = new ArrayList();
        NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.NETHER_ORE_INTRUSION, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
        if ((Integer)WGConfig.LAYERS.NETHER_STONE_LAYERS.get() != 0) {
            NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.NETHER_STONE_GEN, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
        }
        if (((Boolean)WGConfig.ORES.RANKINE_ORES_N.get()).booleanValue()) {
            if (((List)WGConfig.ORES.NATIVE_COPPER_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.NATIVE_COPPER_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_COPPER_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_COPPER_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_COPPER_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_COPPER_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_TIN_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.NATIVE_TIN_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TIN_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TIN_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_TIN_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TIN_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_GOLD_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.NATIVE_GOLD_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GOLD_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GOLD_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_GOLD_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GOLD_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_ALUMINUM_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.NATIVE_ALUMINUM_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ALUMINUM_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ALUMINUM_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_ALUMINUM_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ALUMINUM_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_LEAD_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.NATIVE_LEAD_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_LEAD_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_LEAD_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_LEAD_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_LEAD_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_SILVER_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.NATIVE_SILVER_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SILVER_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SILVER_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_SILVER_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SILVER_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_ARSENIC_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.NATIVE_ARSENIC_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ARSENIC_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ARSENIC_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_ARSENIC_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ARSENIC_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_BISMUTH_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.NATIVE_BISMUTH_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_BISMUTH_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_BISMUTH_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_BISMUTH_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_BISMUTH_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_SULFUR_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.NATIVE_SULFUR_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SULFUR_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SULFUR_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_SULFUR_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SULFUR_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_GALLIUM_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.NATIVE_GALLIUM_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GALLIUM_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GALLIUM_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_GALLIUM_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GALLIUM_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_INDIUM_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.NATIVE_INDIUM_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_INDIUM_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_INDIUM_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_INDIUM_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_INDIUM_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_TELLURIUM_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.NATIVE_TELLURIUM_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TELLURIUM_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TELLURIUM_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_TELLURIUM_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TELLURIUM_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_SELENIUM_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.NATIVE_SELENIUM_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SELENIUM_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SELENIUM_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_SELENIUM_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SELENIUM_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.MALACHITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.MALACHITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MALACHITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MALACHITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.MALACHITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MALACHITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.CASSITERITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.CASSITERITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CASSITERITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CASSITERITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.CASSITERITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CASSITERITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.BAUXITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.BAUXITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BAUXITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BAUXITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.BAUXITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BAUXITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.SPHALERITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.SPHALERITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPHALERITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPHALERITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.SPHALERITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPHALERITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.CINNABAR_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.CINNABAR_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CINNABAR_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CINNABAR_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.CINNABAR_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CINNABAR_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.MAGNETITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.MAGNETITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNETITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNETITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.MAGNETITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNETITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.PENTLANDITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.PENTLANDITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PENTLANDITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PENTLANDITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.PENTLANDITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PENTLANDITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.MAGNESITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.MAGNESITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNESITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNESITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.MAGNESITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNESITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.GALENA_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.GALENA_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GALENA_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GALENA_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.GALENA_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GALENA_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.VANADINITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.VANADINITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_VANADINITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_VANADINITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.VANADINITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_VANADINITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.BISMUTHINITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.BISMUTHINITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BISMUTHINITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BISMUTHINITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.BISMUTHINITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BISMUTHINITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.ACANTHITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.ACANTHITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ACANTHITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ACANTHITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.ACANTHITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ACANTHITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.PYROLUSITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.PYROLUSITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYROLUSITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYROLUSITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.PYROLUSITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYROLUSITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.CHROMITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.CHROMITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CHROMITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CHROMITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.CHROMITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CHROMITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.MOLYBDENITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.MOLYBDENITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOLYBDENITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOLYBDENITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.MOLYBDENITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOLYBDENITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.ILMENITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.ILMENITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ILMENITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ILMENITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.ILMENITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ILMENITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.COLUMBITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.COLUMBITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COLUMBITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COLUMBITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.COLUMBITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COLUMBITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.WOLFRAMITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.WOLFRAMITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_WOLFRAMITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_WOLFRAMITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.WOLFRAMITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_WOLFRAMITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.TANTALITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.TANTALITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TANTALITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TANTALITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.TANTALITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TANTALITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.PLUMBAGO_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.PLUMBAGO_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PLUMBAGO_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PLUMBAGO_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.PLUMBAGO_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PLUMBAGO_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.MOISSANITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.MOISSANITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOISSANITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOISSANITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.MOISSANITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOISSANITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.SPERRYLITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.SPERRYLITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPERRYLITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPERRYLITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.SPERRYLITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPERRYLITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.LIGNITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.LIGNITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LIGNITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LIGNITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.LIGNITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LIGNITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.SUBBITUMINOUS_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.SUBBITUMINOUS_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SUBBITUMINOUS_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SUBBITUMINOUS_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.SUBBITUMINOUS_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SUBBITUMINOUS_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.BITUMINOUS_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.BITUMINOUS_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BITUMINOUS_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BITUMINOUS_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.BITUMINOUS_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BITUMINOUS_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.ANTHRACITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.ANTHRACITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTHRACITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTHRACITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.ANTHRACITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTHRACITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.LAZURITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.LAZURITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LAZURITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LAZURITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.LAZURITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LAZURITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.DIAMOND_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.DIAMOND_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_DIAMOND_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_DIAMOND_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.DIAMOND_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_DIAMOND_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.GREENOCKITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.GREENOCKITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GREENOCKITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GREENOCKITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.GREENOCKITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GREENOCKITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.EMERALD_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.EMERALD_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_EMERALD_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_EMERALD_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.EMERALD_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_EMERALD_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.AQUAMARINE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.AQUAMARINE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_AQUAMARINE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_AQUAMARINE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.AQUAMARINE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_AQUAMARINE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.QUARTZ_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.QUARTZ_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_QUARTZ_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_QUARTZ_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.QUARTZ_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_QUARTZ_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.OPAL_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.OPAL_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_OPAL_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_OPAL_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.OPAL_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_OPAL_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.MAJORITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.MAJORITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAJORITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAJORITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.MAJORITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAJORITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.FLUORITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.FLUORITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_FLUORITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_FLUORITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.FLUORITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_FLUORITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.URANINITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.URANINITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_URANINITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_URANINITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.URANINITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_URANINITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.STIBNITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.STIBNITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_STIBNITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_STIBNITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.STIBNITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_STIBNITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.XENOTIME_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.XENOTIME_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_XENOTIME_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_XENOTIME_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.XENOTIME_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_XENOTIME_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.HALITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.HALITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_HALITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_HALITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.HALITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_HALITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.PINK_HALITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.PINK_HALITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PINK_HALITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PINK_HALITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.PINK_HALITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PINK_HALITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.INTERSPINIFEX_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.INTERSPINIFEX_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_INTERSPINIFEX_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_INTERSPINIFEX_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.INTERSPINIFEX_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_INTERSPINIFEX_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.PETALITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.PETALITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PETALITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PETALITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.PETALITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PETALITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.COBALTITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.COBALTITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COBALTITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COBALTITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.COBALTITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COBALTITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.CRYOLITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.CRYOLITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CRYOLITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CRYOLITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.CRYOLITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CRYOLITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.PYRITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.PYRITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYRITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYRITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.PYRITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYRITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.CELESTINE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.CELESTINE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CELESTINE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CELESTINE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.CELESTINE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CELESTINE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.MONAZITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.MONAZITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MONAZITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MONAZITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.MONAZITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MONAZITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.KAMACITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.KAMACITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_KAMACITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_KAMACITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.KAMACITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_KAMACITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.ANTITAENITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.ANTITAENITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTITAENITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTITAENITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.ANTITAENITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTITAENITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.TAENITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.TAENITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TAENITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TAENITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.TAENITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TAENITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.TETRATAENITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.TETRATAENITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TETRATAENITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TETRATAENITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.TETRATAENITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TETRATAENITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
            if (((List)WGConfig.ORES.LONSDALEITE_ORE_DIMENSION_LIST.get()).contains("nether")) {
                if (((Boolean)WGConfig.ORES.LONSDALEITE_ORE_GENTYPE.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LONSDALEITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                } else {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LONSDALEITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
                if (((Boolean)WGConfig.ORES.LONSDALEITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    NetherFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LONSDALEITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.NETHER), true)));
                }
            }
        }
        return NetherFeatures;
    }

    private static List<AbstractMap.SimpleEntry<ConfiguredFeature<?, ?>, List<ResourceLocation>>> getEndOreFeatures() {
        ArrayList EndFeatures = new ArrayList();
        if ((Integer)WGConfig.LAYERS.END_STONE_LAYERS.get() != 0) {
            EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.END_STONE_GEN, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
        }
        if (((Boolean)WGConfig.ORES.RANKINE_ORES_E.get()).booleanValue()) {
            if (((List)WGConfig.ORES.NATIVE_COPPER_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.NATIVE_COPPER_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_COPPER_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_COPPER_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_COPPER_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_COPPER_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_TIN_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.NATIVE_TIN_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TIN_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TIN_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_TIN_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TIN_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_GOLD_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.NATIVE_GOLD_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GOLD_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GOLD_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_GOLD_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GOLD_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_ALUMINUM_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.NATIVE_ALUMINUM_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ALUMINUM_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ALUMINUM_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_ALUMINUM_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ALUMINUM_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_LEAD_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.NATIVE_LEAD_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_LEAD_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_LEAD_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_LEAD_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_LEAD_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_SILVER_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.NATIVE_SILVER_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SILVER_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SILVER_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_SILVER_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SILVER_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_ARSENIC_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.NATIVE_ARSENIC_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ARSENIC_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ARSENIC_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_ARSENIC_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_ARSENIC_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_BISMUTH_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.NATIVE_BISMUTH_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_BISMUTH_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_BISMUTH_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_BISMUTH_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_BISMUTH_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_SULFUR_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.NATIVE_SULFUR_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SULFUR_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SULFUR_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_SULFUR_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SULFUR_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_GALLIUM_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.NATIVE_GALLIUM_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GALLIUM_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GALLIUM_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_GALLIUM_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_GALLIUM_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_INDIUM_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.NATIVE_INDIUM_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_INDIUM_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_INDIUM_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_INDIUM_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_INDIUM_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_TELLURIUM_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.NATIVE_TELLURIUM_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TELLURIUM_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TELLURIUM_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_TELLURIUM_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_TELLURIUM_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.NATIVE_SELENIUM_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.NATIVE_SELENIUM_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SELENIUM_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SELENIUM_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.NATIVE_SELENIUM_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_NATIVE_SELENIUM_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.MALACHITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.MALACHITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MALACHITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MALACHITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.MALACHITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MALACHITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.CASSITERITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.CASSITERITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CASSITERITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CASSITERITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.CASSITERITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CASSITERITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.BAUXITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.BAUXITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BAUXITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BAUXITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.BAUXITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BAUXITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.SPHALERITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.SPHALERITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPHALERITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPHALERITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.SPHALERITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPHALERITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.CINNABAR_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.CINNABAR_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CINNABAR_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CINNABAR_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.CINNABAR_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CINNABAR_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.MAGNETITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.MAGNETITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNETITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNETITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.MAGNETITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNETITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.PENTLANDITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.PENTLANDITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PENTLANDITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PENTLANDITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.PENTLANDITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PENTLANDITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.MAGNESITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.MAGNESITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNESITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNESITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.MAGNESITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAGNESITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.GALENA_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.GALENA_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GALENA_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GALENA_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.GALENA_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GALENA_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.VANADINITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.VANADINITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_VANADINITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_VANADINITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.VANADINITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_VANADINITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.BISMUTHINITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.BISMUTHINITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BISMUTHINITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BISMUTHINITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.BISMUTHINITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BISMUTHINITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.ACANTHITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.ACANTHITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ACANTHITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ACANTHITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.ACANTHITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ACANTHITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.PYROLUSITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.PYROLUSITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYROLUSITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYROLUSITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.PYROLUSITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYROLUSITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.CHROMITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.CHROMITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CHROMITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CHROMITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.CHROMITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CHROMITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.MOLYBDENITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.MOLYBDENITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOLYBDENITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOLYBDENITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.MOLYBDENITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOLYBDENITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.ILMENITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.ILMENITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ILMENITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ILMENITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.ILMENITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ILMENITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.COLUMBITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.COLUMBITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COLUMBITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COLUMBITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.COLUMBITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COLUMBITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.WOLFRAMITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.WOLFRAMITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_WOLFRAMITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_WOLFRAMITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.WOLFRAMITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_WOLFRAMITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.TANTALITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.TANTALITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TANTALITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TANTALITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.TANTALITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TANTALITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.PLUMBAGO_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.PLUMBAGO_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PLUMBAGO_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PLUMBAGO_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.PLUMBAGO_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PLUMBAGO_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.MOISSANITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.MOISSANITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOISSANITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOISSANITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.MOISSANITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MOISSANITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.SPERRYLITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.SPERRYLITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPERRYLITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPERRYLITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.SPERRYLITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SPERRYLITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.LIGNITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.LIGNITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LIGNITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LIGNITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.LIGNITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LIGNITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.SUBBITUMINOUS_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.SUBBITUMINOUS_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SUBBITUMINOUS_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SUBBITUMINOUS_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.SUBBITUMINOUS_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_SUBBITUMINOUS_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.BITUMINOUS_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.BITUMINOUS_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BITUMINOUS_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BITUMINOUS_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.BITUMINOUS_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_BITUMINOUS_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.ANTHRACITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.ANTHRACITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTHRACITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTHRACITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.ANTHRACITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTHRACITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.LAZURITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.LAZURITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LAZURITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LAZURITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.LAZURITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LAZURITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.DIAMOND_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.DIAMOND_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_DIAMOND_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_DIAMOND_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.DIAMOND_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_DIAMOND_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.GREENOCKITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.GREENOCKITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GREENOCKITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GREENOCKITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.GREENOCKITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_GREENOCKITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.EMERALD_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.EMERALD_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_EMERALD_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_EMERALD_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.EMERALD_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_EMERALD_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.AQUAMARINE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.AQUAMARINE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_AQUAMARINE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_AQUAMARINE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.AQUAMARINE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_AQUAMARINE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.QUARTZ_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.QUARTZ_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_QUARTZ_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_QUARTZ_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.QUARTZ_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_QUARTZ_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.OPAL_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.OPAL_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_OPAL_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_OPAL_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.OPAL_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_OPAL_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.MAJORITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.MAJORITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAJORITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAJORITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.MAJORITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MAJORITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.FLUORITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.FLUORITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_FLUORITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_FLUORITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.FLUORITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_FLUORITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.URANINITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.URANINITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_URANINITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_URANINITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.URANINITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_URANINITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.STIBNITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.STIBNITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_STIBNITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_STIBNITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.STIBNITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_STIBNITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.XENOTIME_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.XENOTIME_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_XENOTIME_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_XENOTIME_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.XENOTIME_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_XENOTIME_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.HALITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.HALITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_HALITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_HALITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.HALITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_HALITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.PINK_HALITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.PINK_HALITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PINK_HALITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PINK_HALITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.PINK_HALITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PINK_HALITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.INTERSPINIFEX_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.INTERSPINIFEX_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_INTERSPINIFEX_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_INTERSPINIFEX_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.INTERSPINIFEX_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_INTERSPINIFEX_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.PETALITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.PETALITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PETALITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PETALITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.PETALITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PETALITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.COBALTITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.COBALTITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COBALTITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COBALTITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.COBALTITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_COBALTITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.CRYOLITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.CRYOLITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CRYOLITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CRYOLITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.CRYOLITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CRYOLITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.PYRITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.PYRITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYRITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYRITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.PYRITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_PYRITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.CELESTINE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.CELESTINE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CELESTINE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CELESTINE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.CELESTINE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_CELESTINE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.MONAZITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.MONAZITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MONAZITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MONAZITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.MONAZITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_MONAZITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.KAMACITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.KAMACITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_KAMACITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_KAMACITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.KAMACITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_KAMACITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.ANTITAENITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.ANTITAENITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTITAENITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTITAENITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.ANTITAENITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_ANTITAENITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.TAENITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.TAENITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TAENITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TAENITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.TAENITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TAENITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.TETRATAENITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.TETRATAENITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TETRATAENITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TETRATAENITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.TETRATAENITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_TETRATAENITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
            if (((List)WGConfig.ORES.LONSDALEITE_ORE_DIMENSION_LIST.get()).contains("end")) {
                if (((Boolean)WGConfig.ORES.LONSDALEITE_ORE_GENTYPE.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LONSDALEITE_CHANCE, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                } else {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LONSDALEITE_COUNT, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
                if (((Boolean)WGConfig.ORES.LONSDALEITE_ORE_MEGA_GEN.get()).booleanValue()) {
                    EndFeatures.add(new AbstractMap.SimpleEntry(RankineFeatures.ORE_LONSDALEITE_MEGA, OreGen.getBiomeNamesFromCategory(Collections.singletonList(Biome.Category.THEEND), true)));
                }
            }
        }
        return EndFeatures;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void removeVanillaFeatures(BiomeLoadingEvent event) {
        if (event.getName() != null && ((Boolean)WGConfig.MISC.VANILLA_ORES.get()).booleanValue()) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_ORES).removeIf(featureSupplier -> featureSupplier.toString().contains("net.minecraft.util.registry.WorldSettingsImport"));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void addOreGenFeatures(BiomeLoadingEvent event) {
        block8: {
            if (event.getName() == null) break block8;
            if (event.getCategory() != Biome.Category.NETHER && event.getCategory() != Biome.Category.THEEND) {
                List<AbstractMap.SimpleEntry<ConfiguredFeature<?, ?>, List<ResourceLocation>>> bedrock = OreGen.flatBedrock();
                for (AbstractMap.SimpleEntry<ConfiguredFeature<?, ?>, List<ResourceLocation>> entry : bedrock) {
                    if (!entry.getValue().contains(event.getName())) continue;
                    event.getGeneration().func_242510_a(GenerationStage.Decoration.UNDERGROUND_ORES.ordinal(), entry::getKey);
                }
                List<AbstractMap.SimpleEntry<ConfiguredFeature<?, ?>, List<ResourceLocation>>> ores = OreGen.getUndergroundOreFeatures();
                for (AbstractMap.SimpleEntry simpleEntry : ores) {
                    if (!((List)simpleEntry.getValue()).contains(event.getName())) continue;
                    event.getGeneration().func_242510_a(GenerationStage.Decoration.UNDERGROUND_ORES.ordinal(), simpleEntry::getKey);
                }
            } else if (event.getCategory() == Biome.Category.NETHER) {
                List<AbstractMap.SimpleEntry<ConfiguredFeature<?, ?>, List<ResourceLocation>>> netherOreFeatures = OreGen.getNetherOreFeatures();
                for (AbstractMap.SimpleEntry<ConfiguredFeature<?, ?>, List<ResourceLocation>> entry : netherOreFeatures) {
                    if (!entry.getValue().contains(event.getName())) continue;
                    event.getGeneration().func_242510_a(GenerationStage.Decoration.UNDERGROUND_ORES.ordinal(), entry::getKey);
                }
            } else {
                List<AbstractMap.SimpleEntry<ConfiguredFeature<?, ?>, List<ResourceLocation>>> endOreFeatures = OreGen.getEndOreFeatures();
                for (AbstractMap.SimpleEntry<ConfiguredFeature<?, ?>, List<ResourceLocation>> entry : endOreFeatures) {
                    if (!entry.getValue().contains(event.getName())) continue;
                    event.getGeneration().func_242510_a(GenerationStage.Decoration.UNDERGROUND_ORES.ordinal(), entry::getKey);
                }
            }
        }
    }
}

