/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.world.gen.feature;

import com.cannolicatfish.rankine.init.WGConfig;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.registries.ForgeRegistries;

public class EndStoneReplacerFeature
extends Feature<NoFeatureConfig> {
    public static final int NOISE_SCALE = (Integer)WGConfig.LAYERS.NOISE_SCALE.get();
    public static final int NOISE_OFFSET = (Integer)WGConfig.LAYERS.NOISE_OFFSET.get();

    public EndStoneReplacerFeature(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        IChunk chunk = reader.func_217349_x(pos);
        int startX = chunk.func_76632_l().func_180334_c();
        int startZ = chunk.func_76632_l().func_180333_d();
        int endX = chunk.func_76632_l().func_180332_e();
        int endZ = chunk.func_76632_l().func_180330_f();
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                EndStoneReplacerFeature.layering((List)WGConfig.LAYERS.END_STONE_LIST.get(), (Integer)WGConfig.LAYERS.END_HEIGHT.get(), reader, x, z, 127);
            }
        }
        return true;
    }

    private static int getLayerHeights(int x, int z, int index, int height) {
        double noise = Biome.field_180281_af.func_215464_a((double)x / (double)NOISE_SCALE + (double)(index * NOISE_OFFSET), (double)z / (double)NOISE_SCALE + (double)(index * NOISE_OFFSET), false);
        return height + (int)Math.round(noise / 0.25);
    }

    private static void layering(List<String> blockList, int avgHeight, ISeedReader reader, int x, int z, int endY) {
        int stoneCount = blockList.size();
        for (int i = 0; i < stoneCount; ++i) {
            if (i == 0) {
                EndStoneReplacerFeature.replaceStone(reader, x, z, 0, EndStoneReplacerFeature.getLayerHeights(x, z, i, avgHeight / stoneCount * (i + 1)), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockList.get(i)))).func_176223_P());
                continue;
            }
            if (i < stoneCount - 1) {
                EndStoneReplacerFeature.replaceStone(reader, x, z, EndStoneReplacerFeature.getLayerHeights(x, z, i - 1, avgHeight / stoneCount * i), EndStoneReplacerFeature.getLayerHeights(x, z, i, avgHeight / stoneCount * (i + 1)), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockList.get(i)))).func_176223_P());
                continue;
            }
            EndStoneReplacerFeature.replaceStone(reader, x, z, EndStoneReplacerFeature.getLayerHeights(x, z, i - 1, avgHeight / stoneCount * i), endY, ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockList.get(i)))).func_176223_P());
        }
    }

    private static void replaceStone(ISeedReader reader, int x, int z, int StartY, int EndY, BlockState Block2) {
        block4: for (int y = StartY; y <= EndY; ++y) {
            switch ((Integer)WGConfig.LAYERS.END_STONE_LAYERS.get()) {
                case 1: {
                    if (reader.func_180495_p(new BlockPos(x, y, z)).func_177230_c().func_176223_P() == Blocks.field_150377_bs.func_176223_P()) {
                        reader.func_180501_a(new BlockPos(x, y, z), Block2, 2);
                    }
                }
                case 2: {
                    if (!reader.func_180495_p(new BlockPos(x, y, z)).func_177230_c().getTags().contains(new ResourceLocation("forge:base_stone_end"))) continue block4;
                    reader.func_180501_a(new BlockPos(x, y, z), Block2, 2);
                }
            }
        }
    }
}

