/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.world.gen.feature;

import com.cannolicatfish.rankine.blocks.RankineOreBlock;
import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.init.WGConfig;
import com.cannolicatfish.rankine.util.WeightedCollection;
import com.cannolicatfish.rankine.world.gen.feature.ReplacerFeatureConfig;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.registries.ForgeRegistries;

public class IntrusionFeature
extends Feature<ReplacerFeatureConfig> {
    public IntrusionFeature(Codec<ReplacerFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public static WeightedCollection<BlockState> intrusionCollection() {
        WeightedCollection<BlockState> col = new WeightedCollection<BlockState>();
        for (int i = 0; i < ((List)WGConfig.INTRUSIONS.OVERWORLD_INTRUSION_LIST.get()).size(); i += 2) {
            try {
                col.add(Integer.parseInt((String)((List)WGConfig.INTRUSIONS.OVERWORLD_INTRUSION_LIST.get()).get(i + 1)), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)((List)WGConfig.INTRUSIONS.OVERWORLD_INTRUSION_LIST.get()).get(i)))).func_176223_P());
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return col;
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, ReplacerFeatureConfig config) {
        float CHANCE = rand.nextFloat();
        int radius = (Integer)WGConfig.INTRUSIONS.OVERWORLD_INTRUSION_RADIUS.get() - rand.nextInt(3);
        int startY = 0;
        int endY = reader.func_201676_a(Heightmap.Type.OCEAN_FLOOR, pos.func_177958_n(), pos.func_177952_p());
        if ((double)CHANCE < (Double)WGConfig.INTRUSIONS.OVERWORLD_INTRUSION_CHANCE.get()) {
            BlockState INTRUSION = IntrusionFeature.intrusionCollection().getRandomElement();
            int x1 = rand.nextInt(radius) - radius / 2;
            int x2 = rand.nextInt(radius) - radius / 2;
            int x3 = rand.nextInt(radius) - radius / 2;
            int x4 = rand.nextInt(radius) - radius / 2;
            int z1 = rand.nextInt(radius) - radius / 2;
            int z2 = rand.nextInt(radius) - radius / 2;
            int z3 = rand.nextInt(radius) - radius / 2;
            int z4 = rand.nextInt(radius) - radius / 2;
            for (int y = startY; y <= endY; ++y) {
                for (BlockPos b : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-3 * radius, y, -3 * radius), (BlockPos)pos.func_177982_a(3 * radius, y, 3 * radius))) {
                    if (!(b.func_177951_i((Vector3i)new BlockPos(pos.func_177958_n() + x1, y, pos.func_177952_p() + z1)) <= Math.pow((double)radius + 0.5, 2.0) || b.func_177951_i((Vector3i)new BlockPos(pos.func_177958_n() + x2, y, pos.func_177952_p() + z2)) <= Math.pow((double)radius + 0.5, 2.0) || b.func_177951_i((Vector3i)new BlockPos(pos.func_177958_n() + x3, y, pos.func_177952_p() + z3)) <= Math.pow((double)radius + 0.5, 2.0))) {
                        BlockPos blockPos = new BlockPos(pos.func_177958_n() + x4, y, pos.func_177952_p() + z4);
                        if (!(b.func_177951_i((Vector3i)blockPos) <= Math.pow((double)radius + 0.5, 2.0))) continue;
                    }
                    if (!reader.func_180495_p(b).func_177230_c().getTags().contains(new ResourceLocation("rankine:intrusion_passable"))) continue;
                    float chance = rand.nextFloat();
                    if (INTRUSION == ((Block)RankineBlocks.KIMBERLITE.get()).func_176223_P()) {
                        if (chance < ((Double)WGConfig.INTRUSIONS.ILMENITE_CHANCE.get()).floatValue() && y <= 50) {
                            reader.func_180501_a(b, (BlockState)((Block)RankineBlocks.ILMENITE_ORE.get()).func_176223_P().func_206870_a((Property)RankineOreBlock.TYPE, (Comparable)Integer.valueOf(26)), 4);
                            continue;
                        }
                        if (chance < ((Double)WGConfig.INTRUSIONS.DIAMON_CHANCE.get()).floatValue() && y <= 50) {
                            reader.func_180501_a(b, (BlockState)((Block)RankineBlocks.DIAMOND_ORE.get()).func_176223_P().func_206870_a((Property)RankineOreBlock.TYPE, (Comparable)Integer.valueOf(26)), 4);
                            continue;
                        }
                        reader.func_180501_a(b, INTRUSION, 4);
                        continue;
                    }
                    if (INTRUSION == ((Block)RankineBlocks.PEGMATITE.get()).func_176223_P()) {
                        if (chance < ((Double)WGConfig.INTRUSIONS.PETALITE_CHANCE.get()).floatValue() && y <= 50) {
                            reader.func_180501_a(b, (BlockState)((Block)RankineBlocks.PETALITE_ORE.get()).func_176223_P().func_206870_a((Property)RankineOreBlock.TYPE, (Comparable)Integer.valueOf(23)), 4);
                            continue;
                        }
                        reader.func_180501_a(b, INTRUSION, 4);
                        continue;
                    }
                    reader.func_180501_a(b, INTRUSION, 4);
                }
                if ((double)rand.nextFloat() < (Double)WGConfig.INTRUSIONS.OVERWORLD_INTRUSION_SHRINK.get()) {
                    x1 += rand.nextInt(3) - 1;
                    x2 += rand.nextInt(3) - 1;
                    x3 += rand.nextInt(3) - 1;
                    x4 += rand.nextInt(3) - 1;
                    z1 += rand.nextInt(3) - 1;
                    z2 += rand.nextInt(3) - 1;
                    z3 += rand.nextInt(3) - 1;
                    z4 += rand.nextInt(3) - 1;
                }
                if (!((double)rand.nextFloat() < 0.08) || --radius > 0) continue;
                return true;
            }
        }
        return true;
    }
}

