/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.world.gen.feature;

import com.cannolicatfish.rankine.init.WGConfig;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.registries.ForgeRegistries;

public class StoneReplacerFeature
extends Feature<NoFeatureConfig> {
    public static final int NOISE_SCALE = (Integer)WGConfig.LAYERS.NOISE_SCALE.get();
    public static final int NOISE_OFFSET = (Integer)WGConfig.LAYERS.NOISE_OFFSET.get();

    public StoneReplacerFeature(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        IChunk chunk = reader.func_217349_x(pos);
        int startX = chunk.func_76632_l().func_180334_c();
        int startZ = chunk.func_76632_l().func_180333_d();
        int endX = chunk.func_76632_l().func_180332_e();
        int endZ = chunk.func_76632_l().func_180330_f();
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                int endY = reader.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z);
                if (reader.func_226691_t_(new BlockPos(x, 0, z)).func_201856_r() == Biome.Category.OCEAN && !((List)WGConfig.LAYERS.OCEAN_STONE_LIST.get()).isEmpty()) {
                    StoneReplacerFeature.layering((List)WGConfig.LAYERS.OCEAN_STONE_LIST.get(), (Integer)WGConfig.LAYERS.OCEAN_HEIGHT.get(), reader, x, z, endY);
                    continue;
                }
                if (reader.func_226691_t_(new BlockPos(x, 0, z)).func_201856_r() == Biome.Category.MUSHROOM && !((List)WGConfig.LAYERS.MUSHROOM_STONE_LIST.get()).isEmpty()) {
                    StoneReplacerFeature.layering((List)WGConfig.LAYERS.MUSHROOM_STONE_LIST.get(), (Integer)WGConfig.LAYERS.MUSHROOM_HEIGHT.get(), reader, x, z, endY);
                    continue;
                }
                if (reader.func_226691_t_(new BlockPos(x, 0, z)).func_201856_r() == Biome.Category.DESERT && !((List)WGConfig.LAYERS.DESERT_STONE_LIST.get()).isEmpty()) {
                    StoneReplacerFeature.layering((List)WGConfig.LAYERS.DESERT_STONE_LIST.get(), (Integer)WGConfig.LAYERS.DESERT_HEIGHT.get(), reader, x, z, endY);
                    continue;
                }
                if (reader.func_226691_t_(new BlockPos(x, 0, z)).func_201856_r() == Biome.Category.MESA && !((List)WGConfig.LAYERS.MESA_STONE_LIST.get()).isEmpty()) {
                    StoneReplacerFeature.layering((List)WGConfig.LAYERS.MESA_STONE_LIST.get(), (Integer)WGConfig.LAYERS.MESA_HEIGHT.get(), reader, x, z, endY);
                    continue;
                }
                if (reader.func_226691_t_(new BlockPos(x, 0, z)).func_201856_r() == Biome.Category.SAVANNA && !((List)WGConfig.LAYERS.SAVANNA_STONE_LIST.get()).isEmpty()) {
                    StoneReplacerFeature.layering((List)WGConfig.LAYERS.SAVANNA_STONE_LIST.get(), (Integer)WGConfig.LAYERS.SAVANNA_HEIGHT.get(), reader, x, z, endY);
                    continue;
                }
                if (reader.func_226691_t_(new BlockPos(x, 0, z)).func_201856_r() == Biome.Category.EXTREME_HILLS && !((List)WGConfig.LAYERS.MOUNTAIN_STONE_LIST.get()).isEmpty()) {
                    StoneReplacerFeature.layering((List)WGConfig.LAYERS.MOUNTAIN_STONE_LIST.get(), (Integer)WGConfig.LAYERS.MOUNTAIN_HEIGHT.get(), reader, x, z, endY);
                    continue;
                }
                if (reader.func_226691_t_(new BlockPos(x, 0, z)).func_201856_r() == Biome.Category.JUNGLE && !((List)WGConfig.LAYERS.JUNGLE_STONE_LIST.get()).isEmpty()) {
                    StoneReplacerFeature.layering((List)WGConfig.LAYERS.JUNGLE_STONE_LIST.get(), (Integer)WGConfig.LAYERS.JUNGLE_HEIGHT.get(), reader, x, z, endY);
                    continue;
                }
                if (reader.func_226691_t_(new BlockPos(x, 0, z)).func_201856_r() == Biome.Category.PLAINS && !((List)WGConfig.LAYERS.PLAINS_STONE_LIST.get()).isEmpty()) {
                    StoneReplacerFeature.layering((List)WGConfig.LAYERS.PLAINS_STONE_LIST.get(), (Integer)WGConfig.LAYERS.PLAINS_HEIGHT.get(), reader, x, z, endY);
                    continue;
                }
                if (reader.func_226691_t_(new BlockPos(x, 0, z)).func_201856_r() == Biome.Category.ICY && !((List)WGConfig.LAYERS.ICY_STONE_LIST.get()).isEmpty()) {
                    StoneReplacerFeature.layering((List)WGConfig.LAYERS.ICY_STONE_LIST.get(), (Integer)WGConfig.LAYERS.ICY_HEIGHT.get(), reader, x, z, endY);
                    continue;
                }
                if (reader.func_226691_t_(new BlockPos(x, 0, z)).func_201856_r() == Biome.Category.SWAMP && !((List)WGConfig.LAYERS.SWAMP_STONE_LIST.get()).isEmpty()) {
                    StoneReplacerFeature.layering((List)WGConfig.LAYERS.SWAMP_STONE_LIST.get(), (Integer)WGConfig.LAYERS.SWAMP_HEIGHT.get(), reader, x, z, endY);
                    continue;
                }
                if (reader.func_226691_t_(new BlockPos(x, 0, z)).func_201856_r() == Biome.Category.BEACH && !((List)WGConfig.LAYERS.BEACH_STONE_LIST.get()).isEmpty()) {
                    StoneReplacerFeature.layering((List)WGConfig.LAYERS.BEACH_STONE_LIST.get(), (Integer)WGConfig.LAYERS.BEACH_HEIGHT.get(), reader, x, z, endY);
                    continue;
                }
                if (reader.func_226691_t_(new BlockPos(x, 0, z)).func_201856_r() == Biome.Category.RIVER && !((List)WGConfig.LAYERS.RIVER_STONE_LIST.get()).isEmpty()) {
                    StoneReplacerFeature.layering((List)WGConfig.LAYERS.RIVER_STONE_LIST.get(), (Integer)WGConfig.LAYERS.RIVER_HEIGHT.get(), reader, x, z, endY);
                    continue;
                }
                if (reader.func_226691_t_(new BlockPos(x, 0, z)).func_201856_r() == Biome.Category.FOREST && !((List)WGConfig.LAYERS.FOREST_STONE_LIST.get()).isEmpty()) {
                    StoneReplacerFeature.layering((List)WGConfig.LAYERS.FOREST_STONE_LIST.get(), (Integer)WGConfig.LAYERS.FOREST_HEIGHT.get(), reader, x, z, endY);
                    continue;
                }
                StoneReplacerFeature.layering((List)WGConfig.LAYERS.OVERWORLD_STONE_LIST.get(), (Integer)WGConfig.LAYERS.OVERWORLD_HEIGHT.get(), reader, x, z, endY);
            }
        }
        return true;
    }

    private static int getLayerHeights(int x, int z, int index, int height) {
        double noise = Biome.field_180281_af.func_215464_a((double)x / (double)NOISE_SCALE + (double)(index * NOISE_OFFSET), (double)z / (double)NOISE_SCALE + (double)(index * NOISE_OFFSET), false);
        return height + (int)Math.round(noise / (Double)WGConfig.LAYERS.LAYER_WIDTH.get());
    }

    private static void layering(List<String> blockList, int avgHeight, ISeedReader reader, int x, int z, int endY) {
        int stoneCount = blockList.size();
        for (int i = 0; i < stoneCount; ++i) {
            if (i == 0) {
                StoneReplacerFeature.replaceStone(reader, x, z, 0, StoneReplacerFeature.getLayerHeights(x, z, i, avgHeight / stoneCount * (i + 1)), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockList.get(i)))).func_176223_P());
                continue;
            }
            if (i < stoneCount - 1) {
                StoneReplacerFeature.replaceStone(reader, x, z, StoneReplacerFeature.getLayerHeights(x, z, i - 1, avgHeight / stoneCount * i), StoneReplacerFeature.getLayerHeights(x, z, i, avgHeight / stoneCount * (i + 1)), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockList.get(i)))).func_176223_P());
                continue;
            }
            StoneReplacerFeature.replaceStone(reader, x, z, StoneReplacerFeature.getLayerHeights(x, z, i - 1, avgHeight / stoneCount * i), endY, ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockList.get(i)))).func_176223_P());
        }
    }

    private static void replaceStone(ISeedReader reader, int x, int z, int StartY, int EndY, BlockState Block2) {
        block5: for (int y = StartY; y <= EndY; ++y) {
            switch ((Integer)WGConfig.LAYERS.OVERWORLD_STONE_LAYERS.get()) {
                case 1: {
                    if (reader.func_180495_p(new BlockPos(x, y, z)).func_177230_c().func_176223_P() != Blocks.field_150348_b.func_176223_P()) continue block5;
                    reader.func_180501_a(new BlockPos(x, y, z), Block2, 2);
                    continue block5;
                }
                case 2: {
                    if (!reader.func_180495_p(new BlockPos(x, y, z)).func_177230_c().getTags().contains(new ResourceLocation("minecraft:base_stone_overworld"))) continue block5;
                    reader.func_180501_a(new BlockPos(x, y, z), Block2, 2);
                    continue block5;
                }
                case 3: {
                    if (!reader.func_180495_p(new BlockPos(x, y, z)).func_177230_c().getTags().contains(new ResourceLocation("forge:stone"))) continue block5;
                    reader.func_180501_a(new BlockPos(x, y, z), Block2, 2);
                    continue block5;
                }
            }
        }
    }
}

