/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rep;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.Restriction;
import xbigellx.rep.physics.IExplosionHandler;
import xbigellx.rep.physics.PhysicsHandler;
import xbigellx.rep.physics.RBPExplosionHandler;
import xbigellx.rep.physics.VanillaExplosionHandler;

@Mod(value="rep")
@Mod.EventBusSubscriber(modid="rep")
public class RealisticExplosionPhysics {
    public static final String MOD_ID = "rep";
    public static final String NAME = "Realistic Explosion Physics";
    public static final String VERSION = "1.0.0";
    public static final String ACCEPTED_MINECRAFT_VERSIONS = "[1.15, 1.15.2]";
    public static final Restriction RBP_VERSION_RESTRICTION = new Restriction((ArtifactVersion)new DefaultArtifactVersion("1.0.0"), true, (ArtifactVersion)new DefaultArtifactVersion("1.1.0"), false);
    private static IExplosionHandler handler;
    private static final List<PhysicsHandler> physicsHandlers;

    public RealisticExplosionPhysics() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonSetup);
    }

    public final void onCommonSetup(FMLCommonSetupEvent event) {
        boolean rbpActive = false;
        for (ModInfo mod : ModList.get().getMods()) {
            if (!mod.getModId().equals("rbp") || !mod.getDisplayName().equals("Realistic Block Physics") || !RBP_VERSION_RESTRICTION.containsVersion(mod.getVersion())) continue;
            rbpActive = true;
        }
        handler = rbpActive ? new RBPExplosionHandler() : new VanillaExplosionHandler();
    }

    public static final void onServerShutdown(FMLServerStoppingEvent event) {
        physicsHandlers.clear();
    }

    @SubscribeEvent
    public static final void onWorldLoaded(WorldEvent.Load event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        PhysicsHandler physicsHandler = new PhysicsHandler((World)event.getWorld(), handler);
        MinecraftForge.EVENT_BUS.register((Object)physicsHandler);
        physicsHandlers.add(physicsHandler);
    }

    @SubscribeEvent
    public static final void onWorldUnloaded(WorldEvent.Unload event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        PhysicsHandler physicsHandler = RealisticExplosionPhysics.getPhysicsHandler((World)event.getWorld());
        if (physicsHandler != null) {
            physicsHandlers.remove(physicsHandler);
            MinecraftForge.EVENT_BUS.unregister((Object)physicsHandler);
        }
    }

    public static final PhysicsHandler getPhysicsHandler(World worldIn) {
        for (int i = 0; i < physicsHandlers.size(); ++i) {
            if (!physicsHandlers.get(i).getWorld().equals(worldIn)) continue;
            return physicsHandlers.get(i);
        }
        return null;
    }

    static {
        physicsHandlers = new ArrayList<PhysicsHandler>();
    }
}

