/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rep.physics;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.block.TNTBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xbigellx.rep.physics.IExplosionHandler;

public class PhysicsHandler {
    private final World world;
    private final IExplosionHandler explosionHandler;

    public PhysicsHandler(World world, IExplosionHandler explosionHandler) {
        this.world = world;
        this.explosionHandler = explosionHandler;
    }

    @SubscribeEvent
    public final void onExplosion(ExplosionEvent.Detonate event) {
        if (event.getWorld().field_72995_K || !event.getWorld().equals(this.world)) {
            return;
        }
        List affectedBlocks = event.getAffectedBlocks();
        ArrayList<BlockPos> movedBlocks = new ArrayList<BlockPos>();
        for (int i = 0; i < affectedBlocks.size(); ++i) {
            boolean hasTileEntity;
            BlockPos pos = (BlockPos)affectedBlocks.get(i);
            boolean aboveExplosion = (double)pos.func_177956_o() >= event.getExplosion().getPosition().field_72448_b;
            boolean isTNT = this.world.func_180495_p(pos).func_177230_c() instanceof TNTBlock;
            boolean isAir = this.world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150350_a);
            boolean bl = hasTileEntity = this.world.func_175625_s(pos) != null;
            if (!aboveExplosion || isTNT || isAir || hasTileEntity) continue;
            double distanceX = (double)pos.func_177958_n() - event.getExplosion().getPosition().field_72450_a;
            double distanceZ = (double)pos.func_177952_p() - event.getExplosion().getPosition().field_72449_c;
            double motionX = distanceX / Math.abs(distanceX) * 0.5;
            double motionY = 0.5;
            double motionZ = distanceZ / Math.abs(distanceZ) * 0.5;
            this.explosionHandler.handleBlock(this, pos, motionX, 0.5, motionZ);
            movedBlocks.add(pos);
        }
        for (BlockPos pos : movedBlocks) {
            affectedBlocks.remove(pos);
        }
    }

    public final World getWorld() {
        return this.world;
    }
}

