/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.config;

import com.mactso.regrowth.config.MyConfig;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;

public class WallFoundationDataManager {
    public static Hashtable<String, WallFoundationItem> wallFoundationsHashtable = new Hashtable();
    private static String defaultWallFoundationString;
    private static String defaultWallFoundationKey;

    public static WallFoundationItem getWallFoundationInfo(String key) {
        WallFoundationItem r;
        String iKey = key + ">0";
        if (wallFoundationsHashtable.isEmpty()) {
            WallFoundationDataManager.wallFoundationsInit();
        }
        if ((r = wallFoundationsHashtable.get(iKey)) == null) {
            iKey = key + ">1";
            r = wallFoundationsHashtable.get(iKey);
        }
        if (r == null) {
            iKey = key + ">2";
            r = wallFoundationsHashtable.get(iKey);
        }
        return r;
    }

    public static String getWallFoundationHashAsString() {
        String returnString = "";
        for (String key : wallFoundationsHashtable.keySet()) {
            String wallFoundationItem = WallFoundationDataManager.wallFoundationsHashtable.get((Object)key).wallFoundation;
            String tempString = key + "," + wallFoundationItem + ";";
            returnString = returnString + tempString;
        }
        return returnString;
    }

    public static void wallFoundationsInit() {
        String result = "";
        wallFoundationsHashtable.clear();
        for (int i = 0; i < MyConfig.defaultWallFoundations.length; ++i) {
            try {
                String wallFoundationBlockKey;
                StringTokenizer st = new StringTokenizer(MyConfig.defaultWallFoundations[i], ",");
                String key = wallFoundationBlockKey = st.nextToken();
                StringTokenizer keySt = new StringTokenizer(wallFoundationBlockKey, ">");
                String keyRegistryDomain = keySt.nextToken();
                if (!Block.field_149771_c.func_148741_d((Object)new ResourceLocation(keyRegistryDomain))) {
                    result = "Regrowth: Block: " + keyRegistryDomain + " not in Forge Registry.  Mispelled?";
                } else {
                    WallFoundationItem w = new WallFoundationItem(wallFoundationBlockKey);
                    wallFoundationsHashtable.put(wallFoundationBlockKey, w);
                    result = "Regrowth: Block: " + keyRegistryDomain + " wall foundation block accepted.";
                }
                if (MyConfig.aDebugLevel <= 0) continue;
                System.out.println(result);
                continue;
            }
            catch (Exception e) {
                System.out.println("Regrowth Debug:  Bad Wall Foundation Config : " + MyConfig.defaultWallFoundations[i]);
            }
        }
    }

    static {
        defaultWallFoundationKey = defaultWallFoundationString = "hbm:default";
    }

    public static class WallFoundationItem {
        String wallFoundation;

        public WallFoundationItem(String wallFoundation) {
            this.wallFoundation = wallFoundation;
        }
    }
}

