/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.blocks;

import com.google.common.collect.ImmutableList;
import it.hurts.sskirillss.relics.crafting.RunicAltarContext;
import it.hurts.sskirillss.relics.crafting.RunicAltarRecipe;
import it.hurts.sskirillss.relics.crafting.SingletonInventory;
import it.hurts.sskirillss.relics.items.RuneItem;
import it.hurts.sskirillss.relics.tiles.RunicAltarTile;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class RunicAltarBlock
extends Block {
    public RunicAltarBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(3.0f).harvestTool(ToolType.PICKAXE).func_235838_a_(state -> 5).func_226896_b_());
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return ImmutableList.of((Object)new ItemStack((IItemProvider)state.func_177230_c()));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (handIn != Hand.MAIN_HAND) {
            return ActionResultType.FAIL;
        }
        RunicAltarTile altar = (RunicAltarTile)world.func_175625_s(pos);
        if (altar == null) {
            return ActionResultType.FAIL;
        }
        Direction direction = hit.func_216354_b();
        if (direction == Direction.DOWN) {
            return ActionResultType.FAIL;
        }
        ItemStack handStack = player.func_184586_b(handIn);
        if (altar.getCraftingProgress() != 0) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = altar.getStack(direction);
        if (stack == null) {
            return ActionResultType.FAIL;
        }
        if (stack.func_190926_b()) {
            if (handStack.func_190926_b()) {
                return ActionResultType.FAIL;
            }
            if (direction != Direction.UP && !(handStack.func_77973_b() instanceof RuneItem)) {
                return ActionResultType.FAIL;
            }
            altar.setStack(handStack.func_77979_a(1), direction);
            Optional optional = world.func_199532_z().func_215371_a(RunicAltarRecipe.RECIPE, (IInventory)new RunicAltarContext(new SingletonInventory(altar.getStack(Direction.UP)), player, altar.getRunes(), altar.getStack(Direction.UP)), world);
            if (!optional.isPresent()) {
                return ActionResultType.FAIL;
            }
            altar.addCraftingProgress(1);
        } else {
            if (player.func_184614_ca().func_190926_b()) {
                player.func_184611_a(Hand.MAIN_HAND, stack);
            } else {
                ItemEntity drop = new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), altar.getStack(direction));
                drop.func_174867_a(0);
                world.func_217376_c((Entity)drop);
            }
            altar.setStack(ItemStack.field_190927_a, direction);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile;
        if (!state.func_203425_a(newState.func_177230_c()) && (tile = worldIn.func_175625_s(pos)) instanceof RunicAltarTile) {
            RunicAltarTile altar = (RunicAltarTile)tile;
            for (Direction direction : Direction.values()) {
                ItemStack stack = altar.getStack(direction);
                if (stack == null || stack.func_190926_b()) continue;
                worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
            }
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new RunicAltarTile();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }
}

