/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.blocks;

import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.RelicScrapItem;
import it.hurts.sskirillss.relics.particles.spark.SparkTintData;
import it.hurts.sskirillss.relics.tiles.RunicAnvilTile;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import org.jetbrains.annotations.Nullable;

public class RunicAnvilBlock
extends FallingBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public RunicAnvilBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151574_g).func_200947_a(SoundType.field_185858_k).func_200943_b(4.0f).harvestTool(ToolType.PICKAXE).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (handIn != Hand.MAIN_HAND || hit.func_216354_b() != Direction.UP || hit.func_216347_e().func_82617_b() - (double)pos.func_177956_o() < 0.75) {
            return ActionResultType.FAIL;
        }
        RunicAnvilTile anvil = (RunicAnvilTile)world.func_175625_s(pos);
        ItemStack heldStack = player.func_184614_ca();
        Random random = world.func_201674_k();
        if (anvil.getStack().func_190926_b()) {
            ItemStack stack = player.func_184614_ca();
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof RelicItem)) {
                return ActionResultType.FAIL;
            }
            anvil.setStack(heldStack.func_77979_a(1));
        } else {
            ItemStack relic = anvil.getStack();
            if (relic.func_77973_b() instanceof RelicItem && heldStack.func_77973_b() == ItemRegistry.RUNIC_HAMMER.get()) {
                ItemStack offhandStack = player.func_184592_cb();
                if (player.func_184811_cZ().func_185141_a(heldStack.func_77973_b())) {
                    return ActionResultType.FAIL;
                }
                int durability = RelicUtils.Durability.getDurability(relic);
                if (offhandStack.func_77973_b() instanceof RelicScrapItem) {
                    if (durability >= RelicUtils.Durability.getMaxDurability(relic.func_77973_b())) {
                        return ActionResultType.FAIL;
                    }
                    RelicUtils.Durability.addDurability(relic, ((RelicScrapItem)offhandStack.func_77973_b()).getReplenishedVolume());
                    offhandStack.func_190918_g(1);
                } else {
                    RelicUtils.Durability.takeDurability(relic, 5);
                }
                heldStack.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
                player.func_184811_cZ().func_185145_a(heldStack.func_77973_b(), 20);
                world.func_184133_a(null, pos, SoundEvents.field_187928_hb, SoundCategory.BLOCKS, 1.0f, 1.0f - random.nextFloat() * 0.5f);
                for (int i = 0; i < random.nextInt(20) + 20; ++i) {
                    world.func_195594_a((IParticleData)new SparkTintData(new Color(255, 255 - random.nextInt(100), 0), 0.025f + random.nextFloat() * 0.05f, 10 - random.nextInt(10)), hit.func_216347_e().func_82615_a() + (double)(MathUtils.randomFloat(random) * 0.075f), hit.func_216347_e().func_82617_b() + (double)0.05f, hit.func_216347_e().func_82616_c() + (double)(MathUtils.randomFloat(random) * 0.075f), (double)(MathUtils.randomFloat(random) * 0.02f), (double)(random.nextFloat() * 0.05f), (double)(MathUtils.randomFloat(random) * 0.02f));
                }
            } else {
                if (heldStack.func_190926_b()) {
                    player.func_184611_a(Hand.MAIN_HAND, relic);
                } else {
                    ItemEntity drop = new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), anvil.getStack());
                    drop.func_174867_a(0);
                    world.func_217376_c((Entity)drop);
                }
                anvil.setStack(ItemStack.field_190927_a);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        ItemStack stack;
        TileEntity tile;
        if (!state.func_203425_a(newState.func_177230_c()) && (tile = worldIn.func_175625_s(pos)) instanceof RunicAnvilTile && (stack = ((RunicAnvilTile)tile).getStack()) != null && !stack.func_190926_b()) {
            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        VoxelShape BASE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
        VoxelShape X_AXIS_AABB = VoxelShapes.func_216384_a((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)3.0, (double)4.0, (double)4.0, (double)13.0, (double)5.0, (double)12.0), Block.func_208617_a((double)4.0, (double)5.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0), Block.func_208617_a((double)0.0, (double)10.0, (double)3.0, (double)16.0, (double)15.0, (double)13.0)});
        VoxelShape Z_AXIS_AABB = VoxelShapes.func_216384_a((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)5.0, (double)13.0), Block.func_208617_a((double)6.0, (double)5.0, (double)4.0, (double)10.0, (double)10.0, (double)12.0), Block.func_208617_a((double)3.0, (double)10.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0)});
        return ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == Direction.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new RunicAnvilTile();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176746_e());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    protected void func_149829_a(FallingBlockEntity entity) {
        entity.func_145806_a(true);
    }

    public void func_176502_a_(World world, BlockPos pos, BlockState oldState, BlockState newState, FallingBlockEntity entity) {
        if (!entity.func_174814_R()) {
            world.func_217379_c(1031, pos, 0);
        }
    }
}

