/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.compat.jei;

import it.hurts.sskirillss.relics.compat.jei.categories.RunicAltarCategory;
import it.hurts.sskirillss.relics.crafting.RunicAltarRecipe;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.RegistryObject;

@JeiPlugin
public class RelicsJEIPlugin
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("relics", "jei_plugin");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new RunicAltarCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        registration.addRecipes((Collection)world.func_199532_z().func_241447_a_(RunicAltarRecipe.RECIPE), RunicAltarCategory.UID);
        IIngredientType type = registration.getIngredientManager().getIngredientType(ItemStack.class);
        ItemRegistry.ITEMS.getEntries().stream().filter(Objects::nonNull).map(RegistryObject::get).filter(item -> item instanceof RelicItem).map(ItemStack::new).forEach(stack -> {
            RelicItem relic = (RelicItem)stack.func_77973_b();
            List<ITextComponent> description = relic.getShiftTooltip((ItemStack)stack);
            if (!description.isEmpty()) {
                registration.addIngredientInfo(stack, type, new String[]{description.stream().map(component -> component.getString() + "\n").collect(Collectors.joining())});
            }
        });
    }
}

